/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DiscontiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public abstract class AbstractCompoundDataset
extends AbstractDataset {
    private static final transient Logger abstractCompoundLogger = LoggerFactory.getLogger(AbstractCompoundDataset.class);
    protected int isize;
    protected Object errorArray = null;
    protected AbstractCompoundDataset errorCompoundData = null;

    @Override
    public int getElementsPerItem() {
        return this.isize;
    }

    @Override
    public IndexIterator getIterator(boolean bl) {
        if (this.shape.length <= 1 || this.dataShape == null) {
            return bl ? this.getSliceIterator(null, null, null) : new ContiguousIterator(this.size, this.isize);
        }
        return new DiscontiguousIterator(this.shape, this.dataShape, this.dataSize, this.isize);
    }

    public IndexIterator getIterator(int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            abstractCompoundLogger.error("Invalid choice of element: {}/{}", (Object)n, (Object)this.isize);
            throw new IllegalArgumentException("Invalid choice of element: " + n + "/" + this.isize);
        }
        IndexIterator indexIterator = this.shape.length <= 1 || this.dataShape == null ? new ContiguousIterator(this.size, this.isize) : new DiscontiguousIterator(this.shape, this.dataShape, this.dataSize, this.isize);
        indexIterator.index += n;
        return indexIterator;
    }

    @Override
    public IndexIterator getSliceIterator(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4;
        int n = this.shape.length;
        if (nArray3 == null) {
            nArray4 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray4[n2] = 1;
                ++n2;
            }
        } else {
            nArray4 = nArray3;
        }
        int[] nArray5 = nArray == null ? new int[n] : nArray;
        int[] nArray6 = nArray2 == null ? new int[n] : nArray2;
        int[] nArray7 = n > 1 || n > 0 && this.shape[0] > 0 ? this.checkSlice(nArray, nArray2, nArray5, nArray6, nArray4) : new int[n];
        if (n <= 1 || this.dataShape == null) {
            return new SliceIterator(this.shape, this.size, nArray5, nArray4, nArray7, this.isize);
        }
        return new SliceIterator(this.dataShape, this.dataSize, nArray5, nArray4, nArray7, this.isize);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AbstractCompoundDataset abstractCompoundDataset = (AbstractCompoundDataset)object;
        return this.isize == abstractCompoundDataset.isize;
    }

    @Override
    public int hashCode() {
        Object object = this.getStoredValue("hash");
        if (object == null) {
            this.calculateHash();
            object = this.getStoredValue("hash");
        }
        return (Integer)object;
    }

    protected static double[] toDoubleArray(Object object, int n) {
        double[] dArray;
        block19: {
            block18: {
                dArray = null;
                if (!(object instanceof double[])) break block18;
                dArray = (double[])object;
                if (dArray.length >= n) break block19;
                dArray = new double[n];
                int n2 = dArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    dArray[n3] = ((double[])object)[n3];
                    ++n3;
                }
                break block19;
            }
            if (object instanceof List) {
                dArray = new double[n];
                List list = (List)object;
                int n4 = list.size();
                if (n4 > 0 && !(list.get(0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n4 = Math.min(n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    dArray[n5] = AbstractCompoundDataset.toReal(list.get(n5));
                    ++n5;
                }
            } else if (object.getClass().isArray()) {
                dArray = new double[n];
                int n6 = Array.getLength(object);
                if (n6 > 0 && !(Array.get(object, 0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n6 = Math.min(n, n6);
                int n7 = 0;
                while (n7 < n6) {
                    dArray[n7] = ((Number)Array.get(object, n7)).doubleValue();
                    ++n7;
                }
            } else if (object instanceof Complex) {
                if (n > 2) {
                    abstractCompoundLogger.error("Complex number will not fit in compound dataset");
                    throw new IllegalArgumentException("Complex number will not fit in compound dataset");
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        dArray = new double[]{((Complex)object).getReal()};
                        break;
                    }
                    case 2: {
                        dArray = new double[]{((Complex)object).getReal(), ((Complex)object).getImaginary()};
                        break;
                    }
                }
            } else if (object instanceof Number) {
                dArray = new double[n];
                double d = ((Number)object).doubleValue();
                int n8 = 0;
                while (n8 < n) {
                    dArray[n8] = d;
                    ++n8;
                }
            }
        }
        return dArray;
    }

    protected static float[] toFloatArray(Object object, int n) {
        float[] fArray;
        block12: {
            block11: {
                fArray = null;
                if (!(object instanceof float[])) break block11;
                fArray = (float[])object;
                if (fArray.length >= n) break block12;
                fArray = new float[n];
                int n2 = fArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    fArray[n3] = ((float[])object)[n3];
                    ++n3;
                }
                break block12;
            }
            if (object instanceof List) {
                fArray = new float[n];
                List list = (List)object;
                int n4 = list.size();
                if (n4 > 0 && !(list.get(0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n4 = Math.min(n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    fArray[n5] = (float)AbstractCompoundDataset.toReal(list.get(n5));
                    ++n5;
                }
            } else if (object.getClass().isArray()) {
                fArray = new float[n];
                int n6 = Array.getLength(object);
                if (n6 > 0 && !(Array.get(object, 0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n6 = Math.min(n, n6);
                int n7 = 0;
                while (n7 < n6) {
                    fArray[n7] = ((Number)Array.get(object, n7)).floatValue();
                    ++n7;
                }
            } else if (object instanceof Number) {
                fArray = new float[n];
                float f = ((Number)object).floatValue();
                int n8 = 0;
                while (n8 < n) {
                    fArray[n8] = f;
                    ++n8;
                }
            }
        }
        return fArray;
    }

    protected static long[] toLongArray(Object object, int n) {
        long[] lArray;
        block12: {
            block11: {
                lArray = null;
                if (!(object instanceof long[])) break block11;
                lArray = (long[])object;
                if (lArray.length >= n) break block12;
                lArray = new long[n];
                int n2 = lArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    lArray[n3] = ((long[])object)[n3];
                    ++n3;
                }
                break block12;
            }
            if (object instanceof List) {
                lArray = new long[n];
                List list = (List)object;
                int n4 = list.size();
                if (n4 > 0 && !(list.get(0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n4 = Math.min(n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    lArray[n5] = AbstractCompoundDataset.toLong(list.get(n5));
                    ++n5;
                }
            } else if (object.getClass().isArray()) {
                lArray = new long[n];
                int n6 = Array.getLength(object);
                if (n6 > 0 && !(Array.get(object, 0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n6 = Math.min(n, n6);
                int n7 = 0;
                while (n7 < n6) {
                    lArray[n7] = ((Number)Array.get(object, n7)).longValue();
                    ++n7;
                }
            } else if (object instanceof Number) {
                lArray = new long[n];
                long l = ((Number)object).longValue();
                int n8 = 0;
                while (n8 < n) {
                    lArray[n8] = l;
                    ++n8;
                }
            }
        }
        return lArray;
    }

    protected static int[] toIntegerArray(Object object, int n) {
        int[] nArray;
        block12: {
            block11: {
                nArray = null;
                if (!(object instanceof int[])) break block11;
                nArray = (int[])object;
                if (nArray.length >= n) break block12;
                nArray = new int[n];
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = ((int[])object)[n3];
                    ++n3;
                }
                break block12;
            }
            if (object instanceof List) {
                nArray = new int[n];
                List list = (List)object;
                int n4 = list.size();
                if (n4 > 0 && !(list.get(0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n4 = Math.min(n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    nArray[n5] = (int)AbstractCompoundDataset.toLong(list.get(n5));
                    ++n5;
                }
            } else if (object.getClass().isArray()) {
                nArray = new int[n];
                int n6 = Array.getLength(object);
                if (n6 > 0 && !(Array.get(object, 0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n6 = Math.min(n, n6);
                int n7 = 0;
                while (n7 < n6) {
                    nArray[n7] = (int)((Number)Array.get(object, n7)).longValue();
                    ++n7;
                }
            } else if (object instanceof Number) {
                nArray = new int[n];
                int n8 = ((Number)object).intValue();
                int n9 = 0;
                while (n9 < n) {
                    nArray[n9] = n8;
                    ++n9;
                }
            }
        }
        return nArray;
    }

    protected static short[] toShortArray(Object object, int n) {
        short[] sArray;
        block12: {
            block11: {
                sArray = null;
                if (!(object instanceof short[])) break block11;
                sArray = (short[])object;
                if (sArray.length >= n) break block12;
                sArray = new short[n];
                int n2 = sArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    sArray[n3] = ((short[])object)[n3];
                    ++n3;
                }
                break block12;
            }
            if (object instanceof List) {
                sArray = new short[n];
                List list = (List)object;
                int n4 = list.size();
                if (n4 > 0 && !(list.get(0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n4 = Math.min(n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    sArray[n5] = (short)AbstractCompoundDataset.toLong(list.get(n5));
                    ++n5;
                }
            } else if (object.getClass().isArray()) {
                sArray = new short[n];
                int n6 = Array.getLength(object);
                if (n6 > 0 && !(Array.get(object, 0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n6 = Math.min(n, n6);
                int n7 = 0;
                while (n7 < n6) {
                    sArray[n7] = (short)((Number)Array.get(object, n7)).longValue();
                    ++n7;
                }
            } else if (object instanceof Number) {
                sArray = new short[n];
                short s = ((Number)object).shortValue();
                int n8 = 0;
                while (n8 < n) {
                    sArray[n8] = s;
                    ++n8;
                }
            }
        }
        return sArray;
    }

    protected static byte[] toByteArray(Object object, int n) {
        byte[] byArray;
        block12: {
            block11: {
                byArray = null;
                if (!(object instanceof byte[])) break block11;
                byArray = (byte[])object;
                if (byArray.length >= n) break block12;
                byArray = new byte[n];
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byArray[n3] = ((byte[])object)[n3];
                    ++n3;
                }
                break block12;
            }
            if (object instanceof List) {
                byArray = new byte[n];
                List list = (List)object;
                int n4 = list.size();
                if (n4 > 0 && !(list.get(0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n4 = Math.min(n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    byArray[n5] = (byte)AbstractCompoundDataset.toLong(list.get(n5));
                    ++n5;
                }
            } else if (object.getClass().isArray()) {
                byArray = new byte[n];
                int n6 = Array.getLength(object);
                if (n6 > 0 && !(Array.get(object, 0) instanceof Number)) {
                    abstractCompoundLogger.error("Given array was not of a numerical primitive type");
                    throw new IllegalArgumentException("Given array was not of a numerical primitive type");
                }
                n6 = Math.min(n, n6);
                int n7 = 0;
                while (n7 < n6) {
                    byArray[n7] = (byte)((Number)Array.get(object, n7)).longValue();
                    ++n7;
                }
            } else if (object instanceof Number) {
                byArray = new byte[n];
                byte by = ((Number)object).byteValue();
                int n8 = 0;
                while (n8 < n) {
                    byArray[n8] = by;
                    ++n8;
                }
            }
        }
        return byArray;
    }

    protected abstract double getFirstValue(int ... var1);

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.getFirstValue(nArray) != 0.0;
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.getFirstValue(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.getFirstValue(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return (int)this.getFirstValue(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return (long)this.getFirstValue(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return (float)this.getFirstValue(nArray);
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.getFirstValue(nArray);
    }

    public abstract void getDoubleArray(double[] var1, int ... var2);

    public abstract AbstractDataset getElements(int var1);

    public abstract void setElements(AbstractDataset var1, int var2);

    public abstract void copyElements(AbstractDataset var1, int var2);

    public AbstractDataset asNonCompoundDataset() {
        return DatasetUtils.createDatasetFromCompoundDataset(this, true);
    }

    protected void calculateHash() {
        int n;
        IndexIterator indexIterator = this.getIterator();
        double d = 0.0;
        while (indexIterator.hasNext()) {
            n = 0;
            while (n < this.isize) {
                double d2 = this.getElementDoubleAbs(indexIterator.index + n);
                d = Double.isInfinite(d2) || Double.isNaN(d2) ? d * 19.0 % 2.147483647E9 : (d * 19.0 + d2) % 2.147483647E9;
                ++n;
            }
        }
        n = (int)d * 19 + this.getDtype() * 17 + this.getElementsPerItem();
        int n2 = this.shape.length;
        int n3 = 0;
        while (n3 < n2) {
            n = n * 17 + this.shape[n3];
            ++n3;
        }
        this.setStoredValue("hash", n);
    }

    @Override
    protected void calculateSummaryStats() {
        int n;
        IndexIterator indexIterator = this.getIterator();
        SummaryStatistics[] summaryStatisticsArray = new SummaryStatistics[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            summaryStatisticsArray[n2] = new SummaryStatistics();
            ++n2;
        }
        double[] dArray = new double[this.isize];
        while (indexIterator.hasNext()) {
            n = 1;
            int n3 = 0;
            while (n3 < this.isize) {
                double d = this.getElementDoubleAbs(indexIterator.index + n3);
                if (Double.isInfinite(d) || Double.isNaN(d)) {
                    n = 0;
                    break;
                }
                dArray[n3] = d;
                ++n3;
            }
            if (n == 0) continue;
            n3 = 0;
            while (n3 < this.isize) {
                summaryStatisticsArray[n3].addValue(dArray[n3]);
                ++n3;
            }
        }
        this.storedValues = new HashMap();
        n = 0;
        while (n < this.isize) {
            this.storedValues.put("stats-" + n, summaryStatisticsArray[n]);
            ++n;
        }
    }

    @Override
    protected void calculateSummaryStats(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        CompoundDoubleDataset compoundDoubleDataset = new CompoundDoubleDataset(this.isize, nArray2);
        CompoundDoubleDataset compoundDoubleDataset2 = new CompoundDoubleDataset(this.isize, nArray2);
        CompoundDoubleDataset compoundDoubleDataset3 = new CompoundDoubleDataset(this.isize, nArray2);
        IndexIterator indexIterator = compoundDoubleDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        double[] dArray = new double[this.isize];
        while (indexIterator.hasNext()) {
            int n4 = 0;
            while (n4 < n) {
                nArray4[n4] = nArray3[n4];
                ++n4;
            }
            nArray4[n4++] = 0;
            while (n4 < n2) {
                nArray4[n4] = nArray3[n4 - 1];
                ++n4;
            }
            SummaryStatistics[] summaryStatisticsArray = new SummaryStatistics[this.isize];
            int n5 = 0;
            while (n5 < this.isize) {
                summaryStatisticsArray[n5] = new SummaryStatistics();
                ++n5;
            }
            n5 = 0;
            while (n5 < n3) {
                nArray4[n] = n5;
                this.getDoubleArray(dArray, nArray4);
                boolean bl = false;
                int n6 = 0;
                while (n6 < this.isize) {
                    if (Double.isInfinite(dArray[n6]) || Double.isNaN(dArray[n6])) {
                        bl = true;
                    }
                    ++n6;
                }
                if (!bl) {
                    n6 = 0;
                    while (n6 < this.isize) {
                        summaryStatisticsArray[n6].addValue(dArray[n6]);
                        ++n6;
                    }
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < this.isize) {
                dArray[n5] = summaryStatisticsArray[n5].getSum();
                ++n5;
            }
            compoundDoubleDataset.set(dArray, nArray4);
            n5 = 0;
            while (n5 < this.isize) {
                dArray[n5] = summaryStatisticsArray[n5].getSum();
                ++n5;
            }
            compoundDoubleDataset2.set(dArray, nArray4);
            n5 = 0;
            while (n5 < this.isize) {
                dArray[n5] = summaryStatisticsArray[n5].getSum();
                ++n5;
            }
            compoundDoubleDataset3.set(dArray, nArray4);
        }
        this.storedValues.put("sum-" + n, compoundDoubleDataset);
        this.storedValues.put("mean-" + n, compoundDoubleDataset2);
        this.storedValues.put("var-" + n, compoundDoubleDataset3);
    }

    @Override
    public Number max() {
        abstractCompoundLogger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public Number min() {
        abstractCompoundLogger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public int[] maxPos() {
        abstractCompoundLogger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public int[] minPos() {
        abstractCompoundLogger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    public double[] maxItem() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getMax();
            ++n;
        }
        return dArray;
    }

    public double[] minItem() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getMin();
            ++n;
        }
        return dArray;
    }

    @Override
    public Object sum() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getSum();
            ++n;
        }
        return dArray;
    }

    @Override
    public Object mean() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getMean();
            ++n;
        }
        return dArray;
    }

    @Override
    public Number variance() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double d = 0.0;
        int n = 0;
        while (n < this.isize) {
            d += ((SummaryStatistics)this.storedValues.get("stats-" + n)).getVariance();
            ++n;
        }
        return d;
    }

    @Override
    public Number rootMeanSquare() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double d = 0.0;
        int n = 0;
        while (n < this.isize) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats-" + n);
            double d2 = summaryStatistics.getMean();
            d += summaryStatistics.getVariance() + d2 * d2;
            ++n;
        }
        return Math.sqrt(d);
    }

    public void setErrorArray(Object object) {
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = Math.pow(AbstractCompoundDataset.toDoubleArray(object, this.isize)[n], 2.0);
            ++n;
        }
        this.errorArray = dArray;
        this.errorData = null;
        this.errorValue = null;
        this.errorCompoundData = null;
    }

    public void setErrorCompoundData(AbstractCompoundDataset abstractCompoundDataset) {
        if (!this.isCompatibleWith(abstractCompoundDataset)) {
            throw new IllegalArgumentException("Error Array Compound dataset is incompartable with this compound dataset");
        }
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[this.isize];
        int n = 0;
        while (n < this.isize) {
            abstractDatasetArray[n] = Maths.square(abstractCompoundDataset.getElements(n));
            ++n;
        }
        this.errorCompoundData = new CompoundDoubleDataset(abstractDatasetArray);
        this.errorArray = null;
        this.errorData = null;
        this.errorValue = null;
    }

    @Override
    public AbstractCompoundDataset getError() {
        if (this.errorData != null) {
            AbstractDataset[] abstractDatasetArray = new AbstractDataset[this.isize];
            int n = 0;
            while (n < this.isize) {
                abstractDatasetArray[n] = Maths.sqrt(this.errorData);
                ++n;
            }
            return new CompoundDoubleDataset(abstractDatasetArray);
        }
        if (this.errorArray != null) {
            AbstractDataset[] abstractDatasetArray = new AbstractDataset[this.isize];
            int n = 0;
            while (n < this.isize) {
                DoubleDataset doubleDataset = new DoubleDataset(this.shape);
                doubleDataset.fill(AbstractCompoundDataset.toDoubleArray(this.errorArray, this.isize)[n]);
                abstractDatasetArray[n] = Maths.sqrt(doubleDataset);
                ++n;
            }
            return new CompoundDoubleDataset(abstractDatasetArray);
        }
        if (this.errorValue != null) {
            AbstractDataset[] abstractDatasetArray = new AbstractDataset[this.isize];
            int n = 0;
            while (n < this.isize) {
                DoubleDataset doubleDataset = new DoubleDataset(this.shape);
                doubleDataset.fill(this.errorValue.doubleValue());
                abstractDatasetArray[n] = Maths.sqrt(doubleDataset);
                ++n;
            }
            return new CompoundDoubleDataset(abstractDatasetArray);
        }
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[this.isize];
        int n = 0;
        while (n < this.isize) {
            abstractDatasetArray[n] = Maths.sqrt(this.errorCompoundData.getElements(n));
            ++n;
        }
        return new CompoundDoubleDataset(abstractDatasetArray);
    }

    public double[] getErrorArray(int ... nArray) {
        if (this.errorCompoundData != null) {
            double[] dArray = new double[this.isize];
            int n = 0;
            while (n < this.isize) {
                dArray[n] = Math.sqrt(this.errorCompoundData.getElements(n).getDouble(nArray));
                ++n;
            }
            return dArray;
        }
        if (this.errorData != null) {
            double[] dArray = new double[this.isize];
            int n = 0;
            while (n < this.isize) {
                dArray[n] = Math.sqrt(this.errorData.getDouble(nArray));
                ++n;
            }
            return dArray;
        }
        if (this.errorValue != null) {
            double[] dArray = new double[this.isize];
            int n = 0;
            while (n < this.isize) {
                dArray[n] = Math.sqrt(this.errorValue.doubleValue());
                ++n;
            }
            return dArray;
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = Math.sqrt(AbstractCompoundDataset.toDoubleArray(this.errorArray, this.isize)[n]);
            ++n;
        }
        return dArray;
    }
}

