/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;

public class AWTImageUtils {
    private AWTImageUtils() {
    }

    public static void createDatasets(Raster raster, AbstractDataset[] abstractDatasetArray, int n, boolean bl) {
        int n2 = abstractDatasetArray.length;
        int n3 = raster.getHeight();
        int n4 = raster.getWidth();
        int n5 = 0;
        while (n5 < n2) {
            switch (n) {
                case 0: {
                    IntegerDataset integerDataset = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    abstractDatasetArray[n5] = bl ? new ByteDataset(integerDataset) : new ShortDataset(integerDataset);
                    break;
                }
                case 2: {
                    IntegerDataset integerDataset = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    abstractDatasetArray[n5] = new ShortDataset(integerDataset);
                    break;
                }
                case 1: {
                    IntegerDataset integerDataset = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    abstractDatasetArray[n5] = bl ? new ShortDataset(integerDataset) : integerDataset;
                    break;
                }
                case 3: {
                    abstractDatasetArray[n5] = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    break;
                }
                case 5: {
                    abstractDatasetArray[n5] = new DoubleDataset(raster.getSamples(0, 0, n4, n3, n5, (double[])null), n3, n4);
                    break;
                }
                case 4: {
                    abstractDatasetArray[n5] = new FloatDataset(raster.getSamples(0, 0, n4, n3, n5, (float[])null), n3, n4);
                }
            }
            ++n5;
        }
    }

    public static AbstractDataset[] makeDatasets(BufferedImage bufferedImage, boolean bl) {
        Raster raster = bufferedImage.getData();
        int n = raster.getNumBands();
        SampleModel sampleModel = raster.getSampleModel();
        int n2 = sampleModel.getDataType();
        int n3 = sampleModel.getSampleSize(0);
        if (n2 == 3) {
            if (n3 <= 8) {
                n2 = 0;
            } else if (n3 <= 16) {
                n2 = 2;
            }
        }
        if (n2 == 1) {
            if (n3 < 8) {
                n2 = 0;
            } else if (n3 < 16) {
                n2 = 2;
            }
        }
        if (n2 == 2 && n3 <= 8) {
            n2 = 0;
        }
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[n];
        AWTImageUtils.createDatasets(raster, abstractDatasetArray, n2, bl);
        return abstractDatasetArray;
    }

    public static BufferedImage makeBufferedImage(AbstractDataset abstractDataset, int n) {
        int[] nArray = abstractDataset.getShape();
        int n2 = nArray[0];
        int n3 = nArray.length == 1 ? 1 : nArray[1];
        int n4 = abstractDataset.getSize();
        BufferedImage bufferedImage = null;
        if (abstractDataset instanceof RGBDataset) {
            RGBDataset rGBDataset = (RGBDataset)abstractDataset;
            bufferedImage = new BufferedImage(n3, n2, 2);
            short s = rGBDataset.max().shortValue();
            IndexIterator indexIterator = rGBDataset.getIterator(true);
            int[] nArray2 = indexIterator.getPos();
            short[] sArray = rGBDataset.getData();
            if (s < 256) {
                while (indexIterator.hasNext()) {
                    int n5 = indexIterator.index;
                    int n6 = 0xFF000000 | (sArray[n5] & 0xFF) << 16 | (sArray[n5 + 1] & 0xFF) << 8 | sArray[n5 + 2] & 0xFF;
                    bufferedImage.setRGB(nArray2[1], nArray2[0], n6);
                }
            } else {
                int n7 = 0;
                while (s >= 256) {
                    ++n7;
                    s = (short)(s >> 2);
                }
                while (indexIterator.hasNext()) {
                    int n8 = indexIterator.index;
                    int n9 = 0xFF000000 | (sArray[n8] >> n7 & 0xFF) << 16 | (sArray[n8 + 1] >> n7 & 0xFF) << 8 | sArray[n8 + 2] >> n7 & 0xFF;
                    bufferedImage.setRGB(nArray2[1], nArray2[0], n9);
                }
            }
        } else {
            DataBuffer dataBuffer = null;
            PixelInterleavedSampleModel pixelInterleavedSampleModel = null;
            IntegerDataset integerDataset = (IntegerDataset)DatasetUtils.cast(abstractDataset, 3);
            if (n <= 8) {
                dataBuffer = new DataBufferByte(n4);
                pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n3, n2, 1, n3, new int[1]);
                bufferedImage = new BufferedImage(n3, n2, 10);
                ((SampleModel)pixelInterleavedSampleModel).setPixels(0, 0, n3, n2, integerDataset.getData(), dataBuffer);
            } else if (n <= 16) {
                dataBuffer = new DataBufferUShort(n4);
                pixelInterleavedSampleModel = new PixelInterleavedSampleModel(1, n3, n2, 1, n3, new int[1]);
                bufferedImage = new BufferedImage(n3, n2, 11);
                ((SampleModel)pixelInterleavedSampleModel).setPixels(0, 0, n3, n2, integerDataset.getData(), dataBuffer);
            } else {
                throw new IllegalArgumentException("Number of bits must be less than or equal to 16");
            }
            WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBuffer, null);
            bufferedImage.setData(writableRaster);
        }
        return bufferedImage;
    }

    public static TiledImage makeTiledImage(AbstractDataset abstractDataset, int n) {
        IndexIterator indexIterator;
        SampleModel sampleModel;
        DataBufferInt dataBufferInt;
        Object object;
        int[] nArray = abstractDataset.getShape();
        int n2 = nArray[0];
        int n3 = nArray.length == 1 ? 1 : nArray[1];
        int n4 = abstractDataset.getSize();
        if (abstractDataset instanceof RGBDataset) {
            object = (RGBDataset)abstractDataset;
            dataBufferInt = new DataBufferInt(n4);
            sampleModel = new SinglePixelPackedSampleModel(3, n3, n2, new int[]{0xFF0000, 65280, 255});
            short s = ((RGBDataset)object).max().shortValue();
            indexIterator = ((AbstractCompoundDataset)object).getIterator(true);
            int[] nArray2 = indexIterator.getPos();
            short[] sArray = ((CompoundShortDataset)object).getData();
            if (s < 256) {
                while (indexIterator.hasNext()) {
                    int n5 = indexIterator.index;
                    int n6 = (sArray[n5] & 0xFF) << 16 | (sArray[n5 + 1] & 0xFF) << 8 | sArray[n5 + 2] & 0xFF;
                    sampleModel.setSample(nArray2[1], nArray2[0], 0, n6, (DataBuffer)dataBufferInt);
                }
            } else {
                int n7 = 0;
                while (s >= 256) {
                    ++n7;
                    s = (short)(s >> 2);
                }
                while (indexIterator.hasNext()) {
                    int n8 = indexIterator.index;
                    int n9 = (sArray[n8] >> n7 & 0xFF) << 16 | (sArray[n8 + 1] >> n7 & 0xFF) << 8 | sArray[n8 + 2] >> n7 & 0xFF;
                    sampleModel.setSample(nArray2[1], nArray2[0], 0, n9, (DataBuffer)dataBufferInt);
                }
            }
        } else if (n <= 32) {
            dataBufferInt = new DataBufferInt(n4);
            sampleModel = RasterFactory.createBandedSampleModel((int)3, (int)n3, (int)n2, (int)1);
            object = (IntegerDataset)abstractDataset.cast(3);
            sampleModel.setPixels(0, 0, n3, n2, ((IntegerDataset)object).getData(), (DataBuffer)dataBufferInt);
        } else {
            dataBufferInt = new DataBufferFloat(n4);
            sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)n3, (int)n2, (int)1);
            object = (FloatDataset)abstractDataset.cast(5);
            sampleModel.setPixels(0, 0, n3, n2, ((FloatDataset)object).getData(), (DataBuffer)dataBufferInt);
        }
        object = Raster.createWritableRaster(sampleModel, dataBufferInt, null);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        indexIterator = new TiledImage(0, 0, n3, n2, 0, 0, sampleModel, colorModel);
        indexIterator.setData((Raster)object);
        return indexIterator;
    }
}

