/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.crystallography;

import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.crystallography.LatticeCell;

public class UnitCell
extends LatticeCell {
    private double[] lengths;
    private double[] angles;

    public UnitCell(double[] dArray, double[] dArray2) {
        this.setLengths(dArray);
        this.setAngles(dArray2);
        double d = Math.toRadians(dArray2[0]);
        double d2 = Math.toRadians(dArray2[1]);
        double d3 = Math.toRadians(dArray2[2]);
        this.a = new Vector3d(dArray[0], 0.0, 0.0);
        this.b = new Vector3d(dArray[1] * Math.cos(d3), dArray[1] * Math.sin(d3), 0.0);
        double d4 = (Math.cos(d) - Math.cos(d2) * Math.cos(d3)) / Math.sin(d3);
        double d5 = d4 / Math.sin(d2);
        d5 = 1.0 - d5 * d5;
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        this.c = new Vector3d(dArray[2] * Math.cos(d2), dArray[2] * d4, dArray[2] * Math.sin(d2) * Math.sqrt(d5));
    }

    public UnitCell(double[] dArray, double[] dArray2, double[] dArray3) {
        this.a = new Vector3d(dArray[0], dArray[1], dArray[2]);
        this.b = new Vector3d(dArray2[0], dArray2[1], dArray2[2]);
        this.c = new Vector3d(dArray3[0], dArray3[1], dArray3[2]);
        double[] dArray4 = new double[]{this.a.length(), this.b.length(), this.c.length()};
        this.setLengths(dArray4);
    }

    public void setLengths(double[] dArray) {
        this.lengths = dArray;
    }

    public double[] getLengths() {
        return this.lengths;
    }

    public void setAngles(double[] dArray) {
        this.angles = dArray;
    }

    public double[] getAngles() {
        return this.angles;
    }
}

