/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.coords;

public class SectorCoords {
    double x;
    double y;
    double r;
    double p;

    public SectorCoords(double d, double d2, boolean bl) {
        if (bl) {
            this.x = d;
            this.y = d2;
            this.r = Math.hypot(this.x, this.y);
            this.p = Math.atan2(this.y, this.x);
            if (this.p < 0.0) {
                this.p += Math.PI * 2;
            }
        } else {
            this.r = d;
            this.p = Math.toRadians(d2);
            this.x = this.r * Math.cos(this.p);
            this.y = this.r * Math.sin(this.p);
        }
    }

    public SectorCoords(int[] nArray, int[] nArray2) {
        int n = nArray2[0] - nArray[0];
        int n2 = nArray2[1] - nArray[1];
        this.r = Math.hypot(n, n2);
        this.p = Math.atan2(n2, n);
        if (this.p < 0.0) {
            this.p += Math.PI * 2;
        }
    }

    public SectorCoords(double[] dArray, int[] nArray) {
        double d = (double)nArray[0] - dArray[0];
        double d2 = (double)nArray[1] - dArray[1];
        this.r = Math.hypot(d, d2);
        this.p = Math.atan2(d2, d);
        if (this.p < 0.0) {
            this.p += Math.PI * 2;
        }
    }

    public SectorCoords(double d, double d2, boolean bl, boolean bl2) {
        if (bl) {
            this.x = d;
            this.y = d2;
            this.r = Math.hypot(this.x, this.y);
            this.p = Math.atan2(this.y, this.x);
            if (this.p < 0.0) {
                this.p += Math.PI * 2;
            }
        } else {
            this.r = d;
            this.p = bl2 ? Math.toRadians(d2) : d2;
            this.x = this.r * Math.cos(this.p);
            this.y = this.r * Math.sin(this.p);
        }
    }

    public double[] getCartesian() {
        double[] dArray = new double[]{this.x, this.y};
        return dArray;
    }

    public double[] getPolar() {
        double[] dArray = new double[]{this.r, Math.toDegrees(this.p)};
        return dArray;
    }

    public double[] getPolarRadians() {
        double[] dArray = new double[]{this.r, this.p};
        return dArray;
    }

    public void addPhi(double d) {
        this.p += Math.toRadians(d);
        this.x = this.r * Math.cos(this.p);
        this.y = this.r * Math.sin(this.p);
    }
}

