/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.ISDAPlotter;
import uk.ac.diamond.scisoft.analysis.MockPlotServer;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;

public abstract class SDAPlotterTestAbstract {
    protected static ISDAPlotter sdaPlotterImplUnderTest;
    protected static MockPlotServer testPlotServer;

    static {
        testPlotServer = new MockPlotServer();
    }

    @Before
    public void clearPlotServer() {
        testPlotServer.clear();
    }

    @Test
    public void testLinePlot() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.arange(100.0, 4);
        sdaPlotterImplUnderTest.plot("MyTest Line", abstractDataset);
        Assert.assertEquals((Object)"MyTest Line", (Object)testPlotServer.getLastPlotname());
        Assert.assertEquals((Object)GuiPlotMode.ONED, (Object)testPlotServer.getLastDataBean().getGuiPlotMode());
        Assert.assertEquals((Object)abstractDataset, (Object)testPlotServer.getLastDataBean().getData().get(0).getData());
    }

    @Test
    public void testImagePlot() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.arange(100.0, 4);
        abstractDataset.setShape(10, 10);
        sdaPlotterImplUnderTest.imagePlot("MyTest Image", abstractDataset);
        Assert.assertEquals((Object)"MyTest Image", (Object)testPlotServer.getLastPlotname());
        Assert.assertEquals((Object)GuiPlotMode.TWOD, (Object)testPlotServer.getLastDataBean().getGuiPlotMode());
        Assert.assertEquals((Object)abstractDataset, (Object)testPlotServer.getLastDataBean().getData().get(0).getData());
    }

    @Test
    public void testImagesPlot() throws Exception {
        AbstractDataset abstractDataset = AbstractDataset.arange(100.0, 4);
        abstractDataset.setShape(10, 10);
        sdaPlotterImplUnderTest.imagesPlot("MyTest Images", new IDataset[]{abstractDataset, abstractDataset});
        Assert.assertEquals((Object)"MyTest Images", (Object)testPlotServer.getLastPlotname());
        Assert.assertEquals((Object)GuiPlotMode.MULTI2D, (Object)testPlotServer.getLastDataBean().getGuiPlotMode());
        Assert.assertEquals((Object)abstractDataset, (Object)testPlotServer.getLastDataBean().getData().get(0).getData());
        Assert.assertEquals((Object)abstractDataset, (Object)testPlotServer.getLastDataBean().getData().get(1).getData());
    }
}

