/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.ISDAPlotter;
import uk.ac.diamond.scisoft.analysis.PlotService;
import uk.ac.diamond.scisoft.analysis.PlotServiceProvider;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.RawBinarySaver;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;

public class SDAPlotterImpl
implements ISDAPlotter {
    private static final Logger logger = LoggerFactory.getLogger(SDAPlotterImpl.class);
    private static ISDAPlotter instance;
    private static final int REST_BETWEEN_PLOTOVERS = 6;

    public static synchronized ISDAPlotter getDefaultInstance() {
        if (instance == null) {
            instance = new SDAPlotterImpl();
        }
        return instance;
    }

    protected PlotService getPlotService() {
        return PlotServiceProvider.getPlotService();
    }

    protected SDAPlotterImpl() {
    }

    private boolean isDataND(IDataset iDataset, int n) {
        return iDataset.getRank() == n;
    }

    private IDataset[] validateXAxis(IDataset iDataset, IDataset ... iDatasetArray) {
        if (iDataset == null) {
            if (iDatasetArray == null || iDatasetArray.length == 0) {
                logger.error("No datasets specified");
                throw new IllegalArgumentException("No datasets specified");
            }
            return new IDataset[]{AbstractDataset.arange(iDatasetArray[0].getSize(), 3)};
        }
        return new IDataset[]{iDataset};
    }

    private IDataset[] validateXAxes(IDataset[] iDatasetArray, IDataset ... iDatasetArray2) {
        if (iDatasetArray == null) {
            return this.validateXAxis(null, iDatasetArray2);
        }
        return iDatasetArray;
    }

    @Override
    public void plot(String string, IDataset iDataset) throws Exception {
        this.plot(string, (String)null, iDataset);
    }

    @Override
    public void plot(String string, String string2, IDataset iDataset) throws Exception {
        this.plot(string, string2, null, iDataset);
    }

    @Override
    public void plot(String string, IDataset iDataset, IDataset iDataset2) throws Exception {
        this.plot(string, (String)null, iDataset, iDataset2);
    }

    @Override
    public void plot(String string, String string2, IDataset iDataset, IDataset iDataset2) throws Exception {
        this.lplot(string, string2, this.validateXAxis(iDataset, iDataset2), null, new IDataset[]{iDataset2}, false);
    }

    @Override
    public void plot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3) throws Exception {
        this.lplot(string, null, this.validateXAxis(iDataset, iDataset3), iDataset2, new IDataset[]{iDataset3}, false);
    }

    @Override
    public void plot(String string, IDataset iDataset, IDataset[] iDatasetArray) throws Exception {
        this.plot(string, null, iDataset, iDatasetArray);
    }

    @Override
    public void plot(String string, String string2, IDataset iDataset, IDataset[] iDatasetArray) throws Exception {
        this.plot(string, string2, this.validateXAxis(iDataset, iDatasetArray), iDatasetArray);
    }

    @Override
    public void plot(String string, IDataset[] iDatasetArray, IDataset[] iDatasetArray2) throws Exception {
        this.plot(string, null, iDatasetArray, iDatasetArray2);
    }

    @Override
    public void plot(String string, String string2, IDataset[] iDatasetArray, IDataset[] iDatasetArray2) throws Exception {
        this.lplot(string, string2, this.validateXAxes(iDatasetArray, iDatasetArray2), null, iDatasetArray2, false);
    }

    @Override
    public void updatePlot(String string, IDataset iDataset) throws Exception {
        this.updatePlot(string, null, iDataset);
    }

    @Override
    public void updatePlot(String string, IDataset iDataset, IDataset iDataset2) throws Exception {
        this.updatePlot(string, iDataset, null, iDataset2);
    }

    @Override
    public void updatePlot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3) throws Exception {
        this.lplot(string, null, this.validateXAxis(iDataset, iDataset3), iDataset2, new IDataset[]{iDataset3}, true);
    }

    @Override
    public void updatePlot(String string, IDataset iDataset, IDataset[] iDatasetArray) throws Exception {
        this.updatePlot(string, this.validateXAxis(iDataset, iDatasetArray), iDatasetArray);
    }

    @Override
    public void updatePlot(String string, IDataset[] iDatasetArray, IDataset[] iDatasetArray2) throws Exception {
        this.lplot(string, null, this.validateXAxes(iDatasetArray, iDatasetArray2), null, iDatasetArray2, true);
    }

    private void lplot(String string, String string2, IDataset[] iDatasetArray, IDataset iDataset, IDataset[] iDatasetArray2, boolean bl) throws Exception {
        Serializable serializable;
        IDataset[] iDatasetArray3 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = iDatasetArray3[n2];
            if (!this.isDataND((IDataset)serializable, 1)) {
                logger.error("Input x dataset has incorrect rank: it has {} dimensions when it should be 1", (Object)serializable.getRank());
                throw new Exception("Input x dataset has incorrect rank: it should be 1");
            }
            ++n2;
        }
        iDatasetArray3 = iDatasetArray2;
        n = iDatasetArray2.length;
        n2 = 0;
        while (n2 < n) {
            serializable = iDatasetArray3[n2];
            if (!this.isDataND((IDataset)serializable, 1)) {
                logger.error("Input y dataset has incorrect rank: it has {} dimensions when it should be 1", (Object)serializable.getRank());
                throw new Exception("Input y dataset has incorrect rank: it should be 1");
            }
            ++n2;
        }
        logger.info("Plot sent to {}", (Object)string);
        serializable = new DataBean(GuiPlotMode.ONED);
        if (iDatasetArray.length == 1) {
            ((DataBean)serializable).addAxis("x-axis", iDatasetArray[0]);
            n2 = 0;
            while (n2 < iDatasetArray2.length) {
                try {
                    ((DataBean)serializable).addData(DataSetWithAxisInformation.createAxisDataSet(iDatasetArray2[n2]));
                }
                catch (DataBeanException dataBeanException) {
                    logger.error("Problem adding data to bean as axis key does not exist");
                    dataBeanException.printStackTrace();
                }
                ++n2;
            }
        } else {
            if (iDatasetArray.length != iDatasetArray2.length) {
                throw new IllegalArgumentException("# xAxis does not match # yAxis");
            }
            n2 = 0;
            while (n2 < iDatasetArray.length) {
                String string3 = "x-axis" + n2;
                ((DataBean)serializable).addAxis(string3, iDatasetArray[n2]);
                try {
                    ((DataBean)serializable).addData(DataSetWithAxisInformation.createAxisDataSet(iDatasetArray2[n2], string3));
                }
                catch (DataBeanException dataBeanException) {
                    logger.error("Problem adding data to bean as axis key does not exist");
                    dataBeanException.printStackTrace();
                }
                ++n2;
            }
        }
        if (iDataset != null) {
            ((DataBean)serializable).addAxis("2nd x-axis", iDataset);
        }
        if (bl) {
            ((DataBean)serializable).putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"UPDATE"));
        }
        if (string2 != null) {
            ((DataBean)serializable).putGuiParameter(GuiParameters.TITLE, (Serializable)((Object)string2));
        }
        this.sendBeansToServer(string, (DataBean)serializable, null);
    }

    @Override
    public void imagePlot(String string, String string2) throws Exception {
        DataHolder dataHolder = null;
        try {
            dataHolder = LoaderFactory.getData(string2, null);
        }
        catch (Exception exception) {
            logger.error("Cannot load file " + string2, (Throwable)exception);
            throw exception;
        }
        try {
            AbstractDataset abstractDataset = dataHolder.getDataset(0);
            abstractDataset.setName(string2);
            this.imagePlot(string, abstractDataset);
        }
        catch (Exception exception) {
            logger.error("Cannot plot non-image file from  " + string2, (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void imagePlot(String string, IDataset iDataset) throws Exception {
        this.imagePlot(string, null, null, iDataset);
    }

    @Override
    public void imagePlot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3) throws Exception {
        if (!this.isDataND(iDataset3, 2)) {
            logger.error("Input dataset has incorrect rank: it has {} dimensions when it should be 2", (Object)iDataset3.getRank());
            throw new Exception("Input dataset has incorrect rank: it should be 2");
        }
        if (iDataset != null && !this.isDataND(iDataset, 1)) {
            String string2 = String.format("X axis dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset.getRank());
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1)) {
            String string3 = String.format("Y axis dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset2.getRank());
            logger.error(string3);
            throw new Exception(string3);
        }
        DataBean dataBean = new DataBean(GuiPlotMode.TWOD);
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        dataSetWithAxisInformation.setAxisMap(axisMapBean);
        dataSetWithAxisInformation.setData(iDataset3);
        try {
            dataBean.addData(dataSetWithAxisInformation);
        }
        catch (DataBeanException dataBeanException) {
            dataBeanException.printStackTrace();
        }
        if (iDataset != null) {
            dataBean.addAxis("x-axis", iDataset);
        }
        if (iDataset2 != null) {
            dataBean.addAxis("y-axis", iDataset2);
        }
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void imagesPlot(String string, IDataset[] iDatasetArray) throws Exception {
        this.imagesPlot(string, null, null, iDatasetArray);
    }

    @Override
    public void imagesPlot(String string, IDataset iDataset, IDataset iDataset2, IDataset[] iDatasetArray) throws Exception {
        if (!this.isDataND(iDatasetArray[0], 2)) {
            logger.error("Input dataset has incorrect rank: it has {} dimensions when it should be 2", (Object)iDatasetArray[0].getRank());
            throw new Exception("Input dataset has incorrect rank: it should be 2");
        }
        if (iDataset != null && !this.isDataND(iDataset, 1)) {
            String string2 = String.format("X axis dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset.getRank());
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1)) {
            String string3 = String.format("Y axis dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset2.getRank());
            logger.error(string3);
            throw new Exception(string3);
        }
        DataBean dataBean = new DataBean(GuiPlotMode.MULTI2D);
        int n = 0;
        while (n < iDatasetArray.length) {
            DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
            AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
            dataSetWithAxisInformation.setAxisMap(axisMapBean);
            dataSetWithAxisInformation.setData(iDatasetArray[n]);
            try {
                dataBean.addData(dataSetWithAxisInformation);
            }
            catch (DataBeanException dataBeanException) {
                dataBeanException.printStackTrace();
            }
            ++n;
        }
        if (iDataset != null) {
            dataBean.addAxis("x-axis", iDataset);
        }
        if (iDataset2 != null) {
            dataBean.addAxis("y-axis", iDataset2);
        }
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void scatter2DPlot(String string, IDataset iDataset, IDataset iDataset2, int n) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1) || iDataset == null) {
            String string2 = String.format("X axis dataset is wrong format or null", new Object[0]);
            logger.error(string2);
            throw new Exception(string2);
        }
        IntegerDataset integerDataset = new IntegerDataset(iDataset.getSize());
        integerDataset.fill(n);
        this.scatter2DPlot(string, iDataset, iDataset2, integerDataset);
    }

    @Override
    public void scatter2DPlot(String string, AbstractCompoundDataset[] abstractCompoundDatasetArray, int[] nArray) throws Exception {
        IDataset[] iDatasetArray = new IntegerDataset[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            iDatasetArray[n] = new IntegerDataset(abstractCompoundDatasetArray[n].getShape()[0]);
            ((IntegerDataset)iDatasetArray[n]).fill(nArray[n]);
            ++n;
        }
        this.scatter2DPlot(string, abstractCompoundDatasetArray, iDatasetArray);
    }

    @Override
    public void scatter2DPlot(String string, AbstractCompoundDataset[] abstractCompoundDatasetArray, IDataset[] iDatasetArray) throws Exception {
        if (abstractCompoundDatasetArray.length != iDatasetArray.length) {
            String string2 = String.format("# of coordPairs does not match # of sizes (%d != %d)", abstractCompoundDatasetArray.length, iDatasetArray.length);
            logger.error(string2);
            throw new Exception(string2);
        }
        DataBean dataBean = new DataBean(GuiPlotMode.SCATTER2D);
        dataBean.putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"NADA"));
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.SCATTER2D);
        int n = 0;
        while (n < iDatasetArray.length) {
            Object object;
            AbstractCompoundDataset abstractCompoundDataset = abstractCompoundDatasetArray[n];
            if (abstractCompoundDataset.getElementsPerItem() != 2) {
                object = String.format("# of elements of coordPair does not equal two it is %d", abstractCompoundDataset.getElementsPerItem());
                logger.error((String)object);
                throw new Exception((String)object);
            }
            if (abstractCompoundDataset.getShape().length != 1) {
                object = String.format("shape of coordpair does not match (expected one but got %d)", abstractCompoundDataset.getShape().length);
                logger.error((String)object);
                throw new Exception((String)object);
            }
            object = abstractCompoundDataset.getElements(0);
            AbstractDataset abstractDataset = abstractCompoundDataset.getElements(1);
            DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
            AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
            dataSetWithAxisInformation.setAxisMap(axisMapBean);
            dataSetWithAxisInformation.setData(iDatasetArray[n]);
            dataBean.addData(dataSetWithAxisInformation);
            dataBean.addAxis("x-axis" + Integer.toString(n), (IDataset)object);
            dataBean.addAxis("y-axis" + Integer.toString(n), abstractDataset);
            ++n;
        }
        this.sendBeansToServer(string, dataBean, guiBean);
    }

    @Override
    public void scatter2DPlot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1)) {
            String string2 = String.format("X coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset.getRank());
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1)) {
            String string3 = String.format("Y coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset2.getRank());
            logger.error(string3);
            throw new Exception(string3);
        }
        DataBean dataBean = new DataBean(GuiPlotMode.SCATTER2D);
        dataBean.putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"NADA"));
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        dataSetWithAxisInformation.setAxisMap(axisMapBean);
        dataSetWithAxisInformation.setData(iDataset3);
        try {
            dataBean.addData(dataSetWithAxisInformation);
        }
        catch (DataBeanException dataBeanException) {
            dataBeanException.printStackTrace();
        }
        if (iDataset != null) {
            dataBean.addAxis("x-axis0", iDataset);
        }
        if (iDataset2 != null) {
            dataBean.addAxis("y-axis0", iDataset2);
        }
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void scatter2DPlotOver(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1) || iDataset == null) {
            String string2 = String.format("X coords dataset has incorrect rank or is null", new Object[0]);
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1) || iDataset2 == null) {
            String string3 = String.format("Y coords dataset has incorrect rank or is null", new Object[0]);
            logger.error(string3);
            throw new Exception(string3);
        }
        Thread.sleep(6L);
        DataBean dataBean = new DataBean(GuiPlotMode.SCATTER2D);
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        dataSetWithAxisInformation.setAxisMap(axisMapBean);
        dataBean.putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"UPDATE"));
        dataSetWithAxisInformation.setData(iDataset3);
        try {
            dataBean.addData(dataSetWithAxisInformation);
        }
        catch (DataBeanException dataBeanException) {
            dataBeanException.printStackTrace();
        }
        dataBean.addAxis("x-axis0", iDataset);
        dataBean.addAxis("y-axis0", iDataset2);
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void scatter2DPlotOver(String string, IDataset iDataset, IDataset iDataset2, int n) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1) || iDataset == null) {
            String string2 = String.format("X coords dataset has incorrect rank or is null", new Object[0]);
            logger.error(string2);
            throw new Exception(string2);
        }
        IntegerDataset integerDataset = new IntegerDataset(iDataset.getSize());
        integerDataset.fill(n);
        this.scatter2DPlotOver(string, iDataset, iDataset2, integerDataset);
    }

    @Override
    public void scatter3DPlot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3, int n) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1) || iDataset == null) {
            String string2 = String.format("X axis dataset is wrong format or null", new Object[0]);
            logger.error(string2);
            throw new Exception(string2);
        }
        IntegerDataset integerDataset = new IntegerDataset(iDataset.getSize());
        integerDataset.fill(n);
        this.scatter3DPlot(string, iDataset, iDataset2, iDataset3, integerDataset);
    }

    @Override
    public void scatter3DPlot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3, IDataset iDataset4) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1)) {
            String string2 = String.format("X coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset.getRank());
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1)) {
            String string3 = String.format("Y coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset2.getRank());
            logger.error(string3);
            throw new Exception(string3);
        }
        if (iDataset3 != null && !this.isDataND(iDataset3, 1)) {
            String string4 = String.format("Z coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset3.getRank());
            logger.error(string4);
            throw new Exception(string4);
        }
        DataBean dataBean = new DataBean(GuiPlotMode.SCATTER3D);
        dataBean.putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"NADA"));
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        dataSetWithAxisInformation.setAxisMap(axisMapBean);
        dataSetWithAxisInformation.setData(iDataset4);
        try {
            dataBean.addData(dataSetWithAxisInformation);
        }
        catch (DataBeanException dataBeanException) {
            dataBeanException.printStackTrace();
        }
        if (iDataset != null) {
            dataBean.addAxis("x-axis", iDataset);
        }
        if (iDataset2 != null) {
            dataBean.addAxis("y-axis", iDataset2);
        }
        if (iDataset3 != null) {
            dataBean.addAxis("z-axis", iDataset3);
        }
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void scatter3DPlotOver(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3, int n) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1) || iDataset == null) {
            String string2 = String.format("X axis dataset is wrong format or null", new Object[0]);
            logger.error(string2);
            throw new Exception(string2);
        }
        IntegerDataset integerDataset = new IntegerDataset(iDataset.getSize());
        integerDataset.fill(n);
        this.scatter3DPlotOver(string, iDataset, iDataset2, iDataset3, integerDataset);
    }

    @Override
    public void scatter3DPlotOver(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3, IDataset iDataset4) throws Exception {
        if (iDataset != null && !this.isDataND(iDataset, 1)) {
            String string2 = String.format("X coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset.getRank());
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1)) {
            String string3 = String.format("Y coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset2.getRank());
            logger.error(string3);
            throw new Exception(string3);
        }
        if (iDataset3 != null && !this.isDataND(iDataset3, 1)) {
            String string4 = String.format("Z coords dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset3.getRank());
            logger.error(string4);
            throw new Exception(string4);
        }
        Thread.sleep(6L);
        DataBean dataBean = new DataBean(GuiPlotMode.SCATTER3D);
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        dataSetWithAxisInformation.setAxisMap(axisMapBean);
        dataBean.putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"UPDATE"));
        dataSetWithAxisInformation.setData(iDataset4);
        try {
            dataBean.addData(dataSetWithAxisInformation);
        }
        catch (DataBeanException dataBeanException) {
            dataBeanException.printStackTrace();
        }
        if (iDataset != null) {
            dataBean.addAxis("x-axis", iDataset);
        }
        if (iDataset2 != null) {
            dataBean.addAxis("y-axis", iDataset2);
        }
        if (iDataset3 != null) {
            dataBean.addAxis("z-axis", iDataset3);
        }
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void surfacePlot(String string, IDataset iDataset) throws Exception {
        this.surfacePlot(string, null, null, iDataset);
    }

    @Override
    public void surfacePlot(String string, IDataset iDataset, IDataset iDataset2) throws Exception {
        this.surfacePlot(string, iDataset, null, iDataset2);
    }

    @Override
    public void surfacePlot(String string, IDataset iDataset, IDataset iDataset2, IDataset iDataset3) throws Exception {
        if (!this.isDataND(iDataset3, 2)) {
            logger.error("Input dataset has incorrect rank: it has {} dimensions when it should be 2", (Object)iDataset3.getRank());
            throw new Exception("Input dataset has incorrect rank: it should be 2");
        }
        if (iDataset != null && !this.isDataND(iDataset, 1)) {
            String string2 = String.format("X axis dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset.getRank());
            logger.error(string2);
            throw new Exception(string2);
        }
        if (iDataset2 != null && !this.isDataND(iDataset2, 1)) {
            String string3 = String.format("Y axis dataset has incorrect rank: it has %d dimensions when it should be 1", iDataset2.getRank());
            logger.error(string3);
            throw new Exception(string3);
        }
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        dataSetWithAxisInformation.setAxisMap(axisMapBean);
        dataSetWithAxisInformation.setData(iDataset3);
        DataBean dataBean = new DataBean(GuiPlotMode.SURF2D);
        try {
            dataBean.addData(dataSetWithAxisInformation);
        }
        catch (DataBeanException dataBeanException) {
            dataBeanException.printStackTrace();
        }
        if (iDataset != null) {
            dataBean.addAxis("x-axis", iDataset);
        }
        if (iDataset2 != null) {
            dataBean.addAxis("y-axis", iDataset2);
        }
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void stackPlot(String string, IDataset iDataset, IDataset[] iDatasetArray) throws Exception {
        this.stackPlot(string, iDataset, iDatasetArray, null);
    }

    @Override
    public void stackPlot(String string, IDataset iDataset, IDataset[] iDatasetArray, IDataset iDataset2) throws Exception {
        this.stackPlot(string, this.validateXAxis(iDataset, iDatasetArray), iDatasetArray, iDataset2);
    }

    @Override
    public void stackPlot(String string, IDataset[] iDatasetArray, IDataset[] iDatasetArray2) throws Exception {
        this.stackPlot(string, iDatasetArray, iDatasetArray2, null);
    }

    @Override
    public void stackPlot(String string, IDataset[] iDatasetArray, IDataset[] iDatasetArray2, IDataset iDataset) throws Exception {
        this.lstackPlot(string, this.validateXAxes(iDatasetArray, iDatasetArray2), iDatasetArray2, iDataset, false);
    }

    @Override
    public void updateStackPlot(String string, IDataset[] iDatasetArray, IDataset[] iDatasetArray2, IDataset iDataset) throws Exception {
        this.lstackPlot(string, this.validateXAxes(iDatasetArray, iDatasetArray2), iDatasetArray2, iDataset, true);
    }

    private void lstackPlot(String string, IDataset[] iDatasetArray, IDataset[] iDatasetArray2, IDataset iDataset, boolean bl) throws Exception {
        Serializable serializable;
        IDataset[] iDatasetArray3 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = iDatasetArray3[n2];
            if (!this.isDataND((IDataset)serializable, 1)) {
                logger.error("Input x dataset has incorrect rank: it has {} dimensions when it should be 1", (Object)serializable.getRank());
                throw new Exception("Input x dataset has incorrect rank: it should be 1");
            }
            ++n2;
        }
        iDatasetArray3 = iDatasetArray2;
        n = iDatasetArray2.length;
        n2 = 0;
        while (n2 < n) {
            serializable = iDatasetArray3[n2];
            if (!this.isDataND((IDataset)serializable, 1)) {
                logger.error("Input y dataset has incorrect rank: it has {} dimensions when it should be 1", (Object)serializable.getRank());
                throw new Exception("Input y dataset has incorrect rank: it should be 1");
            }
            ++n2;
        }
        serializable = new DataBean(GuiPlotMode.ONED_THREED);
        if (iDatasetArray.length == 1) {
            ((DataBean)serializable).addAxis("x-axis", iDatasetArray[0]);
            n2 = 0;
            while (n2 < iDatasetArray2.length) {
                try {
                    ((DataBean)serializable).addData(DataSetWithAxisInformation.createAxisDataSet(iDatasetArray2[n2]));
                }
                catch (DataBeanException dataBeanException) {
                    dataBeanException.printStackTrace();
                }
                ++n2;
            }
        } else {
            if (iDatasetArray.length != iDatasetArray2.length) {
                throw new Exception("# xAxis does not match # yAxis");
            }
            n2 = 0;
            while (n2 < iDatasetArray.length) {
                String string2 = "x-axis" + n2;
                ((DataBean)serializable).addAxis(string2, iDatasetArray[n2]);
                try {
                    ((DataBean)serializable).addData(DataSetWithAxisInformation.createAxisDataSet(iDatasetArray2[n2], string2));
                }
                catch (DataBeanException dataBeanException) {
                    dataBeanException.printStackTrace();
                }
                ++n2;
            }
        }
        if (iDataset != null) {
            if (!this.isDataND(iDataset, 1)) {
                logger.error("Input z dataset has incorrect rank: it has {} dimensions when it should be 1", (Object)iDataset.getRank());
                throw new Exception("Input z dataset has incorrect rank: it should be 1");
            }
            ((DataBean)serializable).addAxis("z-axis", iDataset);
        }
        if (bl) {
            ((DataBean)serializable).putGuiParameter(GuiParameters.PLOTOPERATION, (Serializable)((Object)"UPDATE"));
        }
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.ONED_THREED);
        this.sendBeansToServer(string, (DataBean)serializable, guiBean);
    }

    @Override
    public int scanForImages(String string, String string2) throws Exception {
        return this.scanForImages(string, string2, 0, LISTOFSUFFIX, -1, true);
    }

    @Override
    public int scanForImages(String string, String string2, int n, int n2) throws Exception {
        return this.scanForImages(string, string2, 0, LISTOFSUFFIX, -1, true, n, n2);
    }

    @Override
    public int scanForImages(String string, String string2, int n) throws Exception {
        return this.scanForImages(string, string2, n, LISTOFSUFFIX, -1, true);
    }

    @Override
    public int scanForImages(String string, String string2, int n, String[] stringArray, int n2, boolean bl) throws Exception {
        return this.scanForImages(string, string2, n, stringArray, n2, bl, Integer.MAX_VALUE, 1);
    }

    @Override
    public int scanForImages(String string, String string2, int n, String string3, String[] stringArray, int n2, boolean bl) throws Exception {
        return this.scanForImages(string, string2, n, string3, stringArray, n2, bl, Integer.MAX_VALUE, 1);
    }

    @Override
    public int scanForImages(String string, String string2, int n, String[] stringArray, int n2, boolean bl, int n3, int n4) throws Exception {
        return this.scanForImages(string, string2, n, null, stringArray, n2, bl, n3, n4);
    }

    @Override
    public int scanForImages(String string, String string2, int n, String string3, String[] stringArray, int n2, boolean bl, int n3, int n4) throws Exception {
        File file = new File(string2);
        PlotService plotService = this.getPlotService();
        int n5 = 0;
        if (plotService != null) {
            int n6 = 0;
            if (file.isDirectory()) {
                GuiBean guiBean = new GuiBean();
                guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
                File[] fileArray = file.listFiles();
                if (stringArray == null) {
                    stringArray = LISTOFSUFFIX;
                }
                List<String> list = this.filterImages(fileArray, string3, stringArray);
                int n7 = list.size();
                int n8 = (int)(n2 > 0 ? Math.ceil((double)n7 / (double)n2) : Math.ceil(Math.sqrt(n7)));
                if (n8 == 0) {
                    n8 = 1;
                }
                int n9 = n2 > 0 ? n2 : n8;
                guiBean.put(GuiParameters.IMAGEGRIDSIZE, (Serializable)new Integer[]{n8, n9});
                plotService.updateGui(string, guiBean);
                guiBean.remove(GuiParameters.IMAGEGRIDSIZE);
                if (n7 == 0) {
                    return n5;
                }
                switch (n) {
                    case 1: {
                        Collections.sort(list);
                        break;
                    }
                    case 2: {
                        this.chronoSort(list);
                        break;
                    }
                }
                Iterator<String> iterator = list.iterator();
                if (bl) {
                    while (iterator.hasNext() && n6 < n3) {
                        String string4 = iterator.next();
                        if (n6 % n4 == 0) {
                            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string4));
                            plotService.updateGui(string, guiBean);
                            ++n5;
                        }
                        ++n6;
                    }
                } else {
                    int n10 = 0;
                    int n11 = 0;
                    while (iterator.hasNext() && n6 < n3) {
                        String string5 = iterator.next();
                        if (n6 % n4 == 0) {
                            guiBean.put(GuiParameters.IMAGEGRIDXPOS, Integer.valueOf(n10));
                            guiBean.put(GuiParameters.IMAGEGRIDYPOS, Integer.valueOf(n11));
                            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string5));
                            plotService.updateGui(string, guiBean);
                            ++n5;
                            ++n11;
                        }
                        ++n6;
                        if (n11 != n8) continue;
                        n11 = 0;
                        ++n10;
                    }
                }
            } else {
                logger.warn("Given path was not a directory");
            }
        }
        return n5;
    }

    private List<String> filterImages(File[] fileArray, String string, String[] stringArray) {
        ArrayList<String> arrayList;
        block7: {
            int n;
            block6: {
                arrayList = new ArrayList<String>();
                if (stringArray != null || string != null) break block6;
                int n2 = 0;
                while (n2 < fileArray.length) {
                    arrayList.add(fileArray[n2].getAbsolutePath());
                    ++n2;
                }
                break block7;
            }
            StringBuilder stringBuilder = new StringBuilder(string == null ? ".*" : string);
            if (stringArray == null || stringArray.length <= 0) break block7;
            if (stringArray.length == 1) {
                stringBuilder.append(stringArray[0]);
            } else {
                stringBuilder.append('(');
                String[] stringArray2 = stringArray;
                n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String string2 = stringArray2[n3];
                    stringBuilder.append(string2);
                    stringBuilder.append('|');
                    ++n3;
                }
                int n4 = stringBuilder.length();
                stringBuilder.replace(n4 - 1, n4, ")");
            }
            Pattern pattern = Pattern.compile(stringBuilder.toString());
            File[] fileArray2 = fileArray;
            int n5 = fileArray.length;
            n = 0;
            while (n < n5) {
                File file = fileArray2[n];
                Matcher matcher = pattern.matcher(file.getName().toLowerCase());
                if (matcher.matches()) {
                    arrayList.add(file.getAbsolutePath());
                }
                ++n;
            }
        }
        return arrayList;
    }

    private void chronoSort(List<String> list) {
        TreeMap<Long, String> treeMap = new TreeMap<Long, String>();
        for (String string : list) {
            treeMap.put(new File(string).lastModified(), string);
        }
        list.clear();
        list.addAll(treeMap.values());
    }

    @Override
    public void volumePlot(String string, String string2, int n, int n2, int n3, int n4, int n5) throws Exception {
        PlotService plotService = this.getPlotService();
        if (plotService != null) {
            GuiBean guiBean = new GuiBean();
            guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.VOLUME);
            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
            guiBean.put(GuiParameters.VOLUMEHEADERSIZE, Integer.valueOf(n));
            guiBean.put(GuiParameters.VOLUMEVOXELTYPE, Integer.valueOf(n2));
            guiBean.put(GuiParameters.VOLUMEXDIM, Integer.valueOf(n3));
            guiBean.put(GuiParameters.VOLUMEYDIM, Integer.valueOf(n4));
            guiBean.put(GuiParameters.VOLUMEZDIM, Integer.valueOf(n5));
            plotService.updateGui(string, guiBean);
        }
    }

    @Override
    public void volumePlot(String string, IDataset iDataset) throws Exception {
        if (!this.isDataND(iDataset, 3)) {
            logger.error("Input dataset has incorrect rank: it has {} dimensions when it should be 3", (Object)iDataset.getRank());
            throw new Exception("Input dataset has incorrect rank: it should be 3");
        }
        DataHolder dataHolder = new DataHolder();
        try {
            Object object;
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
            if (abstractDataset instanceof AbstractCompoundDataset) {
                object = (AbstractCompoundDataset)abstractDataset;
                abstractDataset = ((AbstractCompoundDataset)object).getElements(0);
            }
            switch (abstractDataset.getDtype()) {
                case 0: {
                    abstractDataset = abstractDataset.cast(5);
                    break;
                }
                case 6: {
                    abstractDataset = abstractDataset.cast(5);
                    break;
                }
                case 3: {
                    abstractDataset = abstractDataset.cast(5);
                    break;
                }
                case 4: {
                    abstractDataset = abstractDataset.cast(5);
                }
            }
            object = new int[]{abstractDataset.getShape()[2], abstractDataset.getShape()[1], abstractDataset.getShape()[0]};
            abstractDataset.setShape((int[])object);
            String string2 = this.saveTempFile(dataHolder, abstractDataset);
            this.volumePlot(string, string2);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            throw new Exception("Failed to save to temporary file");
        }
    }

    @Override
    public void volumePlot(String string, String string2) throws Exception {
        PlotService plotService = this.getPlotService();
        if (plotService != null) {
            GuiBean guiBean = new GuiBean();
            guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.VOLUME);
            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
            plotService.updateGui(string, guiBean);
        }
    }

    @Override
    public void clearPlot(String string) throws Exception {
        PlotService plotService = this.getPlotService();
        if (plotService != null) {
            GuiBean guiBean = new GuiBean();
            guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.EMPTY);
            plotService.updateGui(string, guiBean);
        }
    }

    @Override
    public void setupNewImageGrid(String string, int n, int n2) throws Exception {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
        guiBean.put(GuiParameters.IMAGEGRIDSIZE, (Serializable)new Integer[]{n, n2});
        this.setGuiBean(string, guiBean);
    }

    @Override
    public void setupNewImageGrid(String string, int n) throws Exception {
        int n2 = (int)Math.ceil(Math.sqrt(n));
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = n2;
        this.setupNewImageGrid(string, n2, n3);
    }

    @Override
    public void plotImageToGrid(String string, IDataset[] iDatasetArray) throws Exception {
        this.plotImageToGrid(string, iDatasetArray, false);
    }

    @Override
    public void plotImageToGrid(String string, IDataset[] iDatasetArray, boolean bl) throws Exception {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
        DataHolder dataHolder = new DataHolder();
        int n = 0;
        while (n < iDatasetArray.length) {
            if (bl) {
                try {
                    String string2 = this.saveTempFile(dataHolder, iDatasetArray[n]);
                    guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
                }
                catch (ScanFileHolderException scanFileHolderException) {
                    throw new Exception("Failed to save to temporary file");
                }
            } else {
                guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)iDatasetArray[n].getName()));
            }
            this.setGuiBean(string, guiBean);
            ++n;
        }
    }

    @Override
    public void plotImageToGrid(String string, String string2, int n, int n2) throws Exception {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
        guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
        guiBean.put(GuiParameters.IMAGEGRIDXPOS, Integer.valueOf(n));
        guiBean.put(GuiParameters.IMAGEGRIDYPOS, Integer.valueOf(n2));
        this.setGuiBean(string, guiBean);
    }

    @Override
    public void plotImageToGrid(String string, String string2) throws Exception {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
        guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
        this.setGuiBean(string, guiBean);
    }

    @Override
    public void plotImageToGrid(String string, IDataset iDataset) throws Exception {
        this.plotImageToGrid(string, iDataset, false);
    }

    @Override
    public void plotImageToGrid(String string, IDataset iDataset, boolean bl) throws Exception {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
        if (bl) {
            DataHolder dataHolder = new DataHolder();
            try {
                String string2 = this.saveTempFile(dataHolder, iDataset);
                guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
            }
            catch (ScanFileHolderException scanFileHolderException) {
                throw new Exception("Failed to save to temporary file");
            }
        } else {
            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)iDataset.getName()));
        }
        this.setGuiBean(string, guiBean);
    }

    @Override
    public void plotImageToGrid(String string, IDataset iDataset, int n, int n2) throws Exception {
        this.plotImageToGrid(string, iDataset, n, n2, false);
    }

    @Override
    public void plotImageToGrid(String string, IDataset iDataset, int n, int n2, boolean bl) throws Exception {
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, GuiPlotMode.IMGEXPL);
        guiBean.put(GuiParameters.IMAGEGRIDXPOS, Integer.valueOf(n));
        guiBean.put(GuiParameters.IMAGEGRIDYPOS, Integer.valueOf(n2));
        if (bl) {
            DataHolder dataHolder = new DataHolder();
            try {
                String string2 = this.saveTempFile(dataHolder, iDataset);
                guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string2));
            }
            catch (ScanFileHolderException scanFileHolderException) {
                throw new Exception("Failed to save to temporary file");
            }
        } else {
            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)iDataset.getName()));
        }
        this.setGuiBean(string, guiBean);
    }

    protected String saveTempFile(DataHolder dataHolder, IDataset iDataset) throws ScanFileHolderException {
        try {
            File file = File.createTempFile("image-explorer-store-", ".raw");
            String string = "/dls/tmp/rkn21281";
            File file2 = new File(string);
            if (!file2.exists()) {
                file2.mkdir();
            }
            String string2 = String.valueOf(file2.getAbsolutePath()) + System.getProperty("file.separator") + file.getName();
            dataHolder.setDataset("Data", (ILazyDataset)iDataset);
            new RawBinarySaver(string2).saveFile(dataHolder);
            return string2;
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("Couldn't save file", iOException);
        }
    }

    @Override
    public void viewNexusTree(String string, HDF5File hDF5File) throws Exception {
        logger.info("Tree sent to {}", (Object)string);
        DataBean dataBean = new DataBean(null);
        dataBean.addHDF5Tree(hDF5File);
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public void viewHDF5Tree(String string, HDF5File hDF5File) throws Exception {
        logger.info("Tree sent to {}", (Object)string);
        DataBean dataBean = new DataBean(null);
        dataBean.addHDF5Tree(hDF5File);
        this.sendBeansToServer(string, dataBean, null);
    }

    private void sendBeansToServer(String string, DataBean dataBean, GuiBean guiBean) throws Exception {
        PlotService plotService = this.getPlotService();
        if (plotService != null) {
            if (guiBean != null) {
                guiBean.remove(GuiParameters.PLOTID);
                plotService.updateGui(string, guiBean);
            }
            if (dataBean != null) {
                plotService.setData(string, dataBean);
            }
        }
    }

    @Override
    public void setGuiBean(String string, GuiBean guiBean) throws Exception {
        this.sendBeansToServer(string, null, guiBean);
    }

    @Override
    public GuiBean getGuiBean(String string) throws Exception {
        PlotService plotService = this.getPlotService();
        return plotService.getGuiState(string);
    }

    @Override
    public void setDataBean(String string, DataBean dataBean) throws Exception {
        this.sendBeansToServer(string, dataBean, null);
    }

    @Override
    public DataBean getDataBean(String string) throws Exception {
        PlotService plotService = this.getPlotService();
        return plotService.getData(string);
    }

    @Override
    public GuiBean getGuiStateForPlotMode(String string, GuiPlotMode guiPlotMode) {
        GuiBean guiBean;
        try {
            guiBean = this.getGuiBean(string);
            if (guiBean != null && guiBean.containsKey(GuiParameters.PLOTMODE)) {
                if (!guiBean.get(GuiParameters.PLOTMODE).equals(guiPlotMode)) {
                    guiBean = null;
                } else {
                    guiBean.remove(GuiParameters.PLOTID);
                }
            }
        }
        catch (Exception exception) {
            guiBean = null;
        }
        if (guiBean == null) {
            guiBean = new GuiBean();
            guiBean.put(GuiParameters.PLOTMODE, guiPlotMode);
        }
        return guiBean;
    }

    @Override
    public String[] getGuiNames() throws Exception {
        return this.getPlotService().getGuiNames();
    }
}

