/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIServerProvider {
    private static final Logger logger = LoggerFactory.getLogger(RMIServerProvider.class);
    private static RMIServerProvider instance = new RMIServerProvider();
    private int port = 0;
    private Registry serverRegistry = null;
    private List<Remote> remotes = new ArrayList<Remote>();

    public static RMIServerProvider getInstance() {
        return instance;
    }

    private RMIServerProvider() {
    }

    public synchronized void exportAndRegisterObject(String string, Remote remote) throws AlreadyBoundException, IOException {
        Object object;
        if (Boolean.getBoolean("uk.ac.diamond.scisoft.analysis.rmiserverprovider.disable")) {
            throw new RemoteException("Analysis RPC Server disabled with property uk.ac.diamond.scisoft.analysis.rmiserverprovider.disable");
        }
        if (this.port == 0) {
            object = null;
            try {
                object = new ServerSocket(0);
                this.port = ((ServerSocket)object).getLocalPort();
            }
            finally {
                if (object != null) {
                    ((ServerSocket)object).close();
                }
            }
            if (this.port < 0) {
                throw new IOException("Unable to obtain free port, is a firewall running?");
            }
        }
        object = UnicastRemoteObject.exportObject(remote, this.port);
        if (this.serverRegistry == null) {
            this.serverRegistry = LocateRegistry.createRegistry(this.port);
            logger.info("Starting RMI Server on port " + this.port);
        }
        logger.info("Adding " + string);
        this.serverRegistry.bind(string, (Remote)object);
        this.remotes.add(remote);
    }

    public void setPort(int n) throws IllegalStateException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Port number must be >= 0");
        }
        if (this.serverRegistry != null) {
            throw new IllegalStateException("RMI Server Provider has already used the existing port, setPort must be called before any handlers are added.");
        }
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }
}

