/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import uk.ac.diamond.scisoft.analysis.ThreadStreamReader;

public class PythonHelper {
    private static final String PYTHON = "python";

    public static boolean enablePythonTests() {
        return false;
    }

    public static String runPythonScript(String string, boolean bl) throws Exception {
        return PythonHelper.runPythonScript(string, null, bl);
    }

    public static String runPythonScript(String string, String[] stringArray, boolean bl) throws Exception {
        return PythonHelper.readAndProcessOutput(bl, new String[]{PYTHON, "-c", string}, stringArray);
    }

    public static String runPythonFile(String string, boolean bl) throws Exception {
        return PythonHelper.runPythonFile(string, null, bl);
    }

    public static String runPythonFile(String string, String[] stringArray, boolean bl) throws Exception {
        return PythonHelper.runPythonFile(string, stringArray, null, bl);
    }

    public static String runPythonFile(String string, String[] stringArray, String[] stringArray2, boolean bl) throws Exception {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray3 = new String[2 + stringArray.length];
        stringArray3[0] = PYTHON;
        stringArray3[1] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray3[n + 2] = stringArray[n];
            ++n;
        }
        return PythonHelper.readAndProcessOutput(bl, stringArray3, stringArray2);
    }

    public static PythonRunInfo runPythonScriptBackground(String string) throws Exception {
        return PythonHelper.launch(new String[]{PYTHON, "-c", string}, null);
    }

    public static PythonRunInfo runPythonFileBackground(String string) throws Exception {
        return PythonHelper.runPythonFileBackground(string, null);
    }

    public static PythonRunInfo runPythonFileBackground(String string, String[] stringArray) throws Exception {
        return PythonHelper.runPythonFileBackground(string, stringArray, null);
    }

    public static PythonRunInfo runPythonFileBackground(String string, String[] stringArray, String[] stringArray2) throws Exception {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray3 = new String[2 + stringArray.length];
        stringArray3[0] = PYTHON;
        stringArray3[1] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray3[n + 2] = stringArray[n];
            ++n;
        }
        return PythonHelper.launch(stringArray3, stringArray2);
    }

    private static String readAndProcessOutput(boolean bl, String[] stringArray, String[] stringArray2) throws Exception {
        PythonRunInfo pythonRunInfo = PythonHelper.launch(stringArray, stringArray2);
        return pythonRunInfo.getStdout(bl);
    }

    private static PythonRunInfo launch(String[] stringArray, String[] stringArray2) throws IOException {
        Assume.assumeTrue((boolean)PythonHelper.enablePythonTests());
        PythonRunInfo pythonRunInfo = new PythonRunInfo();
        pythonRunInfo.process = Runtime.getRuntime().exec(stringArray, stringArray2);
        pythonRunInfo.std = new ThreadStreamReader(pythonRunInfo.process.getInputStream(), false);
        pythonRunInfo.err = new ThreadStreamReader(pythonRunInfo.process.getErrorStream(), false);
        pythonRunInfo.std.start();
        pythonRunInfo.err.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return pythonRunInfo;
    }

    public static String[] parseArray(String string) {
        String[] stringArray = string.split("', '");
        if (stringArray.length > 0) {
            stringArray[0] = stringArray[0].substring(1);
            int n = stringArray.length - 1;
            stringArray[n] = stringArray[n].substring(0, stringArray[n].length() - 1);
            if (n == 0 && stringArray[n].length() == 0) {
                stringArray = new String[]{};
            } else {
                stringArray[0] = stringArray[0].substring(1);
                stringArray[n] = stringArray[n].substring(0, stringArray[n].length() - 1);
            }
        }
        return stringArray;
    }

    public static class PythonRunInfo {
        ThreadStreamReader std;
        ThreadStreamReader err;
        Process process;

        public void terminate() {
            this.process.destroy();
        }

        public String getStdout(boolean bl) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            String string = this.err.getContents();
            String string2 = this.std.getContents();
            boolean bl2 = (!bl || "".equals(string2)) && "".equals(string);
            Assert.assertTrue((String)("Unexpected output on stderr:\n" + string + "\nor stdout:\n" + string2 + "\n"), (boolean)bl2);
            return string2;
        }

        public boolean hasTerminated() {
            try {
                this.process.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return false;
            }
        }
    }
}

