/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.PlotService;
import uk.ac.diamond.scisoft.analysis.RMIClientProvider;

public class PlotServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(PlotServiceProvider.class);
    private static PlotService plotService = null;

    public static PlotService getPlotService() {
        return PlotServiceProvider.getPlotService(null);
    }

    public static PlotService getPlotService(String string) {
        if (plotService == null) {
            try {
                plotService = PlotServerProvider.getExistingPlotServer();
                if (plotService == null) {
                    throw new NullPointerException("No registered plotserver");
                }
                logger.info("Using registered plotserver");
            }
            catch (Exception exception) {
                try {
                    plotService = (PlotService)((Object)RMIClientProvider.getInstance().lookup(string, "RMIPlotServer"));
                    logger.info("Using RMIPlotService");
                }
                catch (Exception exception2) {
                    logger.info("Couldn't get any PlotService ", (Throwable)exception2);
                }
            }
        }
        return plotService;
    }

    public static void setPlotService(PlotService plotService) {
        PlotServiceProvider.plotService = plotService;
    }
}

