/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.AnalysisRpcServerProvider;
import uk.ac.diamond.scisoft.analysis.ISDAPlotter;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServiceProvider;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.diamond.scisoft.analysis.SDAPlotterImpl;
import uk.ac.diamond.scisoft.analysis.plotserver.RMIPlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.SimplePlotServer;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcGenericInstanceDispatcher;

public class PlotServerProvider {
    public static final String PLOT_SERVER_NAME = "plot_server";
    private static final Logger logger = LoggerFactory.getLogger(PlotServerProvider.class);
    static PlotServer plotServer;

    public static synchronized PlotServer getExistingPlotServer() {
        return plotServer;
    }

    public static synchronized PlotServer getPlotServer() {
        if (plotServer == null) {
            logger.info("PlotServer instance not set - using local created PlotServer instead");
            try {
                plotServer = new RMIPlotServer();
            }
            catch (Exception exception) {
                logger.info("RMIPlotserver can't be created, using SimplePlotServer instead", (Throwable)exception);
                plotServer = new SimplePlotServer();
            }
            try {
                AnalysisRpcGenericInstanceDispatcher analysisRpcGenericInstanceDispatcher = new AnalysisRpcGenericInstanceDispatcher(ISDAPlotter.class, SDAPlotterImpl.getDefaultInstance());
                AnalysisRpcServerProvider.getInstance().addHandler(SDAPlotter.class.getSimpleName(), analysisRpcGenericInstanceDispatcher);
                PlotServiceProvider.setPlotService(plotServer);
            }
            catch (Exception exception) {
                logger.error("Error starting Analysis RPC wrapper", (Throwable)exception);
            }
        }
        return plotServer;
    }

    public static void setPlotServer(PlotServer plotServer) {
        PlotServerProvider.plotServer = plotServer;
        logger.info("setPlotServer called with plotServer " + plotServer);
    }
}

