/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import gda.observable.IObserver;
import junit.framework.AssertionFailedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.AbstractPlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;

public class MockPlotServer
extends AbstractPlotServer {
    private static final Logger logger = LoggerFactory.getLogger(MockPlotServer.class);
    private String lastPlotname;
    private GuiBean lastGuiBean;
    private DataBean lastDataBean;

    public void clear() {
        this.lastPlotname = null;
        this.lastGuiBean = null;
        this.lastDataBean = null;
        this.getGuiStore().clear();
        this.getDataStore().clear();
    }

    public String getLastPlotname() {
        return this.lastPlotname;
    }

    public GuiBean getLastGuiBean() {
        return this.lastGuiBean;
    }

    public DataBean getLastDataBean() {
        return this.lastDataBean;
    }

    @Override
    public void updateGui(String string, GuiBean guiBean) throws Exception {
        super.updateGui(string, guiBean);
        this.lastPlotname = string;
        this.lastGuiBean = guiBean;
        logger.info("Mock-updating gui with");
        logger.info("guiName = " + string);
        logger.info("guiData = " + guiBean);
    }

    @Override
    public void setData(String string, DataBean dataBean) throws Exception {
        super.setData(string, dataBean);
        this.lastPlotname = string;
        this.lastDataBean = dataBean;
        logger.info("Mock-setting data with");
        logger.info("guiName = " + string);
        logger.info("plotData = " + dataBean);
    }

    @Override
    public void updateData(String string) throws Exception {
        throw new AssertionFailedError("No Implementation, method should not be called.");
    }

    @Override
    public boolean isServerLocal() throws Exception {
        throw new AssertionFailedError("No Implementation, method should not be called.");
    }

    public void addIObserver(IObserver iObserver) {
        throw new AssertionFailedError("No Implementation, method should not be called.");
    }

    public void deleteIObserver(IObserver iObserver) {
        throw new AssertionFailedError("No Implementation, method should not be called.");
    }

    public void deleteIObservers() {
        throw new AssertionFailedError("No Implementation, method should not be called.");
    }
}

