/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcException;
import uk.ac.diamond.scisoft.analysis.rpc.AnalysisRpcServer;
import uk.ac.diamond.scisoft.analysis.rpc.IAnalysisRpcHandler;

public class AnalysisRpcServerProvider {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRpcServerProvider.class);
    private static AnalysisRpcServerProvider instance = new AnalysisRpcServerProvider();
    private int port = 0;
    private AnalysisRpcServer server = null;

    public static AnalysisRpcServerProvider getInstance() {
        return instance;
    }

    private AnalysisRpcServerProvider() {
    }

    public synchronized void addHandler(String string, IAnalysisRpcHandler iAnalysisRpcHandler) throws AnalysisRpcException {
        if (Boolean.getBoolean("uk.ac.diamond.scisoft.analysis.analysisrpcserverprovider.disable")) {
            throw new AnalysisRpcException("Analysis RPC Server disabled with property uk.ac.diamond.scisoft.analysis.analysisrpcserverprovider.disable");
        }
        this.startServer();
        if (iAnalysisRpcHandler == null) {
            logger.info("Removing " + string);
            this.server.removeHandler(string);
        } else {
            logger.info("Adding " + string);
            this.server.addHandler(string, iAnalysisRpcHandler);
        }
    }

    public synchronized void startServer() throws AnalysisRpcException {
        if (this.server == null) {
            this.server = new AnalysisRpcServer(this.port);
            try {
                this.server.start();
                this.port = this.server.getPort();
                logger.info("Starting Analysis RPC Server on port " + this.port);
            }
            catch (AnalysisRpcException analysisRpcException) {
                logger.error("Failed to start AnalysisRpcServer", (Throwable)analysisRpcException);
                throw new AnalysisRpcException(analysisRpcException);
            }
        }
    }

    public synchronized IAnalysisRpcHandler getHandler(String string) {
        if (this.server == null) {
            return null;
        }
        return this.server.getHandler(string);
    }

    public void setPort(int n) throws IllegalStateException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Port number must be >= 0");
        }
        if (this.server != null) {
            throw new IllegalStateException("Analysis Rpc Server Provider has already used the existing port, setPort must be called before any handlers are added or requests are made");
        }
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }
}

