/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClientProvider.class);
    private int port = 0;

    protected AbstractClientProvider() {
    }

    public void setPort(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Port number must be >= 0");
        }
        this.port = n;
    }

    public int getPort() throws IllegalStateException {
        if (this.port == 0) {
            String string = System.getenv(this.getEnvName());
            if (string != null) {
                try {
                    this.port = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.port = 0;
                }
            }
            if (this.port == 0) {
                String string2 = "Failed to determine suitable port from " + this.getEnvName() + ", value was '" + string + "'";
                logger.error(string2);
                throw new IllegalStateException(string2);
            }
        }
        return this.port;
    }

    protected abstract String getEnvName();
}

