/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.tabnanny;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabNannyDocIterator {
    private int offset;
    private IDocument doc;
    private Tuple3<String, Integer, Boolean> nextString;
    private int docLen;
    private boolean firstPass = true;

    public TabNannyDocIterator(IDocument doc) throws BadLocationException {
        this.doc = doc;
        this.docLen = doc.getLength();
        this.buildNext();
    }

    public boolean hasNext() {
        return this.nextString != null;
    }

    public Tuple3<String, Integer, Boolean> next() throws BadLocationException {
        if (!this.hasNext()) {
            throw new RuntimeException("Cannot iterate anymore.");
        }
        Tuple3<String, Integer, Boolean> ret = this.nextString;
        this.buildNext();
        return ret;
    }

    private void buildNext() throws BadLocationException {
        while (!this.internalBuildNext()) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalBuildNext() throws BadLocationException {
        try {
            char c = '\u0000';
            ParsingUtils parsingUtils = ParsingUtils.create((Object)this.doc);
            int initial = -1;
            while (true) {
                if (initial == -1) {
                    initial = this.offset;
                } else {
                    if (initial == this.offset) {
                        Log.log((String)("Error: TabNannyDocIterator didn't walk.\nCurr char:" + c + "\n" + "Curr char (as int):" + c + "\n" + "Offset:" + this.offset + "\n" + "DocLen:" + this.docLen + "\n"));
                        ++this.offset;
                        return true;
                    }
                    initial = this.offset;
                }
                if (this.offset >= this.docLen) {
                    this.nextString = null;
                    return true;
                }
                c = this.doc.getChar(this.offset);
                if (this.firstPass) {
                    if (c == ' ' || c == '\t') break;
                    this.firstPass = false;
                }
                if (c == '#') {
                    this.offset = parsingUtils.eatComments(null, this.offset);
                    continue;
                }
                if (c == '{' || c == '[' || c == '(') {
                    this.offset = parsingUtils.eatPar(this.offset, null, c);
                    continue;
                }
                if (c == '\r') {
                    if (!this.continueAfterIncreaseOffset()) {
                        return true;
                    }
                    c = this.doc.getChar(this.offset);
                    if (c == '\n' && !this.continueAfterIncreaseOffset()) {
                        return true;
                    }
                    break;
                }
                if (c == '\n') {
                    if (!this.continueAfterIncreaseOffset()) {
                        return true;
                    }
                    break;
                }
                if (c == '\\') {
                    boolean lastLineChar = false;
                    if (!this.continueAfterIncreaseOffset()) {
                        return true;
                    }
                    c = this.doc.getChar(this.offset);
                    if (c == '\r') {
                        if (!this.continueAfterIncreaseOffset()) {
                            return true;
                        }
                        c = this.doc.getChar(this.offset);
                        lastLineChar = true;
                    }
                    if (c == '\n') {
                        if (!this.continueAfterIncreaseOffset()) {
                            return true;
                        }
                        lastLineChar = true;
                    }
                    if (lastLineChar) continue;
                    break;
                }
                if (c == '\'' || c == '\"') {
                    this.offset = parsingUtils.getLiteralEnd(this.offset, c) + 1;
                    continue;
                }
                if (!this.continueAfterIncreaseOffset()) return true;
            }
            if (this.offset >= this.docLen) {
                this.nextString = null;
                return true;
            }
            c = this.doc.getChar(this.offset);
            FastStringBuffer buf = new FastStringBuffer();
            int startingOffset = this.offset;
            while (c == ' ' || c == '\t') {
                buf.append(c);
                ++this.offset;
                if (this.offset >= this.docLen) break;
                c = this.doc.getChar(this.offset);
            }
            this.nextString = new Tuple3((Object)buf.toString(), (Object)startingOffset, (Object)(c != '\r' && c != '\n' ? 1 : 0));
            if (((String)this.nextString.o1).length() != 0) return true;
            return false;
        }
        catch (BadLocationException e) {
            throw e;
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean continueAfterIncreaseOffset() {
        ++this.offset;
        boolean ret = true;
        if (this.offset >= this.docLen) {
            this.nextString = null;
            ret = false;
        }
        return ret;
    }

    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

