/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.OccurrencesAnalyzer;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.builder.AbstractAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableFactory;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableForRemove;
import com.python.pydev.analysis.builder.AnalysisRunner;
import com.python.pydev.analysis.builder.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.KeyForAnalysisRunnable;
import com.python.pydev.analysis.messages.IMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.logging.DebugSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisBuilderRunnable
extends AbstractAnalysisBuilderRunnable {
    public static final List<ICallback<Object, IResource>> analysisBuilderListeners = new ArrayList<ICallback<Object, IResource>>();
    private IDocument document;
    private WeakReference<IResource> resource;
    private ICallback<IModule, Integer> module;
    private static boolean useEclipse32DerivedVersion = false;

    private static boolean isHierarchicallyDerived(IResource curr) {
        if (useEclipse32DerivedVersion) {
            do {
                if (!curr.isDerived()) continue;
                return true;
            } while ((curr = curr.getParent()) != null);
            return false;
        }
        try {
            return curr.isDerived(512);
        }
        catch (Throwable throwable) {
            useEclipse32DerivedVersion = true;
            return AnalysisBuilderRunnable.isHierarchicallyDerived(curr);
        }
    }

    AnalysisBuilderRunnable(IDocument document, IResource resource, ICallback<IModule, Integer> module, boolean isFullBuild, String moduleName, boolean forceAnalysis, int analysisCause, IAnalysisBuilderRunnable oldAnalysisBuilderThread, IPythonNature nature, long documentTime, KeyForAnalysisRunnable key, long resourceModificationStamp) {
        super(isFullBuild, moduleName, forceAnalysis, analysisCause, oldAnalysisBuilderThread, nature, documentTime, key, resourceModificationStamp);
        this.document = document;
        this.resource = new WeakReference<IResource>(resource);
        this.module = module;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.document = null;
        this.resource = null;
        this.module = null;
    }

    @Override
    protected void doAnalysis() {
        try {
            boolean onlyRecreateCtxInsensitiveInfo;
            boolean makeAnalysis;
            IResource r;
            if (!this.nature.startRequests()) {
                return;
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)this, (String)("doAnalysis() - " + this.moduleName + " " + this.getAnalysisCauseStr()));
            }
            if ((r = (IResource)this.resource.get()) == null || !r.getProject().isOpen()) {
                Log.toLogFile((Object)this, (String)("Finished analysis -- resource null or project closed -- " + this.moduleName));
                return;
            }
            AnalysisRunner runner = new AnalysisRunner();
            this.checkStop();
            IAnalysisPreferences analysisPreferences = AnalysisPreferences.getAnalysisPreferences();
            analysisPreferences.clearCaches();
            boolean bl = makeAnalysis = runner.canDoAnalysis(this.document) && PyDevBuilderVisitor.isInPythonPath((IResource)r) && analysisPreferences.makeCodeAnalysis();
            if (!makeAnalysis) {
                AnalysisRunner.deleteMarkers(r);
            }
            if (this.nature == null) {
                Log.log((String)("Finished analysis: null nature -- " + this.moduleName));
                return;
            }
            AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(this.nature);
            if (info == null) {
                Log.log((String)("Unable to get additional info for: " + r + " -- " + this.moduleName));
                return;
            }
            this.checkStop();
            if (!this.isFullBuild) {
                AnalysisBuilderRunnableForRemove.removeInfoForModule(this.moduleName, this.nature, this.isFullBuild);
            }
            boolean bl2 = onlyRecreateCtxInsensitiveInfo = !this.forceAnalysis && this.analysisCause == 1 && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor();
            if (!onlyRecreateCtxInsensitiveInfo && !this.nature.isResourceInPythonpathProjectSources(r, false)) {
                onlyRecreateCtxInsensitiveInfo = true;
            }
            int moduleRequest = onlyRecreateCtxInsensitiveInfo ? 2 : 1;
            this.checkStop();
            SourceModule module = (SourceModule)this.module.call((Object)moduleRequest);
            this.checkStop();
            this.recreateCtxInsensitiveInfo(info, module, this.nature, r);
            if (onlyRecreateCtxInsensitiveInfo) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Skipping: !forceAnalysis && analysisCause == ANALYSIS_CAUSE_BUILDER && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor() -- " + this.moduleName));
                }
                return;
            }
            if (!makeAnalysis) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Skipping: !makeAnalysis -- " + this.moduleName));
                }
                return;
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)this, (String)("makeAnalysis:" + makeAnalysis + " " + "analysisCause: " + this.getAnalysisCauseStr() + " -- " + this.moduleName));
            }
            this.checkStop();
            if (AnalysisBuilderRunnable.isHierarchicallyDerived(r)) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Resource marked as derived not analyzed: " + r + " -- " + this.moduleName));
                }
                runner.setMarkers(r, this.document, new IMessage[0], this.internalCancelMonitor);
                return;
            }
            try {
                OccurrencesAnalyzer analyzer = new OccurrencesAnalyzer();
                this.checkStop();
                IMessage[] messages = analyzer.analyzeDocument(this.nature, module, analysisPreferences, this.document, this.internalCancelMonitor);
                this.checkStop();
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Adding markers for module: " + this.moduleName));
                }
                this.checkStop();
                boolean analyzeOnlyActiveEditor = PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor();
                if (this.forceAnalysis || !analyzeOnlyActiveEditor || analyzeOnlyActiveEditor && (!PyDevBuilderPrefPage.getRemoveErrorsWhenEditorIsClosed() || PyEdit.isEditorOpenForResource((IResource)r))) {
                    runner.setMarkers(r, this.document, messages, this.internalCancelMonitor);
                } else if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Skipped adding markers for module: " + this.moduleName + " (editor not opened)."));
                }
                for (ICallback<Object, IResource> callback : analysisBuilderListeners) {
                    try {
                        callback.call((Object)r);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.logOperationCancelled();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        finally {
            try {
                this.nature.endRequests();
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            try {
                AnalysisBuilderRunnableFactory.removeFromThreads(this.key, this);
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            this.dispose();
        }
    }

    private void recreateCtxInsensitiveInfo(AbstractAdditionalTokensInfo info, SourceModule sourceModule, IPythonNature nature, IResource r) {
        boolean generateDelta = !this.isFullBuild;
        info.addAstInfo(sourceModule.getAst(), sourceModule.getModulesKey(), generateDelta);
    }
}

