/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo.builders;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.parser.PyParser;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.interpreters.IInterpreterObserver;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;
import org.python.pydev.utils.JobProgressComunicator;

public class InterpreterObserver
implements IInterpreterObserver {
    private static final boolean DEBUG_INTERPRETER_OBSERVER = false;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDefaultPythonpathRestored(IInterpreterManager manager, String interpreter, IProgressMonitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            try {
                InterpreterInfo defaultInterpreterInfo;
                ISystemModulesManager m;
                AbstractAdditionalTokensInfo additionalSystemInfo;
                IInterpreterInfo interpreterInfo = manager.getInterpreterInfo(interpreter, (IProgressMonitor)new NullProgressMonitor());
                int grammarVersion = interpreterInfo.getGrammarVersion();
                AbstractAdditionalDependencyInfo currInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, interpreter);
                if (currInfo != null) {
                    ((AbstractAdditionalTokensInfo)currInfo).clearAllInfo();
                }
                if ((additionalSystemInfo = this.restoreInfoForModuleManager(monitor, (IModulesManager)(m = (defaultInterpreterInfo = (InterpreterInfo)manager.getInterpreterInfo(interpreter, monitor)).getModulesManager()), "(system: " + manager.getManagerRelatedName() + " - " + interpreter + ")", new AdditionalSystemInterpreterInfo(manager, interpreter), null, grammarVersion)) != null) {
                    AdditionalSystemInterpreterInfo.setAdditionalSystemInfo(manager, interpreter, additionalSystemInfo);
                    AbstractAdditionalTokensInfo.saveAdditionalSystemInfo(manager, interpreter);
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void notifyInterpreterManagerRecreated(final IInterpreterManager iManager) {
        IInterpreterInfo[] iInterpreterInfoArray = iManager.getInterpreterInfos();
        int n = iInterpreterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IInterpreterInfo interpreterInfo = iInterpreterInfoArray[n2];
            Job j = new Job("PyDev... Restoring indexes for: " + interpreterInfo.getNameForUI()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitorArg) {
                    Object object = InterpreterObserver.this.lock;
                    synchronized (object) {
                        boolean loadedAdditionalSystemInfo;
                        try {
                            loadedAdditionalSystemInfo = AdditionalSystemInterpreterInfo.loadAdditionalSystemInfo(iManager, interpreterInfo.getExecutableOrJar());
                        }
                        catch (MisconfigurationException misconfigurationException) {
                            loadedAdditionalSystemInfo = false;
                        }
                        if (!loadedAdditionalSystemInfo) {
                            try {
                                JobProgressComunicator jobProgressComunicator = new JobProgressComunicator(monitorArg, "PyDev... Restoring indexes for: " + interpreterInfo.getNameForUI(), -1, (Job)this);
                                InterpreterObserver.this.notifyDefaultPythonpathRestored(iManager, interpreterInfo.getExecutableOrJar(), (IProgressMonitor)jobProgressComunicator);
                                jobProgressComunicator.done();
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            j.setPriority(20);
            j.schedule();
            ++n2;
        }
    }

    private AbstractAdditionalTokensInfo restoreInfoForModuleManager(IProgressMonitor monitor, IModulesManager m, String additionalFeedback, AbstractAdditionalTokensInfo info, PythonNature nature, int grammarVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ModulesKey[] allModules = m.getOnlyDirectModules();
        int i = 0;
        FastStringBuffer msgBuffer = new FastStringBuffer();
        ModulesKey[] modulesKeyArray = allModules;
        int n = allModules.length;
        int n2 = 0;
        while (n2 < n) {
            ModulesKey key = modulesKeyArray[n2];
            if (monitor.isCanceled()) {
                return null;
            }
            ++i;
            if (PythonPathHelper.canAddAstInfoFor((ModulesKey)key)) {
                if (i % 17 == 0) {
                    msgBuffer.clear();
                    msgBuffer.append("Creating ");
                    msgBuffer.append(additionalFeedback);
                    msgBuffer.append(" additional info (");
                    msgBuffer.append(i);
                    msgBuffer.append(" of ");
                    msgBuffer.append(allModules.length);
                    msgBuffer.append(") for ");
                    msgBuffer.append(key.file.getName());
                    monitor.setTaskName(msgBuffer.toString());
                    monitor.worked(1);
                }
                try {
                    if (info.addAstInfo(key, false) == null) {
                        String str = "Unable to generate ast -- using %s.\nError:%s";
                        Object errorDesc = null;
                        throw new RuntimeException(StringUtils.format((String)str, (Object[])new Object[]{PyParser.getGrammarVersionStr((int)grammarVersion), errorDesc != null && errorDesc.message != null ? errorDesc.message : "unable to determine"}));
                    }
                }
                catch (Throwable e) {
                    Log.log((int)4, (String)("Problem parsing the file :" + key.file + "."), (Throwable)e);
                }
            }
            ++n2;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProjectPythonpathRestored(PythonNature nature, IProgressMonitor monitor) {
        try {
            IModulesManager m = nature.getAstManager().getModulesManager();
            IProject project = nature.getProject();
            AbstractAdditionalDependencyInfo currInfo = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)nature);
            if (currInfo != null) {
                currInfo.clearAllInfo();
            }
            AdditionalProjectInterpreterInfo newProjectInfo = new AdditionalProjectInterpreterInfo(project);
            String feedback = "(project:" + project.getName() + ")";
            IModulesManager iModulesManager = m;
            synchronized (iModulesManager) {
                AbstractAdditionalDependencyInfo info = (AbstractAdditionalDependencyInfo)this.restoreInfoForModuleManager(monitor, m, feedback, newProjectInfo, nature, nature.getGrammarVersion());
                if (info != null) {
                    AdditionalProjectInterpreterInfo.setAdditionalInfoForProject(project, info);
                    AdditionalProjectInterpreterInfo.saveAdditionalInfoForProject((IPythonNature)nature);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void notifyNatureRecreated(PythonNature nature, IProgressMonitor monitor) {
        boolean loadAdditionalInfoForProject;
        try {
            loadAdditionalInfoForProject = AdditionalProjectInterpreterInfo.loadAdditionalInfoForProject((IPythonNature)nature);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            loadAdditionalInfoForProject = false;
        }
        if (!loadAdditionalInfoForProject) {
            this.notifyProjectPythonpathRestored(nature, monitor);
        }
    }
}

