/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class JLocaleChooser
extends JComboBox
implements ItemListener {
    private Locale[] locales;
    private Locale locale;
    private int localeCount;

    public JLocaleChooser() {
        this.addItemListener(this);
        this.locales = Calendar.getAvailableLocales();
        this.localeCount = this.locales.length;
        int n = 0;
        while (n < this.localeCount) {
            if (this.locales[n].getCountry().length() > 0) {
                this.addItem(this.locales[n].getDisplayName());
            }
            ++n;
        }
        this.setLocale(Locale.getDefault());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        while (n < this.localeCount) {
            if (this.locales[n].getDisplayName().equals(string)) break;
            ++n;
        }
        this.setLocale(this.locales[n], false);
    }

    private void setLocale(Locale locale, boolean bl) {
        Locale locale2 = this.locale;
        this.locale = locale;
        int n = 0;
        if (bl) {
            int n2 = 0;
            while (n2 < this.localeCount) {
                if (this.locales[n2].getCountry().length() > 0) {
                    if (this.locales[n2].equals(this.locale)) {
                        this.setSelectedIndex(n);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        this.firePropertyChange("locale", locale2, this.locale);
    }

    @Override
    public void setLocale(Locale locale) {
        this.setLocale(locale, true);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("LocaleChooser");
        jFrame.getContentPane().add(new JLocaleChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

