/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.components;

import com.isencia.util.swing.components.MutableListModel;
import com.isencia.util.swing.components.SortedMutableListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JListDataExchangePanel
extends JPanel {
    private MutableListModel srcModel;
    private MutableListModel destModel;
    private JList srcList;
    private JList destList;
    AbstractAction addElementAction = new AddElementAction(">");
    AbstractAction addElementsAction = new AddElementsAction(">>");
    AbstractAction removeElementAction = new RemoveElementAction("<");
    AbstractAction removeElementsAction = new RemoveElementsAction("<<");
    private JButton addElement = new JButton(this.addElementAction);
    private JButton addElements = new JButton(this.addElementsAction);
    private JButton removeElement = new JButton(this.removeElementAction);
    private JButton removeElements = new JButton(this.removeElementsAction);

    public JListDataExchangePanel(MutableListModel mutableListModel, MutableListModel mutableListModel2, String string, String string2) {
        this.srcModel = mutableListModel;
        this.destModel = mutableListModel2;
        this.balanceModels();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.srcList = new JList(mutableListModel);
        this.destList = new JList(mutableListModel2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string), "North");
        jPanel.add((Component)new JScrollPane(this.srcList), "Center");
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1));
        jPanel2.add(this.addElement);
        jPanel2.add(this.addElements);
        jPanel2.add(this.removeElement);
        jPanel2.add(this.removeElements);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints2);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(string2), "North");
        jPanel3.add((Component)new JScrollPane(this.destList), "Center");
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
    }

    public JList getSrcList() {
        return this.srcList;
    }

    public JList getDestList() {
        return this.destList;
    }

    protected void balanceModels() {
        int n = 0;
        while (n < this.destModel.getSize()) {
            this.srcModel.removeElements(new Object[]{this.destModel.getElementAt(n)});
            ++n;
        }
    }

    public void setListModels(MutableListModel mutableListModel, MutableListModel mutableListModel2) {
        this.srcModel = mutableListModel;
        this.destModel = mutableListModel2;
        this.balanceModels();
        this.srcList.setModel(mutableListModel);
        this.destList.setModel(mutableListModel2);
    }

    protected void updateActions() {
        if (this.srcModel.getSize() > 0) {
            this.enableAddActions();
        } else {
            this.disableAddActions();
        }
        if (this.destModel.getSize() > 0) {
            this.enableRemoveActions();
        } else {
            this.disableRemoveActions();
        }
    }

    protected void setAddActionsEnabled(boolean bl) {
        this.addElementAction.setEnabled(bl);
        this.addElementsAction.setEnabled(bl);
    }

    protected void enableAddActions() {
        this.setAddActionsEnabled(true);
    }

    protected void disableAddActions() {
        this.setAddActionsEnabled(false);
    }

    protected void setRemoveActionsEnabled(boolean bl) {
        this.removeElementAction.setEnabled(bl);
        this.removeElementsAction.setEnabled(bl);
    }

    protected void disableRemoveActions() {
        this.setRemoveActionsEnabled(false);
    }

    protected void enableRemoveActions() {
        this.setRemoveActionsEnabled(true);
    }

    public static void main(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("first");
        treeSet.add("second");
        treeSet.add("third");
        TreeSet treeSet2 = new TreeSet();
        SortedMutableListModel sortedMutableListModel = new SortedMutableListModel(treeSet);
        SortedMutableListModel sortedMutableListModel2 = new SortedMutableListModel(treeSet2);
        JListDataExchangePanel jListDataExchangePanel = new JListDataExchangePanel(sortedMutableListModel, sortedMutableListModel2, "source", "dest");
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(jListDataExchangePanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public MutableListModel getDestModel() {
        return this.destModel;
    }

    public MutableListModel getSrcModel() {
        return this.srcModel;
    }

    class AddElementAction
    extends AbstractAction {
        public AddElementAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = JListDataExchangePanel.this.srcList.getSelectedValues();
            JListDataExchangePanel.this.destModel.addElements(objectArray);
            JListDataExchangePanel.this.srcModel.removeElements(objectArray);
            if (JListDataExchangePanel.this.srcModel.getSize() == 0) {
                JListDataExchangePanel.this.disableAddActions();
            }
            if (JListDataExchangePanel.this.destModel.getSize() > 0) {
                JListDataExchangePanel.this.enableRemoveActions();
            }
        }
    }

    class AddElementsAction
    extends AbstractAction {
        public AddElementsAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[JListDataExchangePanel.this.srcModel.getSize()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = JListDataExchangePanel.this.srcModel.getElementAt(n);
                ++n;
            }
            JListDataExchangePanel.this.destModel.addElements(objectArray);
            JListDataExchangePanel.this.srcModel.removeElements(objectArray);
            if (JListDataExchangePanel.this.srcModel.getSize() == 0) {
                JListDataExchangePanel.this.disableAddActions();
            }
            if (JListDataExchangePanel.this.destModel.getSize() > 0) {
                JListDataExchangePanel.this.enableRemoveActions();
            }
        }
    }

    class RemoveElementAction
    extends AbstractAction {
        public RemoveElementAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = JListDataExchangePanel.this.destList.getSelectedValues();
            JListDataExchangePanel.this.srcModel.addElements(objectArray);
            JListDataExchangePanel.this.destModel.removeElements(objectArray);
            if (JListDataExchangePanel.this.destModel.getSize() == 0) {
                JListDataExchangePanel.this.disableRemoveActions();
            }
            if (JListDataExchangePanel.this.srcModel.getSize() > 0) {
                JListDataExchangePanel.this.enableAddActions();
            }
        }
    }

    class RemoveElementsAction
    extends AbstractAction {
        public RemoveElementsAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[JListDataExchangePanel.this.destModel.getSize()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = JListDataExchangePanel.this.destModel.getElementAt(n);
                ++n;
            }
            JListDataExchangePanel.this.srcModel.addElements(objectArray);
            JListDataExchangePanel.this.destModel.removeElements(objectArray);
            if (JListDataExchangePanel.this.destModel.getSize() == 0) {
                JListDataExchangePanel.this.disableRemoveActions();
            }
            if (JListDataExchangePanel.this.srcModel.getSize() > 0) {
                JListDataExchangePanel.this.enableAddActions();
            }
        }
    }
}

