/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.components;

import com.isencia.util.swing.components.FormEntry;
import com.isencia.util.swing.components.FormField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class FinderAccessory
extends JPanel {
    public static final String ACCESSORY_NAME = "Custom filter";
    protected JFileChooser chooser = null;
    protected FormField valueField = null;
    private ExtensionFileFilter customFilter = null;

    public FinderAccessory(JFileChooser jFileChooser) {
        this.setBorder(new TitledBorder(ACCESSORY_NAME));
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.valueField = new FormField();
        this.valueField.setEditable(true);
        JLabel jLabel = new JLabel("Selected extensions");
        jLabel.setToolTipText("Enter one or more file extensions, separated by spaces. E.g. [txt xml java]");
        box.add(new FormEntry(jLabel, this.valueField));
        this.add((Component)box, "North");
        this.valueField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FinderAccessory.this.pushExtensions();
            }
        });
        this.chooser = jFileChooser;
    }

    protected void pushExtensions() {
        String string = this.valueField.getText();
        if (string != null && (string = string.trim()).length() > 0) {
            String[] stringArray = string.split("[ ,.]");
            if (this.customFilter != null) {
                this.chooser.removeChoosableFileFilter(this.customFilter);
                this.chooser.setFileFilter(null);
            }
            this.customFilter = new ExtensionFileFilter();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (string2 != null && string2.length() > 0) {
                    this.customFilter.addExtension(string2);
                }
                ++n2;
            }
            this.customFilter.setDescription(ACCESSORY_NAME);
            this.chooser.addChoosableFileFilter(this.customFilter);
            this.chooser.setFileFilter(this.customFilter);
        }
    }

    public void goTo(File file) {
        Object object;
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (this.chooser == null) {
            return;
        }
        this.chooser.setFileSelectionMode(2);
        FileFilter fileFilter = this.chooser.getFileFilter();
        if (fileFilter != null && !fileFilter.accept(file)) {
            object = this.chooser.getAcceptAllFileFilter();
            this.chooser.setFileFilter((FileFilter)object);
        }
        if ((object = file.getParentFile()) != null) {
            this.chooser.setCurrentDirectory((File)object);
        }
        this.chooser.setSelectedFile(null);
        this.chooser.setSelectedFile(file);
        this.chooser.invalidate();
        this.chooser.repaint();
    }

    static class ExtensionFileFilter
    extends FileFilter {
        private Map filters = new HashMap();
        private String description = null;
        private String fullDescription = null;
        private boolean useExtensionsInDescription = true;

        public ExtensionFileFilter() {
        }

        public ExtensionFileFilter(String string) {
            this(string, null);
        }

        public ExtensionFileFilter(String string, String string2) {
            this(new String[]{string}, string2);
        }

        public ExtensionFileFilter(String[] stringArray) {
            this(stringArray, null);
        }

        public ExtensionFileFilter(String[] stringArray, String string) {
            this.filters = new Hashtable(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.addExtension(stringArray[n]);
                ++n;
            }
            this.setDescription(string);
        }

        @Override
        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = this.getExtension(file);
                if (string != null && this.filters.get(this.getExtension(file)) != null) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File file) {
            String string;
            int n;
            if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return null;
        }

        public void addExtension(String string) {
            if (this.filters == null) {
                this.filters = new Hashtable(5);
            }
            this.filters.put(string.toLowerCase(), this);
            this.fullDescription = null;
        }

        public void clearExtensions() {
            this.filters.clear();
        }

        @Override
        public String getDescription() {
            if (this.fullDescription == null) {
                if (this.description == null || this.isExtensionListInDescription()) {
                    if (this.description != null) {
                        this.fullDescription = this.description;
                    }
                    this.fullDescription = String.valueOf(this.fullDescription) + " (";
                    Iterator iterator = this.filters.keySet().iterator();
                    if (iterator != null) {
                        this.fullDescription = String.valueOf(this.fullDescription) + "." + (String)iterator.next();
                        while (iterator.hasNext()) {
                            this.fullDescription = String.valueOf(this.fullDescription) + ", " + (String)iterator.next();
                        }
                    }
                    this.fullDescription = String.valueOf(this.fullDescription) + ")";
                } else {
                    this.fullDescription = this.description;
                }
            }
            return this.fullDescription;
        }

        public void setDescription(String string) {
            this.description = string;
            this.fullDescription = null;
        }

        public void setExtensionListInDescription(boolean bl) {
            this.useExtensionsInDescription = bl;
            this.fullDescription = null;
        }

        public boolean isExtensionListInDescription() {
            return this.useExtensionsInDescription;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

