/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.components;

import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    public DynamicTree(String string) {
        this.rootNode = new DefaultMutableTreeNode(string);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.setLayout(new GridLayout(1, 0));
        this.add(jScrollPane);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
        this.toolkit.beep();
    }

    public DefaultMutableTreeNode addObject(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        defaultMutableTreeNode = treePath == null ? this.rootNode : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return this.addObject(defaultMutableTreeNode, object, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        return this.addObject(defaultMutableTreeNode, object, false);
    }

    public void expandAllNodes() {
        int n = 0;
        while (n < this.tree.getRowCount()) {
            this.tree.expandRow(n);
            ++n;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        return defaultMutableTreeNode2;
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            try {
                int n = treeModelEvent.getChildIndices()[0];
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            }
            catch (NullPointerException nullPointerException) {}
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

