/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TimeSelector
extends JPanel
implements AdjustmentListener,
DocumentListener {
    protected TimeTextField textField;
    protected JScrollBar scrollBar;
    private int min = -10000;
    private int max = 10000;
    private int previousValue = 0;
    private int lastPressedButton = -1;
    private long lastPressedButtonTime = 0L;
    private int countKeyPressedButton = 0;

    public TimeSelector() {
        this.setLayout(new BorderLayout());
        this.textField = new TimeTextField();
        this.textField.getDocument().addDocumentListener(this);
        this.add((Component)this.textField, "Center");
        this.scrollBar = new JScrollBar(1, 0, 0, 0, 100);
        this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.scrollBar.setMinimum(this.min);
        this.scrollBar.setMaximum(this.max);
        this.scrollBar.setValue(0);
        this.scrollBar.addAdjustmentListener(this);
        this.add((Component)this.scrollBar, "East");
    }

    public TimeSelector(int n, int n2, int n3) {
        this.setLayout(new BorderLayout());
        this.textField = new TimeTextField(n, n2, n3);
        this.add((Component)this.textField, "Center");
        this.scrollBar = new JScrollBar(1, 0, 0, 0, 100);
        this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.scrollBar.setMinimum(this.min);
        this.scrollBar.setMaximum(this.max);
        this.scrollBar.setValue(0);
        this.scrollBar.addAdjustmentListener(this);
        this.add((Component)this.scrollBar, "East");
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        long l = new Date().getTime();
        long l2 = l - this.lastPressedButtonTime;
        int n = this.textField.precision;
        int n2 = adjustmentEvent.getValue();
        if (n2 < this.previousValue) {
            this.countKeyPressedButton = this.lastPressedButton == 1 ? (l2 < 100L ? ++this.countKeyPressedButton : 0) : 0;
            if (this.countKeyPressedButton > 10) {
                n *= 2;
            }
            if (this.countKeyPressedButton > 50) {
                n *= 10;
            }
            if (this.countKeyPressedButton > 250) {
                n *= 50;
            }
            this.lastPressedButton = 1;
            this.textField.addInterval(n);
        } else {
            this.countKeyPressedButton = this.lastPressedButton == 0 ? (l2 < 100L ? ++this.countKeyPressedButton : 0) : 0;
            if (this.countKeyPressedButton > 10) {
                n *= 2;
            }
            if (this.countKeyPressedButton > 50) {
                n *= 10;
            }
            if (this.countKeyPressedButton > 250) {
                n *= 50;
            }
            this.lastPressedButton = 0;
            this.textField.addInterval(-n);
        }
        this.previousValue = n2;
        this.lastPressedButtonTime = l;
    }

    protected void _fireTimePropertyChange(Date date, Date date2) {
        this.firePropertyChange("time", date, date2);
    }

    public static void main(String[] stringArray) {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        JFrame jFrame = new JFrame("JSpinField");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add(new TimeSelector());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public String getTime() {
        return this.textField.getText();
    }

    public SimpleDateFormat getTimeFormatter() {
        return this.textField.formatter;
    }

    public void setTime(String string) {
        this.textField.setTime(string);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        String string = this.textField.getText();
        try {
            Date date = this.textField.formatter.parse(string);
            Date date2 = this.textField.date != null ? new Date(this.textField.date.getTime()) : null;
            this.textField.date = this.textField.transformDate(date);
            this._fireTimePropertyChange(date2, this.textField.date);
        }
        catch (ParseException parseException) {}
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        String string = this.textField.getText();
        try {
            Date date = this.textField.formatter.parse(string);
            Date date2 = this.textField.date != null ? new Date(this.textField.date.getTime()) : null;
            this.textField.date = this.textField.transformDate(date);
            this._fireTimePropertyChange(date2, this.textField.date);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    class TimeTextField
    extends JTextField
    implements KeyListener {
        public SimpleDateFormat formatter = null;
        private boolean noCheck = true;
        public int precisionType = 0;
        public int precision = 0;
        public int format = 0;
        private int currentCaretPosition = 0;
        public Date date = null;
        private int lastPressedKey = -1;
        private long lastPressedKeyTime = -1L;
        private long countKeyPressed = 0L;
        public static final int FORMAT_12H = 1;
        public static final int FORMAT_24H = 2;
        public static final int PRECISION_HOURS = 2;
        public static final int PRECISION_MINUTES = 5;
        public static final int PRECISION_SECONDS = 8;

        public TimeTextField() {
            this(2, 8, 1);
        }

        public TimeTextField(int n, int n2, int n3) {
            this.format = n;
            this.precisionType = n2;
            this.precision = n3;
            this.formatter = new SimpleDateFormat(this.getDateFormat());
            this.setDocument(new TimeDocument());
            Date date = new Date();
            this.setTime(this.formatter.format(date));
            this.addKeyListener(this);
        }

        public SimpleDateFormat getTimeFormatter() {
            return this.formatter;
        }

        public void setTime(String string) {
            this.noCheck = true;
            try {
                Date date = this.formatter.parse(string);
                this.currentCaretPosition = this.getCaretPosition();
                Date date2 = this.date != null ? new Date(this.date.getTime()) : null;
                this.date = this.transformDate(date);
                ((TimeDocument)this.getDocument()).clear(0, this.getMaxOffset());
                this.setText(this.formatter.format(this.date));
                TimeSelector.this._fireTimePropertyChange(date2, this.date);
            }
            catch (ParseException parseException) {
                this.noCheck = false;
            }
        }

        private void addInterval(int n) {
            this.noCheck = true;
            this.currentCaretPosition = this.getCaretPosition();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.date);
            switch (this.precisionType) {
                case 8: {
                    calendar.add(13, n);
                    break;
                }
                case 5: {
                    calendar.add(12, n);
                    break;
                }
                case 2: {
                    calendar.add(10, n);
                    break;
                }
            }
            Date date = this.date != null ? new Date(this.date.getTime()) : null;
            this.date = calendar.getTime();
            ((TimeDocument)this.getDocument()).clear(0, this.getMaxOffset());
            this.setText(this.formatter.format(this.date));
            TimeSelector.this._fireTimePropertyChange(date, this.date);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            long l = new Date().getTime();
            long l2 = l - this.lastPressedKeyTime;
            int n = this.precision;
            if (keyEvent.getKeyCode() == 38) {
                this.countKeyPressed = this.lastPressedKey == 38 ? (l2 < 100L ? ++this.countKeyPressed : 0L) : 0L;
                if (this.countKeyPressed > 10L) {
                    n *= 2;
                }
                if (this.countKeyPressed > 50L) {
                    n *= 10;
                }
                if (this.countKeyPressed > 250L) {
                    n *= 50;
                }
                this.addInterval(n);
            }
            if (keyEvent.getKeyCode() == 40) {
                this.countKeyPressed = this.lastPressedKey == 40 ? (l2 < 100L ? ++this.countKeyPressed : 0L) : 0L;
                if (this.countKeyPressed > 10L) {
                    n *= 2;
                }
                if (this.countKeyPressed > 50L) {
                    n *= 10;
                }
                if (this.countKeyPressed > 250L) {
                    n *= 50;
                }
                this.addInterval(-n);
            }
            if (keyEvent.getKeyCode() == 33) {
                this.countKeyPressed = this.lastPressedKey == 33 ? (l2 < 100L ? ++this.countKeyPressed : 0L) : 0L;
                if (this.countKeyPressed > 10L) {
                    n *= 2;
                }
                if (this.countKeyPressed > 50L) {
                    n *= 10;
                }
                this.addInterval(5 * n);
            }
            if (keyEvent.getKeyCode() == 34) {
                this.countKeyPressed = this.lastPressedKey == 34 ? (l2 < 100L ? ++this.countKeyPressed : 0L) : 0L;
                if (this.countKeyPressed > 10L) {
                    n *= 2;
                }
                if (this.countKeyPressed > 50L) {
                    n *= 10;
                }
                this.addInterval(-5 * n);
            }
            this.lastPressedKey = keyEvent.getKeyCode();
            this.lastPressedKeyTime = l;
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        private int getMaxOffset() {
            switch (this.format) {
                case 1: {
                    switch (this.precisionType) {
                        case 8: {
                            return 11;
                        }
                        case 5: {
                            return 8;
                        }
                        case 2: {
                            return 5;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.precisionType) {
                        case 8: {
                            return 8;
                        }
                        case 5: {
                            return 5;
                        }
                        case 2: {
                            return 3;
                        }
                    }
                    break;
                }
            }
            return 0;
        }

        private String getDateFormat() {
            String string = null;
            block0 : switch (this.format) {
                case 1: {
                    switch (this.precisionType) {
                        case 8: {
                            string = "hh:mm:ss a";
                            break block0;
                        }
                        case 5: {
                            string = "hh:mm a";
                            break block0;
                        }
                        case 2: {
                            string = "hh a";
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.precisionType) {
                        case 8: {
                            string = "HH:mm:ss";
                            break block0;
                        }
                        case 5: {
                            string = "HH:mm";
                            break block0;
                        }
                        case 2: {
                            string = "HH";
                            break block0;
                        }
                    }
                    break;
                }
            }
            return string;
        }

        private int getJump(int n) {
            int n2 = 1;
            block0 : switch (this.format) {
                case 1: {
                    switch (this.precisionType) {
                        case 8: {
                            if (n == 1 || n == 4 || n == 7) {
                                n2 = 2;
                                break block0;
                            }
                            if (n != 9) break block0;
                            n2 = 0;
                            break block0;
                        }
                        case 5: {
                            if (n == 1 || n == 4) {
                                n2 = 2;
                                break block0;
                            }
                            if (n != 6) break block0;
                            n2 = 0;
                            break block0;
                        }
                        case 2: {
                            if (n == 1) {
                                n2 = 2;
                                break block0;
                            }
                            if (n != 3) break block0;
                            n2 = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.precisionType) {
                        case 8: {
                            if (n == 1 || n == 4) {
                                n2 = 2;
                                break block0;
                            }
                            if (n != 7) break block0;
                            n2 = 0;
                            break block0;
                        }
                        case 5: {
                            if (n == 1) {
                                n2 = 2;
                                break block0;
                            }
                            if (n != 3) break block0;
                            n2 = 0;
                            break block0;
                        }
                        case 2: {
                            if (n != 1) break block0;
                            n2 = 0;
                            break block0;
                        }
                    }
                    break;
                }
            }
            return n + n2;
        }

        public Date transformDate(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = -1;
            block0 : switch (this.precisionType) {
                case 8: {
                    n = calendar.get(13);
                    break;
                }
                case 5: {
                    n = calendar.get(12);
                    break;
                }
                case 2: {
                    switch (this.format) {
                        case 1: {
                            n = calendar.get(10);
                            break block0;
                        }
                        case 2: {
                            n = calendar.get(11);
                            break block0;
                        }
                    }
                }
            }
            if (n % this.precision != 0) {
                int n2 = 0;
                n2 = n % this.precision > this.precision / 2 ? n + Math.abs(this.precision - n % this.precision) : Math.abs(n - n % this.precision);
                block9 : switch (this.precisionType) {
                    case 8: {
                        calendar.set(13, n2);
                        break;
                    }
                    case 5: {
                        calendar.set(12, n2);
                        break;
                    }
                    case 2: {
                        switch (this.format) {
                            case 1: {
                                calendar.set(10, n2);
                                break block9;
                            }
                            case 2: {
                                calendar.set(11, n2);
                                break block9;
                            }
                        }
                    }
                }
            }
            return calendar.getTime();
        }

        class TimeDocument
        extends PlainDocument {
            public TimeDocument() {
            }

            public TimeDocument(AbstractDocument.Content content) {
                super(content);
            }

            public void clear(int n, int n2) {
                try {
                    super.remove(n, n2);
                }
                catch (Exception exception) {}
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (TimeTextField.this.noCheck) {
                    super.insertString(n, string, attributeSet);
                    TimeTextField.this.setCaretPosition(TimeTextField.this.currentCaretPosition);
                    TimeTextField.this.noCheck = false;
                    return;
                }
                if (n >= TimeTextField.this.getMaxOffset()) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(TimeTextField.this.formatter.format(TimeTextField.this.date));
                stringBuffer.replace(n, n + 1, string);
                try {
                    Date date = TimeTextField.this.formatter.parse(stringBuffer.toString());
                    super.remove(0, TimeTextField.this.getMaxOffset());
                    super.insertString(0, TimeTextField.this.formatter.format(date), attributeSet);
                    TimeTextField.this.date = TimeTextField.this.transformDate(date);
                    try {
                        TimeTextField.this.setCaretPosition(TimeTextField.this.getJump(n));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                catch (ParseException parseException) {
                    return;
                }
            }

            @Override
            public void remove(int n, int n2) throws BadLocationException {
            }
        }
    }
}

