/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.calendar;

import com.isencia.util.swing.calendar.JDayChooser;
import com.isencia.util.swing.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener,
FocusListener {
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private Locale locale;
    private int month;
    private int oldScrollBarValue = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private Choice comboBox;
    private boolean initialized = false;

    public JMonthChooser() {
        this(0);
    }

    public JMonthChooser(int n) {
        this.setLayout(new BorderLayout());
        this.comboBox = new Choice(){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.comboBox.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.setMonth(Calendar.getInstance().get(2));
        this.add((Component)this.comboBox, "Center");
        if (n != 2) {
            JScrollBar jScrollBar = new JScrollBar(1, 0, 0, -10000, 10000){

                @Override
                public boolean isFocusTraversable() {
                    return false;
                }
            };
            jScrollBar.setPreferredSize(new Dimension(jScrollBar.getPreferredSize().width, this.getPreferredSize().height));
            jScrollBar.setVisibleAmount(0);
            jScrollBar.addAdjustmentListener(this);
            if (n == 0) {
                this.add((Component)jScrollBar, "East");
            } else {
                this.add((Component)jScrollBar, "West");
            }
        }
        this.initialized = true;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void initNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAll();
        }
        int n = 0;
        while (n < 12) {
            this.comboBox.addItem(stringArray[n]);
            ++n;
        }
        this.comboBox.select(this.month);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.comboBox.getSelectedIndex();
        if (n >= 0) {
            this.setMonth(n, false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean bl = true;
        int n = adjustmentEvent.getValue();
        if (n > this.oldScrollBarValue) {
            bl = false;
        }
        this.oldScrollBarValue = n;
        int n2 = this.getMonth();
        if (bl) {
            if (++n2 == 12) {
                n2 = 0;
                if (this.yearChooser != null) {
                    int n3 = this.yearChooser.getYear();
                    this.yearChooser.setYear(++n3);
                }
            }
        } else if (--n2 == -1) {
            n2 = 11;
            if (this.yearChooser != null) {
                int n4 = this.yearChooser.getYear();
                this.yearChooser.setYear(--n4);
            }
        }
        this.setMonth(n2);
    }

    private void setMonth(int n, boolean bl) {
        int n2 = this.month;
        this.month = n;
        if (bl) {
            this.comboBox.select(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", n2, this.month);
    }

    public void setMonth(int n) {
        this.setMonth(n, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jDayChooser) {
        this.dayChooser = jDayChooser;
    }

    public void setYearChooser(JYearChooser jYearChooser) {
        this.yearChooser = jYearChooser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.initNames();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("MonthChooser");
        jFrame.getContentPane().add(new JMonthChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

