/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener,
MouseListener {
    private boolean isFirst = true;
    private JButton[] days;
    private JButton selectedDay = null;
    private int day;
    private Color oldDayBackgroundColor;
    private Color selectedColor;
    private Color colorRed;
    private Color colorBlue;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;
    private int firstDay = -1;
    private int lastDay = -1;

    public JDayChooser() {
        this.days = new JButton[49];
        Calendar calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)calendar.clone();
        this.setLayout(new GridLayout(7, 7));
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 7) {
                int n3 = n2 + 7 * n;
                if (n == 0) {
                    this.days[n3] = new JButton(){

                        @Override
                        public void addMouseListener(MouseListener mouseListener) {
                        }

                        @Override
                        public boolean isFocusTraversable() {
                            return false;
                        }
                    };
                    this.days[n3].setBackground(new Color(180, 180, 200));
                } else {
                    this.days[n3] = new JButton("x");
                    this.days[n3].addActionListener(this);
                    this.days[n3].addKeyListener(this);
                    this.days[n3].addFocusListener(this);
                    this.days[n3].addMouseListener(this);
                }
                this.days[n3].setMargin(new Insets(0, 0, 0, 0));
                this.days[n3].setFocusPainted(false);
                this.add(this.days[n3]);
                ++n2;
            }
            ++n;
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.initialized = true;
    }

    protected void init() {
        this.colorRed = new Color(164, 0, 0);
        this.colorBlue = new Color(0, 0, 164);
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        this.calendar = Calendar.getInstance(this.locale);
        int n = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int n2 = n;
        int n3 = 0;
        while (n3 < 7) {
            this.days[n3].setText(this.dayNames[n2]);
            if (n2 == 1) {
                this.days[n3].setForeground(this.colorRed);
            } else {
                this.days[n3].setForeground(this.colorBlue);
            }
            n2 = n2 < 7 ? ++n2 : (n2 -= 6);
            ++n3;
        }
        this.drawDays();
    }

    protected void drawDays() {
        Calendar calendar = (Calendar)this.calendar.clone();
        int n = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        this.firstDay = calendar.get(7) - n;
        if (this.firstDay < 0) {
            this.firstDay += 7;
        }
        this.firstDay += 7;
        int n2 = 7;
        while (n2 < this.firstDay) {
            this.days[n2].setVisible(false);
            this.days[n2].setText("");
            ++n2;
        }
        calendar.add(2, 1);
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        int n3 = 0;
        Color color = this.getForeground();
        while (date2.before(date)) {
            this.days[n2 + n3].setText(Integer.toString(n3 + 1));
            this.days[n2 + n3].setVisible(true);
            if (calendar.get(6) == this.today.get(6) && calendar.get(1) == this.today.get(1)) {
                this.days[n2 + n3].setForeground(this.colorRed);
            } else {
                this.days[n2 + n3].setForeground(color);
            }
            if (n3 + 1 == this.day) {
                this.days[n2 + n3].setBackground(this.selectedColor);
                this.selectedDay = this.days[n2 + n3];
            } else {
                this.days[n2 + n3].setBackground(this.oldDayBackgroundColor);
            }
            ++n3;
            calendar.add(5, 1);
            date2 = calendar.getTime();
        }
        this.lastDay = n3 + n2 - 1;
        int n4 = this.lastDay + 1;
        while (n4 < 49) {
            this.days[n4].setVisible(false);
            this.days[n4].setText("");
            ++n4;
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.init();
        }
    }

    public void setSelectedDay() {
        this.setDay(this.getDay());
    }

    public void setDay(int n) {
        if (n < 1) {
            n = 1;
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n2 = calendar.get(5);
        if (n > n2) {
            n = n2;
        }
        int n3 = this.day;
        this.day = n;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        int n4 = 7;
        while (n4 < 49) {
            if (this.days[n4].getText().equals(Integer.toString(this.day))) {
                this.selectedDay = this.days[n4];
                this.selectedDay.setBackground(this.selectedColor);
                if (this.selectedDay.hasFocus()) break;
                this.selectedDay.requestFocus();
                break;
            }
            ++n4;
        }
        this.firePropertyChange("day", n3, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int n) {
        this.calendar.set(2, n);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int n) {
        this.calendar.set(1, n);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }

    @Override
    public void setFont(Font font) {
        if (this.days != null) {
            int n = 0;
            while (n < 49) {
                this.days[n].setFont(font);
                ++n;
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            int n = 7;
            while (n < 49) {
                this.days[n].setForeground(color);
                ++n;
            }
            this.drawDays();
        }
    }

    @Override
    public String getName() {
        return "JDayChooser";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JButton jButton = (JButton)actionEvent.getSource();
            int n = new Integer(jButton.getText());
            this.setDay(n);
        }
        catch (Exception exception) {}
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.isFirst) {
            this.actionPerformed(new ActionEvent(focusEvent.getSource(), 0, null));
        } else {
            this.isFirst = false;
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.firePropertyChange("escape", 1, 0);
            return;
        }
        if (keyEvent.getKeyCode() == 33) {
            this.firePropertyChange("monthPlus1", 1, 0);
            return;
        }
        if (keyEvent.getKeyCode() == 34) {
            this.firePropertyChange("monthMinus1", 1, 0);
            return;
        }
        if (keyEvent.getKeyCode() == 32) {
            this.firePropertyChange("closeMe", 1, 0);
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            this.firePropertyChange("closeMe", 1, 0);
            return;
        }
        int n = keyEvent.getKeyCode() == 38 ? -7 : (keyEvent.getKeyCode() == 40 ? 7 : (keyEvent.getKeyCode() == 37 ? -1 : (keyEvent.getKeyCode() == 39 ? 1 : 0)));
        int n2 = this.getComponentCount() - 1;
        while (n2 >= 0) {
            if (this.getComponent(n2) == this.selectedDay) {
                if ((n2 += n) < this.firstDay && (n == 1 || n == -1)) {
                    this.firePropertyChange("monthMinus1", 1, 0);
                    this.setDay(this.getLastDayOfPreviousMonth());
                    break;
                }
                if (n2 > this.lastDay && (n == 1 || n == -1)) {
                    this.firePropertyChange("monthPlus1", 1, 0);
                    this.setDay(1);
                    break;
                }
                if (n2 < this.firstDay || n2 > this.lastDay) break;
                if (!this.days[n2].hasFocus()) {
                    this.days[n2].requestFocus();
                    break;
                }
                this.actionPerformed(new ActionEvent(this.days[n2], 0, null));
                break;
            }
            --n2;
        }
    }

    private int getLastDayOfPreviousMonth() {
        Calendar calendar = (Calendar)this.calendar.clone();
        if (calendar.get(2) > 0) {
            calendar.add(2, -1);
        } else {
            calendar.set(2, 11);
            calendar.add(1, -1);
        }
        return calendar.getActualMaximum(5);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JDayChooser");
        jFrame.getContentPane().add(new JDayChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.firePropertyChange("closeMe", 1, 0);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public JButton getSelectedDay() {
        return this.selectedDay;
    }
}

