/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.commandline;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(OSEnvironment.class);
    private Properties variables = new Properties();

    public OSEnvironment() {
        this.parse();
    }

    private void parse() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = string.indexOf("windows 9") > -1 ? "command.com /c set" : (string.indexOf("windows 7") > -1 || string.indexOf("nt") > -1 || string.indexOf("windows 20") > -1 || string.indexOf("windows xp") > -1 || string.indexOf("windows vista") > -1 || string.indexOf("os/2") > -1 ? "cmd.exe /c set" : "env");
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string4 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                String string5;
                int n = string3.indexOf(61);
                if (n == -1) {
                    if (string4 == null) continue;
                    string5 = this.variables.getProperty(string4);
                    string5 = String.valueOf(string5) + "\n" + string3;
                } else {
                    string4 = string3.substring(0, n);
                    string5 = string3.substring(n + 1);
                }
                this.variables.setProperty(string4, string5);
            }
            bufferedReader.close();
            bufferedReader2.close();
        }
        catch (Exception exception) {
            LOG.error("Failed to parse the OS environment.", (Throwable)exception);
        }
    }

    public String getVariable(String string) {
        return this.variables.getProperty(string);
    }

    public String getVariable(String string, String string2) {
        return this.variables.getProperty(string, string2);
    }

    public String getVariableIgnoreCase(String string) {
        Enumeration<Object> enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.variables.getProperty(string2);
        }
        return null;
    }

    public void add(String string, String string2) {
        this.variables.setProperty(string, string2);
    }

    public List<String> getEnvironment() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<Object> enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(String.valueOf(string) + "=" + this.variables.getProperty(string));
        }
        return arrayList;
    }

    public String[] toArray() {
        List<String> list = this.getEnvironment();
        return list.toArray(new String[list.size()]);
    }

    public String toString() {
        return this.variables.toString();
    }
}

