/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.commandline;

import com.isencia.util.commandline.EnvCommandline;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedCommandline
extends EnvCommandline {
    private static final Logger logger = LoggerFactory.getLogger(ManagedCommandline.class);
    private Process currentProcess;
    private StreamGobbler stdOutGobbler;
    private StreamGobbler stdErrGobbler;
    private boolean streamLogsToLogging = false;
    private boolean streamLogsToLoggingAndSaved = false;

    public ManagedCommandline(String string) {
        super(string);
    }

    public ManagedCommandline() {
    }

    public int getExitCode() {
        return this.currentProcess != null ? this.currentProcess.exitValue() : -1;
    }

    public boolean hasTerminated() {
        try {
            this.currentProcess.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    public String getStdoutAsString() {
        return this.stdOutGobbler != null ? this.stdOutGobbler.getStreamDataAsString() : null;
    }

    public List<String> getStdoutAsList() {
        return this.stdOutGobbler != null ? this.stdOutGobbler.getStreamDataAsList() : null;
    }

    public String getStderrAsString() {
        return this.stdErrGobbler != null ? this.stdErrGobbler.getStreamDataAsString() : null;
    }

    public List<String> getStderrAsList() {
        return this.stdErrGobbler != null ? this.stdErrGobbler.getStreamDataAsList() : null;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearArgs();
    }

    @Override
    public void clearArgs() {
        this.currentProcess = null;
        this.stdOutGobbler = null;
        this.stdErrGobbler = null;
        super.clearArgs();
    }

    @Override
    public Process execute() throws IOException {
        this.currentProcess = super.execute();
        this.stdOutGobbler = new StreamGobbler(this.currentProcess.getInputStream(), String.valueOf(this.getExecutable()) + " - StdOut");
        this.stdErrGobbler = new StreamGobbler(this.currentProcess.getErrorStream(), String.valueOf(this.getExecutable()) + " - StdErr");
        this.stdOutGobbler.start();
        this.stdErrGobbler.start();
        return this.currentProcess;
    }

    public Process getProcess() {
        return this.currentProcess;
    }

    public Process waitForProcessFinished() throws IOException, IllegalStateException {
        if (this.currentProcess == null) {
            throw new IllegalStateException("No running process");
        }
        try {
            this.currentProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            logger.error("Thread was interrupted while executing command \"" + this.toString() + "\".", (Throwable)interruptedException);
        }
        this.stdOutGobbler.readRemainder();
        this.stdErrGobbler.readRemainder();
        return this.currentProcess;
    }

    public boolean isStreamLogsToLogging() {
        return this.streamLogsToLogging;
    }

    public void setStreamLogsToLogging(boolean bl) {
        this.streamLogsToLogging = bl;
    }

    public boolean isStreamLogsToLoggingAndSaved() {
        return this.streamLogsToLoggingAndSaved;
    }

    public void setStreamLogsToLoggingAndSaved(boolean bl) {
        this.streamLogsToLoggingAndSaved = bl;
    }

    public void setEnv(Map<String, String> map) {
        for (String string : map.keySet()) {
            this.setVariable(string, map.get(string));
        }
    }

    private class StreamGobbler
    extends Thread {
        private final String LINE_SEPARATOR;
        private InputStream inputStream;
        private InputStreamReader inputStreamReader;
        private boolean inputStreamReaderClosed;
        private StringBuilder streamDataAsStringBuilder;
        private List<String> streamDataAsList;

        StreamGobbler(InputStream inputStream, String string) {
            super(string);
            this.LINE_SEPARATOR = System.getProperty("line.separator");
            this.inputStreamReaderClosed = false;
            this.inputStream = inputStream;
            this.inputStreamReader = new InputStreamReader(inputStream);
            this.streamDataAsStringBuilder = new StringBuilder();
            this.streamDataAsList = new ArrayList<String>();
        }

        public String getStreamDataAsString() {
            return this.streamDataAsStringBuilder.toString();
        }

        public List<String> getStreamDataAsList() {
            return this.streamDataAsList;
        }

        @Override
        public synchronized void run() {
            if (!this.inputStreamReaderClosed) {
                try {
                    this.read();
                }
                catch (IOException iOException) {
                    logger.error("Error reading from stream by Gobbler " + this.getName(), (Throwable)iOException);
                }
            }
        }

        private synchronized void read() throws IOException {
            BufferedReader bufferedReader = new BufferedReader(this.inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (ManagedCommandline.this.streamLogsToLogging) {
                    logger.debug(String.valueOf(this.getName()) + "> " + string);
                    continue;
                }
                if (ManagedCommandline.this.streamLogsToLoggingAndSaved) {
                    logger.debug(String.valueOf(this.getName()) + "> " + string);
                    this.streamDataAsStringBuilder.append(String.valueOf(string) + this.LINE_SEPARATOR);
                    this.streamDataAsList.add(string);
                    continue;
                }
                this.streamDataAsStringBuilder.append(String.valueOf(string) + this.LINE_SEPARATOR);
                this.streamDataAsList.add(string);
            }
        }

        public synchronized void readRemainder() throws IOException {
            int n;
            char[] cArray = new char[80];
            while ((n = this.inputStreamReader.read(cArray, 0, 80)) != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("_read(): Gobbler '" + this.getName() + "' Ready: " + this.inputStreamReader.ready() + " Value: '" + String.valueOf(cArray, 0, n) + "'");
                }
                if (ManagedCommandline.this.streamLogsToLogging) {
                    logger.debug(String.valueOf(this.getName()) + "> " + new String(cArray));
                    continue;
                }
                if (ManagedCommandline.this.streamLogsToLoggingAndSaved) {
                    logger.debug(String.valueOf(this.getName()) + "> " + new String(cArray));
                    this.streamDataAsStringBuilder.append(cArray, 0, n);
                    this.streamDataAsList.add(new String(cArray));
                    continue;
                }
                this.streamDataAsStringBuilder.append(cArray, 0, n);
                this.streamDataAsList.add(new String(cArray));
            }
        }
    }
}

