/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.commandline;

import com.isencia.util.commandline.CommandLineException;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commandline
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Commandline.class);
    private Vector arguments = new Vector();
    private String executable = null;
    private File workingDir = null;

    public Commandline(String string) {
        String[] stringArray = new String[]{};
        try {
            stringArray = Commandline.translateCommandline(string);
        }
        catch (CommandLineException commandLineException) {
            LOG.error("Error translating Commandline.", (Throwable)commandLineException);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.setExecutable(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                this.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
    }

    public Commandline() {
    }

    protected File getWorkingDir() {
        return this.workingDir;
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean bl) {
        Argument argument = new Argument();
        if (bl) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void setExecutable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.executable = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.createArgument().setValue(stringArray[n]);
            ++n;
        }
    }

    public String[] getCommandline() {
        String[] stringArray = this.getArguments();
        if (this.executable == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = this.executable;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public String[] getArguments() {
        Vector<String> vector = new Vector<String>(this.arguments.size() * 2);
        int n = 0;
        while (n < this.arguments.size()) {
            Argument argument = (Argument)this.arguments.elementAt(n);
            String[] stringArray = argument.getParts();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    vector.addElement(stringArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String quoteArgument(String string) throws CommandLineException {
        if (string.indexOf("\"") > -1) {
            if (string.indexOf("'") > -1) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            return String.valueOf('\'') + string + '\'';
        }
        if (string.indexOf("'") > -1 || string.indexOf(" ") > -1) {
            return String.valueOf('\"') + string + '\"';
        }
        return string;
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            try {
                stringBuffer.append(Commandline.quoteArgument(stringArray[n]));
            }
            catch (CommandLineException commandLineException) {
                LOG.error("Error quoting argument.", (Throwable)commandLineException);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] translateCommandline(String string) throws CommandLineException {
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        block4: while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            switch (n) {
                case 1: {
                    if ("'".equals(objectArray)) {
                        n = 0;
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
                case 2: {
                    if ("\"".equals(objectArray)) {
                        n = 0;
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
                default: {
                    if ("'".equals(objectArray)) {
                        n = 1;
                        break;
                    }
                    if ("\"".equals(objectArray)) {
                        n = 2;
                        break;
                    }
                    if (" ".equals(objectArray)) {
                        if (stringBuffer.length() == 0) continue block4;
                        vector.addElement(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                }
            }
        }
        if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n == 1 || n == 2) {
            throw new CommandLineException("unbalanced quotes in " + string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.executable);
        commandline.addArguments(this.getArguments());
        return commandline;
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public void setWorkingDirectory(String string) throws CommandLineException {
        if (string != null) {
            File file = new File(string);
            this.checkWorkingDir(file);
            this.workingDir = file;
        } else {
            this.workingDir = null;
        }
    }

    public void setWorkingDir(File file) throws CommandLineException {
        this.checkWorkingDir(file);
        this.workingDir = file;
    }

    private void checkWorkingDir(File file) throws CommandLineException {
        if (file != null) {
            if (!file.exists()) {
                throw new CommandLineException("Working directory \"" + file.getAbsolutePath() + "\" does not exist!");
            }
            if (!file.isDirectory()) {
                throw new CommandLineException("Path \"" + file.getAbsolutePath() + "\" does not specify a directory.");
            }
        }
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public Process execute() throws IOException {
        Process process;
        if (this.workingDir == null) {
            LOG.debug("Executing \"" + this + "\"");
            process = Runtime.getRuntime().exec(this.getCommandline());
        } else {
            LOG.debug("Executing \"" + this + "\" in directory " + this.workingDir.getAbsolutePath());
            process = Runtime.getRuntime().exec(this.getCommandline(), null, this.workingDir);
        }
        return process;
    }

    public static class Argument {
        private String[] parts;

        public void setValue(String string) {
            this.parts = new String[]{string};
        }

        public void setLine(String string) {
            if (string == null) {
                return;
            }
            try {
                this.parts = Commandline.translateCommandline(string);
            }
            catch (CommandLineException commandLineException) {
                LOG.error("Error translating Commandline.", (Throwable)commandLineException);
            }
        }

        public void setFile(File file) {
            this.parts = new String[]{file.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int n) {
            this.position = n;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                int n = 0;
                while (n < this.position) {
                    Argument argument = (Argument)Commandline.this.arguments.elementAt(n);
                    this.realPos += argument.getParts().length;
                    ++n;
                }
            }
            return this.realPos;
        }
    }
}

