/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util;

import com.isencia.util.InvalidDateFormatException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateHandler {
    public static final String DATE_SEPARATOR = "/";
    public static final String DATE_FMT = "yyyy/MM/dd";
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    public static final String TIME_SEPARATOR = ":";
    public static final String TIME_FMT = "HH:mm:ss";
    public static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    public static final String TIMESTAMP_FMT = "yyyy/MM/dd HH:mm:ss";
    public static final SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static Date parseDateString(String string) throws InvalidDateFormatException {
        try {
            Date date = dateFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            throw new InvalidDateFormatException(string);
        }
    }

    public static Date parseTimeStampString(String string) throws InvalidDateFormatException {
        try {
            Date date = timeStampFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            throw new InvalidDateFormatException(string);
        }
    }

    public static Date parseTimeString(String string) throws InvalidDateFormatException {
        try {
            Date date = timeFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            throw new InvalidDateFormatException(string);
        }
    }

    public static String toDateString(Date date) {
        return dateFormat.format(date);
    }

    public static String toTimeStampString(Date date) {
        return timeStampFormat.format(date);
    }

    public static String toTimeString(Date date) {
        return timeFormat.format(date);
    }
}

