/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataWizardPage
extends WizardPage
implements KeyListener {
    private Text txtDirectory;
    private Text txtProject;
    private Text txtFolder;
    private final String initProject;
    private final String initDirectory;
    private final String initFolder;

    public DataWizardPage(ISelection iSelection, String string, String string2, String string3) {
        super("DataWizardPage");
        this.initProject = string != null ? string : "Data";
        this.initFolder = string2 != null ? string2 : "data";
        this.initDirectory = string3 != null ? string3 : "";
        this.setTitle("Data Project Wizard - creates a link to a directory of data files");
        this.setDescription("Wizard to create a link to a set of data files");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("&Project:");
        this.txtProject = new Text(composite2, 2048);
        this.txtProject.setText(this.initProject);
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtProject.setLayoutData((Object)gridData);
        this.txtProject.addKeyListener((KeyListener)this);
        new Composite(composite2, 0);
        Label label2 = new Label(composite2, 0);
        label2.setText("&Folder:");
        this.txtFolder = new Text(composite2, 2048);
        this.txtFolder.setText(this.initFolder);
        this.txtFolder.setEditable(true);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtFolder.setLayoutData((Object)gridData);
        this.txtFolder.addKeyListener((KeyListener)this);
        new Composite(composite2, 0);
        Label label3 = new Label(composite2, 0);
        label3.setText("&Directory:");
        this.txtDirectory = new Text(composite2, 2048);
        this.txtDirectory.setText(this.initDirectory);
        this.txtDirectory.setEditable(true);
        this.txtDirectory.setEnabled(true);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtDirectory.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataWizardPage.this.handleBrowse();
            }
        });
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void handleBrowse() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 4096);
        directoryDialog.setFilterPath(this.getDirectory());
        String string = directoryDialog.open();
        if (string != null) {
            this.txtDirectory.setText(string);
            this.dialogChanged();
        }
    }

    private void dialogChanged() {
        if (this.getProject().length() == 0) {
            this.updateStatus("Project name must be specified");
            return;
        }
        if (this.getFolder().length() == 0) {
            this.updateStatus("Folder name must be specified. e.g. data");
            return;
        }
        if (this.getDirectory().length() == 0) {
            this.updateStatus("Directory containing files must be specified.");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getProject() {
        return this.txtProject.getText();
    }

    public String getDirectory() {
        return this.txtDirectory.getText();
    }

    public void setDataLocation(String string) {
        this.txtDirectory.setText(string);
    }

    public String getFolder() {
        return this.txtFolder.getText();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.txtProject)) {
            this.dialogChanged();
        }
        if (keyEvent.getSource().equals(this.txtFolder)) {
            this.dialogChanged();
        }
    }
}

