/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.wizards;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.wizards.DataWizardPage;
import uk.ac.gda.ui.utils.ProjectUtils;

public class DataWizard
extends Wizard
implements INewWizard {
    private static final String DATA_WIZARD = "DataWizard";
    public static final String DIALOG_SETTING_KEY_DIRECTORY = "directory";
    public static final String DIALOG_SETTING_KEY_FOLDER = "folder";
    public static final String DIALOG_SETTING_KEY_PROJECT = "project";
    private static final Logger logger = LoggerFactory.getLogger(DataWizard.class);
    private DataWizardPage page;
    private ISelection selection;
    private String defaultDataLocation;
    private String defaultFolderName;

    public DataWizard() {
        this.setNeedsProgressMonitor(true);
        IDialogSettings iDialogSettings = AnalysisRCPActivator.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DATA_WIZARD);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DATA_WIZARD);
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public void addPages() {
        String string = null;
        String string2 = null;
        String string3 = null;
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            string = iDialogSettings.get(DIALOG_SETTING_KEY_PROJECT);
            string2 = iDialogSettings.get(DIALOG_SETTING_KEY_FOLDER);
            string3 = iDialogSettings.get(DIALOG_SETTING_KEY_DIRECTORY);
        }
        if (this.defaultDataLocation != null) {
            string3 = this.defaultDataLocation;
        }
        if (this.defaultFolderName != null) {
            string2 = this.defaultFolderName;
        }
        this.page = new DataWizardPage(this.selection, string, string2, string3);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String string = this.page.getProject();
        final String string2 = this.page.getDirectory();
        final String string3 = this.page.getFolder();
        Job job = new Job("Load data project"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Importing data", 100);
                try {
                    ProjectUtils.createImportProjectAndFolder((String)string, (String)string3, (String)string2, (String)"uk.ac.diamond.scisoft.analysis.rcp.GDADataNature", null, (IProgressMonitor)iProgressMonitor);
                }
                catch (CoreException coreException) {
                    logger.error("Error creating project " + string, (Throwable)coreException);
                    return new Status(4, "uk.ac.diamond.scisoft.analysis.rcp", "Error creating project " + string);
                }
                return new Status(0, "uk.ac.diamond.scisoft.analysis.rcp", "Project " + string + " created");
            }
        };
        job.setUser(true);
        job.setPriority(50);
        job.schedule(100L);
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(DIALOG_SETTING_KEY_PROJECT, string);
            iDialogSettings.put(DIALOG_SETTING_KEY_FOLDER, string3);
            iDialogSettings.put(DIALOG_SETTING_KEY_DIRECTORY, string2);
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public void setDataLocation(File file) {
        this.defaultDataLocation = file.getAbsolutePath();
        this.defaultFolderName = file.getName();
    }
}

