/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.volimage;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.views.TransferFunctionView;
import uk.ac.diamond.scisoft.analysis.rcp.volimage.ImageStreamReader;

public class CommandClient
implements IObservable,
IObserver {
    private Socket socket = null;
    private boolean isConnected = false;
    private PrintWriter writer = null;
    private BufferedReader reader = null;
    private LinkedList<IObserver> observerList = null;
    private static final int TOTALNUMTRIES = 15;
    private Logger logger = LoggerFactory.getLogger(ImageStreamReader.class);

    public CommandClient(String string, int n) {
        this.observerList = new LinkedList();
        int n2 = 15;
        while (n2 > 0) {
            try {
                this.socket = new Socket(string, n);
                if (!this.socket.isConnected()) continue;
                this.writer = new PrintWriter(this.socket.getOutputStream());
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.isConnected = true;
                n2 = 0;
            }
            catch (Exception exception) {
                --n2;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        if (n2 == 0 && !this.isConnected) {
            this.logger.error("Could not connect to commandserver # of tries exceeded");
        }
    }

    public void loadRawVolume(String string, int n, int n2, int n3, int n4, int n5) {
        String string2 = "LoadRawvolume " + string + " " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string2);
            this.writer.flush();
            try {
                String string3 = this.reader.readLine();
                if (!string3.equals("OK")) {
                    System.err.println(string3);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void loadDSRVolume(String string) {
        String string2 = "LoadDSRVolume " + string;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string2);
            this.writer.flush();
            try {
                String string3 = this.reader.readLine();
                if (!string3.equals("OK")) {
                    System.err.println(string3);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void notifyObservers(ArrayList<Integer> arrayList) {
        for (IObserver iObserver : this.observerList) {
            iObserver.update((Object)this, arrayList);
        }
    }

    public void getHistogram() {
        String string = "GetHistogram";
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string);
            this.writer.flush();
            try {
                String string2 = this.reader.readLine();
                System.err.println(string2);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (string2.startsWith("[")) {
                    String string3 = string2.substring(1);
                    int n = string3.indexOf(44);
                    String string4 = "";
                    while (n != -1) {
                        string4 = string3.substring(0, n);
                        string3 = string3.substring(n + 1);
                        n = string3.indexOf(44);
                        arrayList.add(Integer.parseInt(string4));
                    }
                    if (arrayList.size() > 0) {
                        this.notifyObservers(arrayList);
                    }
                } else {
                    System.err.println(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void rotateVolume(float f, float f2, float f3, float f4) {
        String string = "Rotate " + f + " " + f2 + " " + f3 + " " + f4;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string);
            this.writer.flush();
            try {
                String string2 = this.reader.readLine();
                if (!string2.equals("OK")) {
                    System.err.println(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void zoomVolume(float f) {
        String string = "Zoom " + f;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string);
            this.writer.flush();
            try {
                String string2 = this.reader.readLine();
                if (!string2.equals("OK")) {
                    System.err.println(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void translate(float f, float f2) {
        String string = "Translate " + f + " " + f2;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string);
            this.writer.flush();
            try {
                String string2 = this.reader.readLine();
                if (!string2.equals("OK")) {
                    System.err.println(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setDisplayMode(int n) {
        String string = "SetDisplayMode " + n;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string);
            this.writer.flush();
            try {
                String string2 = this.reader.readLine();
                if (!string2.equals("OK")) {
                    System.err.println(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setIsoValue(float f) {
        String string = "SetIsovalue " + f;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string);
            this.writer.flush();
            try {
                String string2 = this.reader.readLine();
                if (!string2.equals("OK")) {
                    System.err.println(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void loadSlicedVolume(String string, String string2, int n) {
        String string3 = "Loadvolume " + string + " " + string2 + " " + n;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string3);
            this.writer.flush();
            try {
                String string4 = this.reader.readLine();
                if (!string4.equals("OK")) {
                    System.err.println(string4);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setROI(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = "SetROI " + string + " " + string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6;
        if (this.writer != null && this.isConnected()) {
            this.writer.print(string7);
            this.writer.flush();
            try {
                String string8 = this.reader.readLine();
                if (!string8.equals("OK")) {
                    System.err.println(string8);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void addIObserver(IObserver iObserver) {
        this.observerList.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observerList.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observerList.clear();
    }

    public void update(Object object, Object object2) {
        LinkedList linkedList;
        if (object instanceof TransferFunctionView && (linkedList = (LinkedList)object2).size() == 4) {
            IDataset iDataset = (IDataset)linkedList.get(0);
            IDataset iDataset2 = (IDataset)linkedList.get(1);
            IDataset iDataset3 = (IDataset)linkedList.get(2);
            IDataset iDataset4 = (IDataset)linkedList.get(3);
            String string = "StartTransferfunction";
            if (this.writer != null && this.isConnected()) {
                this.writer.print(string);
                this.writer.flush();
                try {
                    String string2 = this.reader.readLine();
                    if (!string2.equals("OK")) {
                        System.err.println(string2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                string = "[";
                int n = 0;
                while (n < iDataset.getShape()[0]) {
                    double d = iDataset.getDouble(new int[]{n});
                    double d2 = iDataset2.getDouble(new int[]{n});
                    double d3 = iDataset3.getDouble(new int[]{n});
                    double d4 = iDataset4.getDouble(new int[]{n});
                    string = String.valueOf(string) + d + "," + d2 + "," + d3 + "," + d4;
                    if (n != iDataset.getShape()[0] - 1) {
                        string = String.valueOf(string) + ",";
                    }
                    ++n;
                }
                string = String.valueOf(string) + "]";
                System.out.println(string.length());
                if (this.writer != null && this.isConnected()) {
                    this.writer.print(string);
                    this.writer.flush();
                }
            }
        }
    }
}

