/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.plot;

import com.swtdesigner.SWTResourceManager;
import java.awt.Color;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.AbstractPlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotBean;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotView;

public class StaticScanPlotView
extends ViewPart {
    private static Logger logger = LoggerFactory.getLogger(StaticScanPlotView.class);
    public static final String ID = "gda.rcp.views.scan.StaticScanPlotView";
    protected DataSetPlotter plotter;
    protected boolean plotted;
    protected PlotBean plotBean;
    private static String TEMPLATE = "uk.ac.diamond.scisoft.analysis.rcp.views.staticplot";
    private static Collection<String> cachedNames = new HashSet<String>(31);

    public final void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.plotter = new DataSetPlotter(PlottingMode.ONED, composite, false);
        IPlotUI iPlotUI = this.createPlotActions(composite);
        this.plotter.registerUI(iPlotUI);
        this.createPlotFromBean();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iViewSite);
        if (iMemento != null) {
            try {
                this.plotBean = this.getBeanFromXML(iMemento.getTextData());
                StaticScanPlotView.addSecondId(this.plotBean.getSecondId());
            }
            catch (Exception exception) {
                logger.error("Cannot read plot bean", (Throwable)exception);
            }
        }
    }

    public void saveState(IMemento iMemento) {
        try {
            iMemento.putTextData(this.getStringFromBean(this.plotBean));
        }
        catch (Exception exception) {
            logger.error("Cannot save plot bean", (Throwable)exception);
        }
    }

    private PlotBean getBeanFromXML(String string) throws UnsupportedEncodingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(byteArrayInputStream));
        PlotBean plotBean = (PlotBean)xMLDecoder.readObject();
        xMLDecoder.close();
        return plotBean;
    }

    private String getStringFromBean(PlotBean plotBean) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(byteArrayOutputStream));
        xMLEncoder.writeObject(plotBean);
        xMLEncoder.close();
        return byteArrayOutputStream.toString("UTF-8");
    }

    public void setPlotter(PlotView plotView) {
        if (this.plotted) {
            logger.error("Cannot open " + StaticScanPlotView.class.getName() + " more than once.");
            return;
        }
        this.plotBean = plotView.getPlotBean();
        this.plotBean.setPartName(String.valueOf(plotView.getPartName()) + " (Snapshot)");
        this.createPlotFromBean();
    }

    public void setPlotter(PlotBean plotBean) {
        if (this.plotted) {
            logger.error("Cannot open " + StaticScanPlotView.class.getName() + " more than once.");
            return;
        }
        this.plotBean = plotBean;
        this.createPlotFromBean();
    }

    protected void createPlotFromBean() {
        if (this.plotBean == null) {
            return;
        }
        this.plotter.setAxisModes(AxisMode.asEnum(this.plotBean.getXAxisMode()), AxisMode.asEnum(this.plotBean.getYAxisMode()), AxisMode.LINEAR);
        if (this.plotBean.getXAxisValues2() != null) {
            this.plotter.setXAxisValues(this.plotBean.getXAxisValues2(), 1);
        }
        this.plotter.setXAxisLabel(this.plotBean.getXAxis());
        this.plotter.setYAxisLabel(this.plotBean.getYAxis());
        this.createPlotAndLegend(this.plotBean);
        this.setPartName(this.plotBean.getPartName());
        this.plotter.refresh(false);
        this.plotted = true;
    }

    protected void setSecondId(String string) {
        if (this.plotBean == null) {
            return;
        }
        this.plotBean.setSecondId(string);
    }

    protected void createPlotAndLegend(PlotBean plotBean) {
        Map<String, ? extends AbstractDataset> map = plotBean.getDataSets();
        if (map.size() > 1) {
            AbstractPlotView.createMultipleLegend(this.plotter, map);
            try {
                this.plotter.replaceAllPlots(map.values());
            }
            catch (PlotException plotException) {}
        } else {
            Plot1DAppearance plot1DAppearance = new Plot1DAppearance(Color.BLACK, Plot1DStyles.SOLID, 1, plotBean.getCurrentPlotName());
            this.plotter.getColourTable().addEntryOnLegend(plot1DAppearance);
            try {
                this.plotter.replaceCurrentPlot((IDataset)map.values().iterator().next());
            }
            catch (PlotException plotException) {}
        }
    }

    protected IPlotUI createPlotActions(Composite composite) {
        return new Plot1DUIAdapter(this.getViewSite().getActionBars(), this.plotter, composite, this.getPartName()){

            @Override
            public void buildToolActions(IToolBarManager iToolBarManager) {
                iToolBarManager.add(StaticScanPlotView.getOpenPlotAction(StaticScanPlotView.this));
                iToolBarManager.add(StaticScanPlotView.getSavePlotAction(StaticScanPlotView.this));
                super.buildToolActions(iToolBarManager);
            }
        };
    }

    public void setFocus() {
        this.plotter.requestFocus();
    }

    public static IAction getOpenStaticPlotAction(final PlotView plotView) {
        Action action = new Action(){

            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = plotView.getSite().getPage();
                    String string = StaticScanPlotView.getUniqueSecondId();
                    StaticScanPlotView staticScanPlotView = (StaticScanPlotView)iWorkbenchPage.showView(StaticScanPlotView.ID, string, 1);
                    staticScanPlotView.setPlotter(plotView);
                    staticScanPlotView.setSecondId(string);
                }
                catch (PartInitException partInitException) {
                    logger.error("Cannot find view gda.rcp.views.scan.StaticScanPlotView", (Throwable)partInitException);
                }
            }
        };
        action.setToolTipText("Save plot to separate window. Used for comparing and saving plots.");
        Image image = SWTResourceManager.getImage(StaticScanPlotView.class, "/icons/chart_curve_add.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        action.setImageDescriptor(imageDescriptor);
        return action;
    }

    public static IAction getSavePlotAction(final StaticScanPlotView staticScanPlotView) {
        return new Action("Save plot", AbstractUIPlugin.imageDescriptorFromPlugin((String)staticScanPlotView.getSite().getPluginId(), (String)"icons/disk.png")){
            FileDialog dialog;

            public void run() {
                boolean bl;
                File file;
                String string;
                if (this.dialog == null) {
                    this.dialog = new FileDialog(staticScanPlotView.getSite().getShell(), 8192);
                    this.dialog.setText("Save plot");
                    this.dialog.setFilterExtensions(new String[]{"*.xml"});
                    this.dialog.setFilterPath(System.getProperty("gda.data"));
                }
                if ((string = this.dialog.open()) == null) {
                    return;
                }
                if (!string.toLowerCase().endsWith(".xml")) {
                    string = String.valueOf(string) + ".xml";
                }
                if ((file = new File(string)).exists() && !(bl = MessageDialog.openConfirm((Shell)staticScanPlotView.getSite().getShell(), (String)"Confirm Overwrite File", (String)("The file '" + file.getName() + "' already exists.\n\nWould you like to overwrite?")))) {
                    return;
                }
                try {
                    StaticScanPlotView.setPlotBeanToFile(file, staticScanPlotView.plotBean);
                }
                catch (Exception exception) {
                    logger.error("Cannot save graph", (Throwable)exception);
                }
            }
        };
    }

    public static IAction getOpenPlotAction(final StaticScanPlotView staticScanPlotView) {
        return new Action("Open saved plot", AbstractUIPlugin.imageDescriptorFromPlugin((String)staticScanPlotView.getSite().getPluginId(), (String)"icons/folder_add.png")){
            FileDialog dialog;

            public void run() {
                String string;
                if (this.dialog == null) {
                    this.dialog = new FileDialog(staticScanPlotView.getSite().getShell(), 4096);
                    this.dialog.setText("Open a saved plot");
                    this.dialog.setFilterExtensions(new String[]{"*.xml"});
                    this.dialog.setFilterPath(System.getProperty("gda.data"));
                }
                if ((string = this.dialog.open()) == null) {
                    return;
                }
                File file = new File(string);
                if (!file.exists()) {
                    return;
                }
                try {
                    IWorkbenchPage iWorkbenchPage = staticScanPlotView.getSite().getPage();
                    String string2 = StaticScanPlotView.getUniqueSecondId();
                    StaticScanPlotView staticScanPlotView2 = (StaticScanPlotView)iWorkbenchPage.showView(StaticScanPlotView.ID, string2, 1);
                    staticScanPlotView2.setPlotter(StaticScanPlotView.getPlotBeanFromFile(file));
                    staticScanPlotView2.setSecondId(string2);
                }
                catch (Exception exception) {
                    logger.error("Cannot open graph", (Throwable)exception);
                }
            }
        };
    }

    private static PlotBean getPlotBeanFromFile(File file) throws FileNotFoundException {
        XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
        PlotBean plotBean = (PlotBean)xMLDecoder.readObject();
        xMLDecoder.close();
        return plotBean;
    }

    private static void setPlotBeanToFile(File file, PlotBean plotBean) throws FileNotFoundException {
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
        xMLEncoder.writeObject(plotBean);
        xMLEncoder.close();
    }

    private static String getUniqueSecondId() {
        int n = 1;
        while (cachedNames.contains(String.valueOf(TEMPLATE) + n)) {
            ++n;
        }
        cachedNames.add(String.valueOf(TEMPLATE) + n);
        return String.valueOf(TEMPLATE) + n;
    }

    private static void addSecondId(String string) {
        cachedNames.add(string);
    }
}

