/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.plot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.IPlotData;

public class PlotData
implements IPlotData {
    private Map<String, List<Double>> data;

    public PlotData() {
        this.data = new LinkedHashMap<String, List<Double>>();
    }

    public PlotData(Map<String, List<Double>> map) {
        this.data = map;
    }

    public PlotData(String string, List<Double> list) {
        this();
        this.data.put(string, list);
    }

    public List<Double> getData() {
        if (this.data.size() > 1) {
            throw new RuntimeException("Multiple Data - cannot determine which data in the getData() method.");
        }
        return this.data.values().iterator().next();
    }

    public Map<String, AbstractDataset> getDataMap() {
        LinkedHashMap<String, AbstractDataset> linkedHashMap = new LinkedHashMap<String, AbstractDataset>(this.data.size());
        for (String string : this.data.keySet()) {
            List<Double> list = this.data.get(string);
            if (!PlotData.validateData(list)) continue;
            linkedHashMap.put(string, AbstractDataset.createFromList(list));
        }
        return linkedHashMap;
    }

    public static boolean validateData(List<Double> list) {
        if (list.indexOf(null) > -1) {
            return false;
        }
        if (list.indexOf(Double.NaN) > -1) {
            return false;
        }
        if (list.indexOf(Double.NEGATIVE_INFINITY) > -1) {
            return false;
        }
        return list.indexOf(Double.POSITIVE_INFINITY) <= -1;
    }

    public static boolean validateData(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            if (Double.isNaN(dArray[n])) {
                return false;
            }
            if (Double.isInfinite(dArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void addData(String string, List<Double> list) {
        this.data.put(string, list);
    }

    public void addData(String string, Double d) {
        if (d == null) {
            this.data.remove(string);
            return;
        }
        List<Double> list = this.data.get(string);
        if (list == null) {
            list = new ArrayList<Double>(89);
            this.data.put(string, list);
        }
        list.add(d);
    }

    @Override
    public boolean isMulti() {
        return this.data.size() > 1;
    }

    @Override
    public int size() {
        return this.data.values().iterator().next().size();
    }

    @Override
    public AbstractDataset getDataSet() {
        return AbstractDataset.createFromList(this.getData());
    }

    public List<AbstractDataset> getDataSets() {
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(this.data.size());
        for (List<Double> list : this.data.values()) {
            arrayList.add(AbstractDataset.createFromList(list));
        }
        return arrayList;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public PlotData clone() {
        PlotData plotData = new PlotData();
        LinkedHashMap<String, List<Double>> linkedHashMap = new LinkedHashMap<String, List<Double>>(this.data.size());
        for (String string : this.data.keySet()) {
            linkedHashMap.put(string, new ArrayList(this.data.get(string)));
        }
        plotData.data = linkedHashMap;
        return plotData;
    }

    @Override
    public boolean isDataSetValid() {
        return PlotData.validateData(this.getData());
    }

    @Override
    public boolean isDataSetsValid() {
        for (List<Double> list : this.data.values()) {
            if (!PlotData.validateData(list)) continue;
            return false;
        }
        return true;
    }
}

