/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.plot;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotDataTableDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.StaticScanPlotView;

public abstract class AbstractPlotView
extends ViewPart
implements PlotView {
    protected DataSetPlotter plotter;
    protected AxisValues xAxisValues;

    protected abstract String getYAxis();

    protected abstract String getXAxis();

    protected abstract String getGraphTitle();

    protected IPlotUI createPlotActions(Composite composite) {
        return new Plot1DUIAdapter(this.getViewSite().getActionBars(), this.plotter, composite, this.getPartName()){

            @Override
            public void buildToolActions(IToolBarManager iToolBarManager) {
                iToolBarManager.add(StaticScanPlotView.getOpenStaticPlotAction(AbstractPlotView.this));
                iToolBarManager.add(this.createShowLegend());
                super.buildToolActions(iToolBarManager);
            }

            @Override
            public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
                if (plotActionEvent instanceof PlotActionComplexEvent) {
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PlotDataTableDialog plotDataTableDialog = new PlotDataTableDialog(parent.getShell(), (PlotActionComplexEvent)plotActionEvent);
                            plotDataTableDialog.open();
                        }
                    });
                } else {
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            plotter.getComposite().setToolTipText(String.valueOf(plotActionEvent.toString()) + "\nRight click to view data.");
                        }
                    });
                }
            }
        };
    }

    public void createPartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.plotter = new DataSetPlotter(PlottingMode.ONED, composite, false);
        this.plotter.getComposite().setLayoutData((Object)new GridData(4, 4, true, true));
        this.xAxisValues = new AxisValues();
        this.plotter.setAxisModes(this.getXAxisMode(), this.getYAxisMode(), AxisMode.LINEAR);
        this.plotter.setXAxisValues(this.xAxisValues, 1);
        this.plotter.setXAxisLabel(this.getXAxis());
        this.plotter.setYAxisLabel(this.getYAxis());
        this.plotter.setPlotActionEnabled(true);
        this.plotter.setPlotRightClickActionEnabled(true);
        IPlotUI iPlotUI = this.createPlotActions(composite);
        this.plotter.registerUI(iPlotUI);
        this.configurePlot(this.plotter);
    }

    public void configurePlot(DataSetPlotter dataSetPlotter) {
    }

    public static void createMultipleLegend(DataSetPlotter dataSetPlotter, Map<String, ? extends AbstractDataset> map) {
        int n = 1;
        for (String string : map.keySet()) {
            Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n, string), Plot1DStyles.SOLID, 1, string);
            dataSetPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
            ++n;
        }
    }

    public static void createMultipleLegend(DataSetPlotter dataSetPlotter, Collection<AbstractDataset> collection) {
        dataSetPlotter.getColourTable().clearLegend();
        int n = 1;
        for (IDataset iDataset : collection) {
            Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n, iDataset.getName()), Plot1DStyles.SOLID, 1, iDataset.getName());
            dataSetPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
            ++n;
        }
    }

    public AxisMode getXAxisMode() {
        return AxisMode.CUSTOM;
    }

    public AxisMode getYAxisMode() {
        return AxisMode.LINEAR;
    }

    public void setFocus() {
        this.plotter.requestFocus();
    }

    public void dispose() {
        if (this.plotter != null) {
            this.plotter.cleanUp();
        }
        super.dispose();
    }

    public DataSetPlotter getPlotter() {
        return this.plotter;
    }
}

