/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObserver;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.UserCustomFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;
import uk.ac.diamond.scisoft.analysis.rcp.volimage.CommandClient;

public class TransferFunctionView
extends HistogramView
implements Overlay1DConsumer {
    private OverlayProvider oProvider = null;
    private int isoLinePrim = -1;
    private double isoValue = 0.02;
    private int currentMin = 0;
    private int currentMax = 256;
    private int customSize = 24;
    private int oldRedSelect = 3;
    private int oldGreenSelect = 3;
    private int oldBlueSelect = 3;
    private int oldAlphaSelect = 3;
    private int[] redCustomIDs = null;
    private int[] greenCustomIDs = null;
    private int[] blueCustomIDs = null;
    private int[] alphaCustomIDs = null;
    private int customSelectID = -1;
    private byte customChannelSelect = 0;

    @Override
    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.setPartName("TransferFunction ");
        this.histograms = new LinkedList();
        this.histogramSize = 256;
        this.redCustomIDs = new int[this.customSize];
        this.greenCustomIDs = new int[this.customSize];
        this.blueCustomIDs = new int[this.customSize];
        this.alphaCustomIDs = new int[this.customSize];
        int n = 0;
        while (n < this.customSize) {
            this.redCustomIDs[n] = -1;
            this.greenCustomIDs[n] = -1;
            this.blueCustomIDs[n] = -1;
            this.alphaCustomIDs[n] = -1;
            ++n;
        }
    }

    @Override
    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.histogramPlotter.registerOverlay(this);
    }

    private void notifyObservers(LinkedList<IDataset> linkedList) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, linkedList);
        }
    }

    @Override
    protected boolean hasData() {
        return this.histograms.size() > 0;
    }

    @Override
    protected void generateHistogramUpdate() {
        if (this.histograms.size() > 0) {
            double d = ((AbstractDataset)this.histograms.get(4)).max().doubleValue();
            DoubleDataset doubleDataset = (DoubleDataset)this.histograms.get(0);
            doubleDataset.idivide((Object)d);
            DoubleDataset doubleDataset2 = (DoubleDataset)this.histograms.get(1);
            doubleDataset2.idivide((Object)d);
            DoubleDataset doubleDataset3 = (DoubleDataset)this.histograms.get(2);
            doubleDataset3.idivide((Object)d);
            DoubleDataset doubleDataset4 = (DoubleDataset)this.histograms.get(3);
            doubleDataset4.idivide((Object)d);
            LinkedList<IDataset> linkedList = new LinkedList<IDataset>();
            linkedList.add((IDataset)doubleDataset);
            linkedList.add((IDataset)doubleDataset2);
            linkedList.add((IDataset)doubleDataset3);
            linkedList.add((IDataset)doubleDataset4);
            this.notifyObservers(linkedList);
        }
    }

    private void generateHistogramUpdate(int n, int n2) {
        if (this.histograms.size() > 0) {
            double d;
            double d2;
            double d3;
            double d4;
            AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.cmbRedColour.getSelectionIndex());
            AbstractMapFunction abstractMapFunction2 = GlobalColourMaps.mappingFunctions.get(this.cmbGreenColour.getSelectionIndex());
            AbstractMapFunction abstractMapFunction3 = GlobalColourMaps.mappingFunctions.get(this.cmbBlueColour.getSelectionIndex());
            AbstractMapFunction abstractMapFunction4 = GlobalColourMaps.mappingFunctions.get(this.cmbAlpha.getSelectionIndex());
            DoubleDataset doubleDataset = new DoubleDataset(new int[]{256});
            int n3 = 0;
            while (n3 < n) {
                d4 = abstractMapFunction.mapFunction(0.0);
                if (this.curRedInverse) {
                    d4 = 1.0 - d4;
                }
                doubleDataset.set((Object)d4, new int[]{n3++});
            }
            n3 = n;
            while (n3 < n2) {
                d4 = (double)(n3 - n) / (double)(n2 - n);
                d3 = abstractMapFunction.mapFunction(d4);
                if (this.curRedInverse) {
                    d3 = 1.0 - d3;
                }
                doubleDataset.set((Object)d3, new int[]{n3++});
            }
            n3 = n2;
            while (n3 < 256) {
                d4 = abstractMapFunction.mapFunction(1.0);
                if (this.curRedInverse) {
                    d4 = 1.0 - d4;
                }
                doubleDataset.set((Object)d4, new int[]{n3++});
            }
            DoubleDataset doubleDataset2 = new DoubleDataset(new int[]{256});
            int n4 = 0;
            while (n4 < n) {
                d2 = abstractMapFunction2.mapFunction(0.0);
                if (this.curGreenInverse) {
                    d2 = 1.0 - d2;
                }
                doubleDataset2.set((Object)d2, new int[]{n4++});
            }
            n4 = n;
            while (n4 < n2) {
                d2 = (double)(n4 - n) / (double)(n2 - n);
                d = abstractMapFunction2.mapFunction(d2);
                if (this.curGreenInverse) {
                    d = 1.0 - d;
                }
                doubleDataset2.set((Object)d, new int[]{n4++});
            }
            n4 = n2;
            while (n4 < 256) {
                d2 = abstractMapFunction2.mapFunction(1.0);
                if (this.curGreenInverse) {
                    d2 = 1.0 - d2;
                }
                doubleDataset2.set((Object)d2, new int[]{n4++});
            }
            DoubleDataset doubleDataset3 = new DoubleDataset(new int[]{256});
            int n5 = 0;
            while (n5 < n) {
                d3 = abstractMapFunction3.mapFunction(0.0);
                if (this.curBlueInverse) {
                    d3 = 1.0 - d3;
                }
                doubleDataset3.set((Object)d3, new int[]{n5++});
            }
            n5 = n;
            while (n5 < n2) {
                d3 = (double)(n5 - n) / (double)(n2 - n);
                double d5 = abstractMapFunction3.mapFunction(d3);
                if (this.curBlueInverse) {
                    d5 = 1.0 - d5;
                }
                doubleDataset3.set((Object)d5, new int[]{n5++});
            }
            n5 = n2;
            while (n5 < 256) {
                d3 = abstractMapFunction3.mapFunction(1.0);
                if (this.curBlueInverse) {
                    d3 = 1.0 - d3;
                }
                doubleDataset3.set((Object)d3, new int[]{n5++});
            }
            DoubleDataset doubleDataset4 = new DoubleDataset(new int[]{256});
            int n6 = 0;
            while (n6 < n) {
                d = abstractMapFunction4.mapFunction(0.0);
                if (this.curAlphaInverse) {
                    d = 1.0 - d;
                }
                doubleDataset4.set((Object)d, new int[]{n6++});
            }
            n6 = n;
            while (n6 < n2) {
                d = (double)(n6 - n) / (double)(n2 - n);
                double d6 = abstractMapFunction4.mapFunction(d);
                if (this.curAlphaInverse) {
                    d6 = 1.0 - d6;
                }
                doubleDataset4.set((Object)d6, new int[]{n6++});
            }
            n6 = n2;
            while (n6 < 256) {
                d = abstractMapFunction4.mapFunction(1.0);
                if (this.curAlphaInverse) {
                    d = 1.0 - d;
                }
                doubleDataset4.set((Object)d, new int[]{n6++});
            }
            LinkedList<IDataset> linkedList = new LinkedList<IDataset>();
            linkedList.add((IDataset)doubleDataset);
            linkedList.add((IDataset)doubleDataset2);
            linkedList.add((IDataset)doubleDataset3);
            linkedList.add((IDataset)doubleDataset4);
            this.notifyObservers(linkedList);
        }
    }

    private void updateHistogram() {
        IDataset iDataset = (IDataset)this.histograms.get(0);
        this.xAxis.clear();
        this.xAxis.setValues(AbstractDataset.arange((double)iDataset.getSize(), (int)6));
        this.histogramPlotter.clearZoomHistory();
        this.histogramPlotter.setXAxisValues(this.xAxis, 1);
        this.updateChannelGraphs();
        this.buildGradientImage();
        if (this.oProvider == null) {
            this.histogramPlotter.registerOverlay(this);
        } else if (this.isoLinePrim == -1) {
            this.isoLinePrim = this.oProvider.registerPrimitive(PrimitiveType.LINE);
        }
    }

    private void updateHistogram(double d, double d2) {
        int n = (int)Math.floor(d);
        int n2 = (int)Math.ceil(d2);
        this.histograms.clear();
        AbstractDataset abstractDataset = this.data.getSlice(new int[]{n}, new int[]{n2}, new int[]{1});
        this.xAxis.clear();
        this.xAxis.setValues(AbstractDataset.arange((double)abstractDataset.getSize(), (int)600));
        this.histograms.add(abstractDataset);
        this.histogramPlotter.setXAxisValues(this.xAxis, 1);
        this.updateChannelGraphs();
    }

    @Override
    public void update(Object object, Object object2) {
        Serializable serializable;
        if (object instanceof CommandClient) {
            serializable = (ArrayList)object2;
            this.histograms.clear();
            this.data = new LongDataset(new int[]{((ArrayList)serializable).size()});
            int n = 0;
            while (n < ((ArrayList)serializable).size()) {
                this.data.set(((ArrayList)serializable).get(n), new int[]{n});
                ++n;
            }
            this.histograms.add(this.data);
            this.cmbAlpha.select(3);
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransferFunctionView.this.updateHistogram();
                    TransferFunctionView.this.generateHistogramUpdate();
                    TransferFunctionView.this.histogramPlotter.refresh(true);
                    TransferFunctionView.this.drawIsoLine();
                }
            });
        }
        if (object.equals(this.histogramUI) && object2 instanceof AreaSelectEvent) {
            serializable = (AreaSelectEvent)object2;
            final double d = ((AreaSelectEvent)serializable).getPosition()[0];
            final double d2 = ((AreaSelectEvent)serializable).getPosition()[1];
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransferFunctionView.this.currentMin = (int)Math.floor(d);
                    TransferFunctionView.this.currentMax = (int)Math.ceil(d2);
                    TransferFunctionView.this.updateHistogram(d, d2);
                    TransferFunctionView.this.generateHistogramUpdate((int)Math.floor(d), (int)Math.ceil(d2));
                    TransferFunctionView.this.histogramPlotter.refresh(true);
                }
            });
        }
    }

    private void drawCustomBoxes() {
        if (this.oProvider != null) {
            double d;
            double d2;
            double d3;
            int n;
            this.oProvider.begin(OverlayType.VECTOR2D);
            IDataset iDataset = (IDataset)this.histograms.get(this.histograms.size() - 1);
            double d4 = iDataset.max().doubleValue();
            AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.curRedSelect);
            double d5 = 0.015625 * d4;
            if (abstractMapFunction instanceof UserCustomFunction) {
                n = 0;
                while (n < this.customSize) {
                    if (this.redCustomIDs[n] != -1) {
                        this.oProvider.setColour(this.redCustomIDs[n], Color.RED);
                        d3 = abstractMapFunction.mapFunction((double)n / (double)this.customSize);
                        if (this.curRedInverse) {
                            d3 = 1.0 - d3;
                        }
                        d2 = (double)n * (256.0 / (double)this.customSize);
                        d = d3 * d4;
                        ((Overlay1DProvider)this.oProvider).drawBox(this.redCustomIDs[n], d2 - 4.0, d - d5, d2 + 4.0, d + d5);
                    }
                    ++n;
                }
            }
            if ((abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.curGreenSelect)) instanceof UserCustomFunction) {
                n = 0;
                while (n < this.customSize) {
                    if (this.greenCustomIDs[n] != -1) {
                        this.oProvider.setColour(this.greenCustomIDs[n], Color.GREEN);
                        d3 = abstractMapFunction.mapFunction((double)n / (double)this.customSize);
                        if (this.curGreenInverse) {
                            d3 = 1.0 - d3;
                        }
                        d2 = (double)n * (256.0 / (double)this.customSize);
                        d = d3 * d4;
                        ((Overlay1DProvider)this.oProvider).drawBox(this.greenCustomIDs[n], d2 - 4.0, d - d5, d2 + 4.0, d + d5);
                    }
                    ++n;
                }
            }
            if ((abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.curBlueSelect)) instanceof UserCustomFunction) {
                n = 0;
                while (n < this.customSize) {
                    if (this.blueCustomIDs[n] != -1) {
                        this.oProvider.setColour(this.blueCustomIDs[n], Color.BLUE);
                        d3 = abstractMapFunction.mapFunction((double)n / (double)this.customSize);
                        if (this.curBlueInverse) {
                            d3 = 1.0 - d3;
                        }
                        d2 = (double)n * (256.0 / (double)this.customSize);
                        d = d3 * d4;
                        ((Overlay1DProvider)this.oProvider).drawBox(this.blueCustomIDs[n], d2 - 4.0, d - d5, d2 + 4.0, d + d5);
                    }
                    ++n;
                }
            }
            if ((abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.curAlphaSelect)) instanceof UserCustomFunction) {
                n = 0;
                while (n < this.customSize) {
                    if (this.alphaCustomIDs[n] != -1) {
                        this.oProvider.setColour(this.alphaCustomIDs[n], Color.YELLOW);
                        d3 = abstractMapFunction.mapFunction((double)n / (double)this.customSize);
                        if (this.curAlphaInverse) {
                            d3 = 1.0 - d3;
                        }
                        d2 = (double)n * (256.0 / (double)this.customSize);
                        d = d3 * d4;
                        ((Overlay1DProvider)this.oProvider).drawBox(this.alphaCustomIDs[n], d2 - 4.0, d - d5, d2 + 4.0, d + d5);
                    }
                    ++n;
                }
            }
            this.oProvider.end(OverlayType.VECTOR2D);
        }
    }

    private void drawIsoLine() {
        if (this.isoLinePrim != -1 && this.oProvider != null) {
            this.oProvider.begin(OverlayType.VECTOR2D);
            this.oProvider.setLineThickness(this.isoLinePrim, 3.0);
            this.oProvider.setColour(this.isoLinePrim, Color.MAGENTA);
            ((Overlay1DProvider)this.oProvider).drawLine(this.isoLinePrim, this.isoValue * 256.0, 0.0, this.isoValue * 256.0, 3.4028234663852886E38);
            this.oProvider.end(OverlayType.VECTOR2D);
        }
    }

    public void setIsoValue(float f) {
        this.isoValue = f;
        this.drawIsoLine();
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.oProvider = overlayProvider;
    }

    @Override
    public void removePrimitives() {
        this.isoLinePrim = -1;
    }

    @Override
    public void unregisterProvider() {
        this.oProvider = null;
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        if (areaSelectEvent.getMode() == '\u0000') {
            boolean bl = false;
            this.customSelectID = areaSelectEvent.getPrimitiveID();
            if (this.customSelectID != -1) {
                int n = 0;
                while (n < this.customSize) {
                    if (this.customSelectID == this.redCustomIDs[n]) {
                        this.customSelectID = n;
                        this.customChannelSelect = 0;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    n = 0;
                    while (n < this.customSize) {
                        if (this.customSelectID == this.greenCustomIDs[n]) {
                            this.customSelectID = n;
                            this.customChannelSelect = 1;
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    n = 0;
                    while (n < this.customSize) {
                        if (this.customSelectID == this.blueCustomIDs[n]) {
                            this.customSelectID = n;
                            this.customChannelSelect = (byte)2;
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    n = 0;
                    while (n < this.customSize) {
                        if (this.customSelectID == this.alphaCustomIDs[n]) {
                            this.customSelectID = n;
                            this.customChannelSelect = (byte)3;
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
            }
        } else if (areaSelectEvent.getMode() == '\u0001') {
            if (this.customSelectID != -1) {
                UserCustomFunction userCustomFunction = null;
                switch (this.customChannelSelect) {
                    case 0: {
                        userCustomFunction = (UserCustomFunction)GlobalColourMaps.mappingFunctions.get(this.curRedSelect);
                        break;
                    }
                    case 1: {
                        userCustomFunction = (UserCustomFunction)GlobalColourMaps.mappingFunctions.get(this.curGreenSelect);
                        break;
                    }
                    case 2: {
                        userCustomFunction = (UserCustomFunction)GlobalColourMaps.mappingFunctions.get(this.curBlueSelect);
                        break;
                    }
                    case 3: {
                        userCustomFunction = (UserCustomFunction)GlobalColourMaps.mappingFunctions.get(this.curAlphaSelect);
                    }
                }
                IDataset iDataset = (IDataset)this.histograms.get(0);
                double d = areaSelectEvent.getPosition()[1] / iDataset.max().doubleValue();
                if (userCustomFunction != null) {
                    userCustomFunction.setValue(this.customSelectID, d);
                }
                this.updateChannelGraphs();
                this.drawCustomBoxes();
            }
        } else if (areaSelectEvent.getMode() == '\u0002' && this.customSelectID != -1) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransferFunctionView.this.generateHistogramUpdate(TransferFunctionView.this.currentMin, TransferFunctionView.this.currentMax);
                    TransferFunctionView.this.buildGradientImage();
                }
            });
        }
    }

    private void removeOldRedPrimitives() {
        AbstractMapFunction abstractMapFunction;
        if (this.oldRedSelect != this.cmbRedColour.getSelectionIndex() && (abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.oldRedSelect)) instanceof UserCustomFunction && this.oProvider != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < this.customSize) {
                arrayList.add(this.redCustomIDs[n]);
                this.redCustomIDs[n] = -1;
                ++n;
            }
            this.oProvider.unregisterPrimitive(arrayList);
        }
    }

    private void removeOldGreenPrimitives() {
        AbstractMapFunction abstractMapFunction;
        if (this.oldGreenSelect != this.cmbGreenColour.getSelectionIndex() && (abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.oldGreenSelect)) instanceof UserCustomFunction && this.oProvider != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < this.customSize) {
                arrayList.add(this.greenCustomIDs[n]);
                this.greenCustomIDs[n] = -1;
                ++n;
            }
            this.oProvider.unregisterPrimitive(arrayList);
        }
    }

    private void removeOldBluePrimitives() {
        AbstractMapFunction abstractMapFunction;
        if (this.oldBlueSelect != this.cmbBlueColour.getSelectionIndex() && (abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.oldBlueSelect)) instanceof UserCustomFunction && this.oProvider != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < this.customSize) {
                arrayList.add(this.blueCustomIDs[n]);
                this.blueCustomIDs[n] = -1;
                ++n;
            }
            this.oProvider.unregisterPrimitive(arrayList);
        }
    }

    private void removeOldAlphaPrimitives() {
        AbstractMapFunction abstractMapFunction;
        if (this.oldAlphaSelect != this.cmbAlpha.getSelectionIndex() && (abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.oldAlphaSelect)) instanceof UserCustomFunction && this.oProvider != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 0;
            while (n < this.customSize) {
                arrayList.add(this.alphaCustomIDs[n]);
                this.alphaCustomIDs[n] = -1;
                ++n;
            }
            this.oProvider.unregisterPrimitive(arrayList);
        }
    }

    @Override
    protected void handleChange(int n) {
        switch (n) {
            case 0: {
                AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.cmbRedColour.getSelectionIndex());
                if (abstractMapFunction instanceof UserCustomFunction) {
                    AbstractMapFunction abstractMapFunction2 = GlobalColourMaps.mappingFunctions.get(this.oldRedSelect);
                    int n2 = 0;
                    while (n2 < this.customSize) {
                        double d = abstractMapFunction2.mapFunction((double)n2 / (double)this.customSize);
                        ((UserCustomFunction)abstractMapFunction).setValue(n2, d);
                        if (this.oProvider != null) {
                            this.redCustomIDs[n2] = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                        }
                        ++n2;
                    }
                    this.drawCustomBoxes();
                } else {
                    this.removeOldRedPrimitives();
                }
                this.oldRedSelect = this.cmbRedColour.getSelectionIndex();
                break;
            }
            case 1: {
                AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.cmbGreenColour.getSelectionIndex());
                if (abstractMapFunction instanceof UserCustomFunction) {
                    AbstractMapFunction abstractMapFunction3 = GlobalColourMaps.mappingFunctions.get(this.oldGreenSelect);
                    int n3 = 0;
                    while (n3 < this.customSize) {
                        double d = abstractMapFunction3.mapFunction((double)n3 / (double)this.customSize);
                        ((UserCustomFunction)abstractMapFunction).setValue(n3, d);
                        if (this.oProvider != null) {
                            this.greenCustomIDs[n3] = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                        }
                        ++n3;
                    }
                    this.drawCustomBoxes();
                } else {
                    this.removeOldGreenPrimitives();
                }
                this.oldGreenSelect = this.cmbGreenColour.getSelectionIndex();
                break;
            }
            case 2: {
                AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.cmbBlueColour.getSelectionIndex());
                if (abstractMapFunction instanceof UserCustomFunction) {
                    AbstractMapFunction abstractMapFunction4 = GlobalColourMaps.mappingFunctions.get(this.oldBlueSelect);
                    int n4 = 0;
                    while (n4 < this.customSize) {
                        double d = abstractMapFunction4.mapFunction((double)n4 / (double)this.customSize);
                        ((UserCustomFunction)abstractMapFunction).setValue(n4, d);
                        if (this.oProvider != null) {
                            this.blueCustomIDs[n4] = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                        }
                        ++n4;
                    }
                    this.drawCustomBoxes();
                } else {
                    this.removeOldBluePrimitives();
                }
                this.oldBlueSelect = this.cmbBlueColour.getSelectionIndex();
                break;
            }
            case 3: {
                AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.cmbAlpha.getSelectionIndex());
                if (abstractMapFunction instanceof UserCustomFunction) {
                    AbstractMapFunction abstractMapFunction5 = GlobalColourMaps.mappingFunctions.get(this.oldAlphaSelect);
                    int n5 = 0;
                    while (n5 < this.customSize) {
                        double d = abstractMapFunction5.mapFunction((double)n5 / (double)this.customSize);
                        ((UserCustomFunction)abstractMapFunction).setValue(n5, d);
                        if (this.oProvider != null) {
                            this.alphaCustomIDs[n5] = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                        }
                        ++n5;
                    }
                    this.drawCustomBoxes();
                } else {
                    this.removeOldAlphaPrimitives();
                }
                this.oldAlphaSelect = this.cmbAlpha.getSelectionIndex();
            }
        }
    }
}

