/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlotView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotManager;

public class SidePlotView
extends ViewPart
implements ISidePlotView {
    private static final Logger logger = LoggerFactory.getLogger(SidePlotView.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.SidePlotView";
    private CTabFolder sidePlotsFolder;
    private Composite parent;
    private DataSetPlotter mainPlotter = null;
    private List<ISidePlot> sidePlots = null;
    private ISidePlot sidePlot;
    private String sId;
    private String id;
    private GuiPlotMode mode = null;
    private int currentTabIndex = -1;
    boolean needToDispose = false;
    private List<Action> switchActions = new ArrayList<Action>();
    private HistogramUpdate histoUpdate = null;
    static final long updateInterval = 50L;

    public String getId() {
        return this.id;
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.id = iViewSite.getId();
        this.sId = iViewSite.getSecondaryId();
        this.setPartName("Side: " + this.sId);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
        this.loadState(iMemento);
    }

    public void loadState(IMemento iMemento) {
    }

    public void saveState(IMemento iMemento) {
    }

    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.createSidePlotsFolder();
    }

    private void createSidePlotsFolder() {
        this.sidePlotsFolder = new CTabFolder(this.parent, 1088);
        this.sidePlotsFolder.setLayout((Layout)new FillLayout());
        this.sidePlotsFolder.setTabHeight(0);
    }

    public void disposeOverlays() {
        if (this.mainPlotter != null && !this.mainPlotter.isDisposed() && this.sidePlot != null) {
            this.mainPlotter.unRegisterOverlay(this.sidePlot);
        }
    }

    public void deactivate(boolean bl) {
        for (Action object : this.switchActions) {
            object.setChecked(false);
        }
        this.disposeOverlays();
        this.sidePlot = null;
        if (!bl) {
            try {
                this.getSite().getPage().hideView((IViewPart)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (this.sidePlots != null) {
                for (ISidePlot iSidePlot : this.sidePlots) {
                    if (iSidePlot == null || iSidePlot.isDisposed()) continue;
                    iSidePlot.dispose();
                }
            }
        }
    }

    public void dispose() {
        try {
            this.deactivate(false);
            this.mainPlotter = null;
            super.dispose();
        }
        finally {
            this.sidePlots = null;
            this.histoUpdate = null;
        }
    }

    public void setFocus() {
    }

    @Override
    public void switchSidePlot(IPlotUI iPlotUI, final int n) {
        if (this.sidePlot != null) {
            this.deactivateAllOverlays();
            this.sidePlot = null;
            if (n == this.currentTabIndex) {
                this.currentTabIndex = -1;
                if (this.switchActions.size() > n) {
                    this.switchActions.get(n).setChecked(false);
                }
                if (this.sidePlotsFolder != null) {
                    this.sidePlotsFolder.setVisible(false);
                }
                IContributionItem[] iContributionItemArray = this.getViewSite().getActionBars().getToolBarManager().getItems();
                int n2 = iContributionItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IContributionItem iContributionItem = iContributionItemArray[n3];
                    iContributionItem.dispose();
                    ++n3;
                }
                this.getViewSite().getActionBars().getToolBarManager().removeAll();
                this.getViewSite().getActionBars().getMenuManager().removeAll();
                this.getViewSite().getActionBars().updateActionBars();
                return;
            }
        }
        if (this.sidePlots == null && iPlotUI != null) {
            iPlotUI.initSidePlotView();
        }
        if (this.parent.isDisposed()) {
            return;
        }
        if (this.sidePlots.size() == 0) {
            logger.warn("Number of sideplots is zero");
            return;
        }
        try {
            this.sidePlot = this.sidePlots.get(n);
            if (this.sidePlot.isDisposed()) {
                this.sidePlot.createPartControl((Composite)this.sidePlotsFolder);
                this.sidePlot.setDisposed(false);
                int n4 = this.sidePlotsFolder.getItemCount();
                if (n >= n4) {
                    logger.error("Selected tab number {} is greater than maximum {}", (Object)n, (Object)n4);
                }
                CTabItem cTabItem = this.sidePlotsFolder.getItem(n);
                cTabItem.setControl(this.sidePlot.getControl());
            }
            if (this.histoUpdate != null) {
                this.sidePlot.processHistogramUpdate(this.histoUpdate);
            }
            this.currentTabIndex = n;
        }
        catch (Exception exception) {
            logger.error("Error opening chosen side plot", (Throwable)exception);
            this.sidePlot = this.sidePlots.get(0);
            this.currentTabIndex = 0;
        }
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IContributionItem[] iContributionItemArray = SidePlotView.this.getViewSite().getActionBars().getToolBarManager().getItems();
                int n3 = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n3) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    iContributionItem.dispose();
                    ++n2;
                }
                SidePlotView.this.getViewSite().getActionBars().getToolBarManager().removeAll();
                SidePlotView.this.getViewSite().getActionBars().getMenuManager().removeAll();
                for (IContributionItem iContributionItem : SidePlotView.this.switchActions) {
                    iContributionItem.setChecked(false);
                }
                if (SidePlotView.this.sidePlotsFolder != null) {
                    SidePlotView.this.sidePlotsFolder.setVisible(true);
                    SidePlotView.this.sidePlotsFolder.setSelection(n);
                }
                if (SidePlotView.this.switchActions.size() > n) {
                    ((Action)SidePlotView.this.switchActions.get(n)).setChecked(true);
                }
                SidePlotView.this.sidePlot.generateToolActions(SidePlotView.this.getViewSite().getActionBars().getToolBarManager());
                SidePlotView.this.sidePlot.generateMenuActions(SidePlotView.this.getViewSite().getActionBars().getMenuManager(), SidePlotView.this.getSite());
                SidePlotView.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.mainPlotter.registerOverlay(this.sidePlot);
        this.sidePlot.setMainPlotUI(iPlotUI);
        this.sidePlot.showSidePlot();
    }

    public void setPlotView(DataSetPlotter dataSetPlotter, IGuiInfoManager iGuiInfoManager) {
        PlottingMode plottingMode;
        GuiPlotMode guiPlotMode;
        this.mainPlotter = dataSetPlotter;
        if (iGuiInfoManager == null) {
            this.needToDispose = true;
        }
        if ((guiPlotMode = (plottingMode = this.mainPlotter.getMode()).getGuiPlotMode()) == null) {
            logger.error("Not supported!");
            throw new IllegalStateException("Not supported");
        }
        if (this.mode == guiPlotMode) {
            if (this.sidePlots != null) {
                for (ISidePlot iSidePlot : this.sidePlots) {
                    iSidePlot.setGuiInfoManager(iGuiInfoManager);
                    iSidePlot.setMainPlotter(this.mainPlotter);
                }
            }
            return;
        }
        this.mode = guiPlotMode;
        this.sidePlots = SidePlotManager.getDefault().getSidePlots(this.mode, this.getPartName());
        if (this.sidePlots == null) {
            return;
        }
        Control control = this.sidePlotsFolder.getItems();
        int n = ((CTabItem[])control).length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem object = control[n2];
            object.dispose();
            ++n2;
        }
        for (ISidePlot iSidePlot : this.sidePlots) {
            iSidePlot.setUpdateInterval(50L);
            iSidePlot.setGuiInfoManager(iGuiInfoManager);
            iSidePlot.setMainPlotter(this.mainPlotter);
            CTabItem cTabItem = new CTabItem(this.sidePlotsFolder, 0);
            if (iSidePlot.isDisposed()) continue;
            control = iSidePlot.getControl();
            if (control != null) {
                cTabItem.setControl(iSidePlot.getControl());
                continue;
            }
            logger.warn("Side plot disposal in inconsistent state (control wasn't disposed)");
        }
        this.sidePlotsFolder.update();
    }

    public void updateGUI(GuiBean guiBean) {
        if (this.sidePlot == null) {
            return;
        }
        this.sidePlot.updateGUI(guiBean);
    }

    @Override
    public List<Action> createSwitchActions(IPlotUI iPlotUI) {
        this.switchActions.clear();
        if (this.sidePlots == null) {
            return this.switchActions;
        }
        int n = 0;
        while (n < this.sidePlots.size()) {
            ISidePlot iSidePlot = this.sidePlots.get(n);
            this.switchActions.add(iSidePlot.createSwitchAction(n, iPlotUI));
            ++n;
        }
        return this.switchActions;
    }

    public void processPlotUpdate() {
        if (this.sidePlot == null) {
            return;
        }
        this.sidePlot.processPlotUpdate();
    }

    public void deactivateAllOverlays() {
        if (this.sidePlot == null) {
            return;
        }
        if (this.sidePlot instanceof Overlay2DConsumer) {
            ((Overlay2DConsumer)((Object)this.sidePlot)).hideOverlays();
        }
        this.sidePlot.removePrimitives();
        this.mainPlotter.unRegisterOverlay(this.sidePlot);
    }

    public void sendHistogramUpdate(HistogramUpdate histogramUpdate) {
        this.histoUpdate = histogramUpdate;
        if (this.sidePlot == null) {
            return;
        }
        this.sidePlot.processHistogramUpdate(histogramUpdate);
    }

    @Override
    public void setSwitchActions(List<Action> list) {
        if (list == null) {
            return;
        }
        if (this.switchActions == null) {
            this.switchActions = new ArrayList<Action>();
        } else {
            this.switchActions.clear();
        }
        this.switchActions.addAll(list);
    }

    @Override
    public ISidePlot getActivePlot() {
        return this.sidePlot;
    }
}

