/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObserver;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.views.TransferFunctionView;
import uk.ac.diamond.scisoft.analysis.rcp.volimage.CommandClient;
import uk.ac.diamond.scisoft.analysis.rcp.volimage.ImageStreamReader;

public class RemoteVolVizView
extends ViewPart
implements PaintListener,
MouseListener,
MouseMoveListener,
MouseWheelListener,
SelectionListener,
KeyListener,
IObserver {
    private static final String SCRIPTSTRUNIX = "#!/bin/bash\nsource /etc/profile.d/modules.sh # load up module settings for DLS system\nmodule load gigacubeR3d\nexec gigacubeR3d 9999 --offscreen\n";
    private static final String UNIXSCRIPTNAME = "runvolume.sh";
    private Canvas canvas;
    private Image testImage;
    private ImageData imgData;
    private GC testImageGC;
    private Thread imageStreamThread = null;
    ImageStreamReader streamReader = null;
    private CommandClient commandClient = null;
    private float oldMouseX;
    private float oldMouseY;
    private boolean mouseDown = false;
    private int whichMouseButton = 0;
    private TransferFunctionView transferFunctionView;
    private Action setDVRMode;
    private Action setISOMode;
    private Action setMIPMode;
    private Action setLightMode;
    private Action fitToOriginalSize;
    private Action fitToWindow;
    private Text txtRoiStartX;
    private Text txtRoiStartY;
    private Text txtRoiStartZ;
    private Text txtRoiEndX;
    private Text txtRoiEndY;
    private Text txtRoiEndZ;
    private Button btnSetROI;
    private Label lblIsoValue;
    private Scale sclIsoValue;
    private Button btnSetIsoValue;
    private Color white = null;
    private Color black = null;
    private Process serverProcess = null;
    private boolean fitToImage = false;
    private PlotServer plotServer = PlotServerProvider.getPlotServer();
    private String viewName;
    private File scriptFile = null;

    public RemoteVolVizView() {
        this.plotServer.addIObserver((IObserver)this);
    }

    public void createPartControl(Composite composite) {
        this.viewName = this.getViewSite().getRegisteredName();
        composite.setLayout((Layout)new GridLayout(4, false));
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.setDVRMode = new Action(""){

            public void run() {
                if (RemoteVolVizView.this.commandClient != null) {
                    RemoteVolVizView.this.commandClient.setDisplayMode(0);
                }
            }
        };
        this.setISOMode = new Action(""){

            public void run() {
                if (RemoteVolVizView.this.commandClient != null) {
                    RemoteVolVizView.this.commandClient.setDisplayMode(1);
                }
            }
        };
        this.setMIPMode = new Action(""){

            public void run() {
                if (RemoteVolVizView.this.commandClient != null) {
                    RemoteVolVizView.this.commandClient.setDisplayMode(2);
                }
            }
        };
        this.setLightMode = new Action(""){

            public void run() {
                if (RemoteVolVizView.this.commandClient != null) {
                    RemoteVolVizView.this.commandClient.setDisplayMode(3);
                }
            }
        };
        this.fitToOriginalSize = new Action(""){

            public void run() {
                RemoteVolVizView.this.fitToImage = true;
                RemoteVolVizView.this.canvas.redraw();
            }
        };
        this.fitToOriginalSize.setText("Fit to Image size");
        this.fitToOriginalSize.setDescription("Fit the render window to the actual image size");
        this.fitToOriginalSize.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/arrow_in.png"));
        this.fitToWindow = new Action(""){

            public void run() {
                RemoteVolVizView.this.fitToImage = false;
                RemoteVolVizView.this.canvas.redraw();
            }
        };
        this.fitToWindow.setText("Fit to window size");
        this.fitToWindow.setDescription("Fit to the display window");
        this.fitToWindow.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/arrow_out.png"));
        this.setDVRMode.setText("DVR");
        this.setDVRMode.setDescription("Switch to Direct Volume Rendering mode");
        this.setISOMode.setText("ISOSURFACE");
        this.setISOMode.setDescription("Switch to Isosurface Rendering mode");
        this.setMIPMode.setText("MIP");
        this.setMIPMode.setDescription("Switch to Maximum Intensity Projection mode");
        this.setLightMode.setDescription("Switch to Volume lighting Rendering mode");
        this.setLightMode.setText("VolumeShading");
        iActionBars.getMenuManager().add((IAction)this.setDVRMode);
        iActionBars.getMenuManager().add((IAction)this.setISOMode);
        iActionBars.getMenuManager().add((IAction)this.setMIPMode);
        iActionBars.getMenuManager().add((IAction)this.setLightMode);
        iActionBars.getToolBarManager().add((IAction)this.fitToOriginalSize);
        iActionBars.getToolBarManager().add((IAction)this.fitToWindow);
        this.imgData = new ImageData(640, 480, 24, new PaletteData(0xFF0000, 65280, 0xF0000FF));
        int n = 0;
        while (n < 480) {
            int n2 = 0;
            while (n2 < 640) {
                int n3 = n2 % 256;
                int n4 = n % 256;
                int n5 = n2 % 256;
                int n6 = (n3 << 16) + (n4 << 8) + n5;
                this.imgData.setPixel(n2, n, n6);
                ++n2;
            }
            ++n;
        }
        try {
            this.transferFunctionView = (TransferFunctionView)this.getSite().getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.views.TransferFunctionView");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        this.lblIsoValue = new Label(composite, 0);
        this.lblIsoValue.setText("Iso value: ");
        this.sclIsoValue = new Scale(composite, 2048);
        this.sclIsoValue.setMaximum(256);
        this.sclIsoValue.setMinimum(0);
        this.sclIsoValue.setIncrement(1);
        this.sclIsoValue.setSelection(5);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        this.sclIsoValue.setLayoutData((Object)gridData);
        this.sclIsoValue.addSelectionListener((SelectionListener)this);
        this.btnSetIsoValue = new Button(composite, 0);
        this.btnSetIsoValue.setText("Set iso value");
        this.btnSetIsoValue.addSelectionListener((SelectionListener)this);
        this.canvas = new Canvas(composite, 0x20000000);
        gridData = new GridData(4, 4, true, true, 4, 3);
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvas.addMouseWheelListener((MouseWheelListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.testImage = new Image((Device)this.canvas.getDisplay(), 640, 480);
        this.testImageGC = new GC((Drawable)this.testImage);
        if (this.startExternalProcess()) {
            this.streamReader = new ImageStreamReader("localhost", 9999, this.testImageGC, this.canvas);
            this.imageStreamThread = new Thread(this.streamReader);
            this.imageStreamThread.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.commandClient = new CommandClient("localhost", 10000);
            this.commandClient.addIObserver(this.transferFunctionView);
            this.transferFunctionView.addIObserver(this.commandClient);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startExternalProcess() {
        try {
            Object object;
            String string;
            String string2 = string = Platform.getInstanceLocation().getURL().getPath();
            if (System.getProperty("os.name").equals("Linux")) {
                string2 = String.valueOf(string2) + UNIXSCRIPTNAME;
                this.scriptFile = new File(string2);
                object = new FileWriter(this.scriptFile);
                try {
                    ((OutputStreamWriter)object).write(SCRIPTSTRUNIX, 0, SCRIPTSTRUNIX.length());
                    ((OutputStreamWriter)object).flush();
                    ((OutputStreamWriter)object).close();
                }
                catch (Exception exception) {
                    return false;
                }
                this.scriptFile.setExecutable(true, false);
                while (this.scriptFile.length() == 0L) {
                }
            }
            object = null;
            if (System.getProperty("os.name").equals("Linux")) {
                object = new ProcessBuilder("./runvolume.sh");
            } else if (System.getProperty("os.name").contains("Windows")) {
                object = new ProcessBuilder("gigacubeR3d", "9999", "--offscreen");
            }
            if (object != null) {
                ((ProcessBuilder)object).directory(new File(string));
                this.serverProcess = ((ProcessBuilder)object).start();
            }
            if (this.serverProcess == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        try {
            Thread.sleep(2000L);
            return true;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public void setFocus() {
    }

    public void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.canvas.getClientArea();
        if (this.white == null) {
            this.white = new Color((Device)this.canvas.getDisplay(), new RGB(255, 255, 255));
        }
        if (this.black == null) {
            this.black = new Color((Device)this.canvas.getDisplay(), new RGB(0, 0, 0));
        }
        gC.setForeground(this.white);
        gC.setBackground(this.black);
        gC.fillRectangle(rectangle);
        if (!this.fitToImage) {
            gC.drawImage(this.testImage, 0, 0, 640, 480, 0, 0, rectangle.width, rectangle.height);
        } else {
            int n = Math.max(0, rectangle.width - 640 >> 1);
            int n2 = Math.max(0, rectangle.height - 480 >> 1);
            gC.drawImage(this.testImage, n, n2);
        }
    }

    public void dispose() {
        this.streamReader.stop();
        this.serverProcess.destroy();
        System.err.println("Exit value " + this.serverProcess.exitValue());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.transferFunctionView);
        this.testImage.dispose();
        if (this.scriptFile != null) {
            this.scriptFile.delete();
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.whichMouseButton = mouseEvent.button;
        Rectangle rectangle = this.canvas.getClientArea();
        this.mouseDown = true;
        this.oldMouseX = -1.0f + (float)mouseEvent.x / ((float)rectangle.width * 0.5f);
        this.oldMouseY = 1.0f - (float)mouseEvent.y / ((float)rectangle.height * 0.5f);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.mouseDown = false;
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            Rectangle rectangle = this.canvas.getClientArea();
            float f = -1.0f + (float)mouseEvent.x / ((float)rectangle.width * 0.5f);
            float f2 = 1.0f - (float)mouseEvent.y / ((float)rectangle.height * 0.5f);
            switch (this.whichMouseButton) {
                case 1: {
                    this.commandClient.rotateVolume(f, f2, this.oldMouseX, this.oldMouseY);
                    break;
                }
                case 2: {
                    this.commandClient.translate(f - this.oldMouseX, f2 - this.oldMouseY);
                }
            }
            this.oldMouseX = f;
            this.oldMouseY = f2;
        }
    }

    public void mouseScrolled(MouseEvent mouseEvent) {
        float f = -0.1f * (float)mouseEvent.count;
        this.commandClient.zoomVolume(f);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.btnSetROI)) {
            this.commandClient.setROI(this.txtRoiStartX.getText(), this.txtRoiStartY.getText(), this.txtRoiStartZ.getText(), this.txtRoiEndX.getText(), this.txtRoiEndY.getText(), this.txtRoiEndZ.getText());
        } else if (selectionEvent.getSource().equals(this.sclIsoValue)) {
            this.transferFunctionView.setIsoValue((float)this.sclIsoValue.getSelection() / 256.0f);
        } else if (selectionEvent.getSource().equals(this.btnSetIsoValue)) {
            this.commandClient.setIsoValue((float)this.sclIsoValue.getSelection() / 256.0f);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 16777259) {
            this.commandClient.zoomVolume(0.2f);
        } else if (keyEvent.keyCode == 16777277) {
            this.commandClient.zoomVolume(-0.2f);
        }
    }

    private void processGUIUpdate(GuiUpdate guiUpdate) {
        GuiBean guiBean;
        if (guiUpdate.getGuiName().contains(this.viewName) && (guiBean = guiUpdate.getGuiData()).containsKey((Object)GuiParameters.FILENAME)) {
            String string = (String)((Object)guiBean.get((Object)GuiParameters.FILENAME));
            if (guiBean.containsKey((Object)GuiParameters.VOLUMEHEADERSIZE)) {
                int n = (Integer)guiBean.get((Object)GuiParameters.VOLUMEHEADERSIZE);
                int n2 = (Integer)guiBean.get((Object)GuiParameters.VOLUMEVOXELTYPE);
                int n3 = (Integer)guiBean.get((Object)GuiParameters.VOLUMEXDIM);
                int n4 = (Integer)guiBean.get((Object)GuiParameters.VOLUMEYDIM);
                int n5 = (Integer)guiBean.get((Object)GuiParameters.VOLUMEZDIM);
                if (this.commandClient != null) {
                    this.commandClient.loadRawVolume(string, n, n2, n3, n4, n5);
                }
            } else if (this.commandClient != null) {
                this.commandClient.loadDSRVolume(string);
            }
            if (this.commandClient != null) {
                this.canvas.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteVolVizView.this.commandClient.getHistogram();
                    }
                });
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void update(Object object, Object object2) {
        if (object2 instanceof GuiUpdate) {
            GuiUpdate guiUpdate = (GuiUpdate)object2;
            this.processGUIUpdate(guiUpdate);
        }
    }
}

