/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IUpdateNotificationListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.views.ISidePlotPart;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotViewConfig;

public class PlotView
extends ViewPart
implements IObserver,
IObservable,
IGuiInfoManager,
IUpdateNotificationListener,
ISidePlotPart {
    private static final Logger logger = LoggerFactory.getLogger(PlotView.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.plotView";
    public static final String PLOT_VIEW_MULTIPLE_ID = "uk.ac.diamond.scisoft.analysis.rcp.plotViewMultiple";
    private String id;
    private PlotWindow plotWindow;
    private PlotServer plotServer;
    private ExecutorService execSvc = null;
    protected String plotViewName = "Plot View";
    private IPlotUI plotUI = null;
    private UUID plotID = null;
    private GuiBean guiBean = null;
    private Set<IObserver> dataObservers = Collections.synchronizedSet(new LinkedHashSet());
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private GuiBean stashedGuiBean;
    private String dataBeanAvailable;
    private Thread updateThread = null;

    public String getId() {
        return this.id;
    }

    public IPlotUI getPlotUI() {
        return this.plotUI;
    }

    public PlotView() {
        this.init();
    }

    public PlotView(String string) {
        this.id = string;
        this.init();
    }

    private void init() {
        this.plotID = UUID.randomUUID();
        logger.info("Plot view uuid: {}", (Object)this.plotID);
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotServer.addIObserver((IObserver)this);
        this.execSvc = Executors.newFixedThreadPool(2);
    }

    public void createPartControl(Composite composite) {
        Object object;
        if (this.id != null) {
            logger.info("ID: {}", (Object)this.id);
            object = new PlotViewConfig(this.id);
            this.plotViewName = ((PlotViewConfig)object).getName();
            this.setPartName(((PlotViewConfig)object).getName());
        } else {
            this.plotViewName = this.getViewSite().getRegisteredName();
            object = this.getViewSite().getSecondaryId();
            if (object != null) {
                this.plotViewName = object;
                this.setPartName(this.plotViewName);
            }
        }
        logger.info("View name is {}", (Object)this.plotViewName);
        composite.setLayout((Layout)new FillLayout());
        object = this.getGUIInfo();
        this.plotWindow = new PlotWindow(composite, (GuiPlotMode)object.get((Object)GuiParameters.PLOTMODE), this, this, this.getViewSite().getActionBars(), this.getSite().getPage(), this.plotViewName);
        this.plotWindow.updatePlotMode((GuiBean)object, false);
        this.dataBeanAvailable = this.plotViewName;
        this.updateBeans();
    }

    public void setFocus() {
    }

    public void clearPlot() {
        this.plotWindow.clearPlot();
    }

    private void runUpdate() {
        while (this.dataBeanAvailable != null || this.stashedGuiBean != null) {
            Object object;
            if (this.stashedGuiBean != null) {
                object = this.stashedGuiBean;
                this.stashedGuiBean = null;
                this.plotWindow.processGUIUpdate((GuiBean)object);
            }
            if (this.dataBeanAvailable == null) continue;
            object = this.dataBeanAvailable;
            this.dataBeanAvailable = null;
            try {
                DataBean dataBean = this.plotServer.getData((String)object);
                if (dataBean == null) {
                    return;
                }
                this.updateGuiBean(dataBean);
                this.plotWindow.processPlotUpdate(dataBean);
                this.notifyDataObservers(dataBean);
            }
            catch (Exception exception) {
                logger.error("There has been an issue retrieving the databean from the plotserver", (Throwable)exception);
            }
        }
    }

    private void updateGuiBean(DataBean dataBean) {
        if (this.guiBean == null) {
            this.guiBean = new GuiBean();
        }
        if (dataBean.getGuiPlotMode() != null) {
            this.guiBean.put(GuiParameters.PLOTMODE, (Serializable)dataBean.getGuiPlotMode());
        }
        if (dataBean.getGuiParameters() != null) {
            this.guiBean.merge(dataBean.getGuiParameters());
        }
    }

    private void updateBeans() {
        if (this.updateThread == null || this.updateThread.getState() == Thread.State.TERMINATED) {
            this.updateThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PlotView.this.runUpdate();
                }
            }, "PlotViewUpdateThread");
            this.updateThread.start();
        }
    }

    public void update(Object object, Object object2) {
        GuiUpdate guiUpdate;
        if (object2 instanceof String && object2.equals(this.plotViewName)) {
            logger.debug("Getting a plot data update from " + this.plotViewName);
            this.dataBeanAvailable = this.plotViewName;
            this.updateBeans();
        }
        if (object2 instanceof GuiUpdate && (guiUpdate = (GuiUpdate)object2).getGuiName().contains(this.plotViewName)) {
            GuiBean guiBean = guiUpdate.getGuiData();
            logger.debug("Getting a plot gui update for this plot : " + guiBean.toString());
            UUID uUID = (UUID)guiBean.get((Object)GuiParameters.PLOTID);
            if (uUID == null || this.plotID.compareTo(uUID) != 0) {
                if (this.guiBean == null) {
                    this.guiBean = guiBean.copy();
                } else {
                    this.guiBean.merge(guiBean);
                }
                this.stashedGuiBean = guiBean;
                this.updateBeans();
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void addDataObserver(IObserver iObserver) {
        this.dataObservers.add(iObserver);
    }

    public void deleteDataObserver(IObserver iObserver) {
        this.dataObservers.remove(iObserver);
    }

    public void deleteDataObservers() {
        this.dataObservers.clear();
    }

    private void notifyDataObservers(DataBean dataBean) {
        for (IObserver iObserver : this.dataObservers) {
            iObserver.update((Object)this, (Object)dataBean);
        }
    }

    @Override
    public GuiBean getGUIInfo() {
        this.getGUIState();
        return this.guiBean;
    }

    private void getGUIState() {
        if (this.guiBean == null) {
            try {
                this.guiBean = this.plotServer.getGuiState(this.plotViewName);
            }
            catch (Exception exception) {
                logger.warn("Problem with getting GUI data from plot server");
            }
            if (this.guiBean == null) {
                this.guiBean = new GuiBean();
            }
        }
    }

    private void pushGUIState() {
        try {
            this.plotServer.updateGui(this.plotViewName, this.guiBean);
        }
        catch (Exception exception) {
            logger.warn("Problem with updating plot server with GUI data");
            exception.printStackTrace();
        }
    }

    @Override
    public void putGUIInfo(GuiParameters guiParameters, Serializable serializable) {
        this.getGUIState();
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotID);
        this.guiBean.put(guiParameters, serializable);
        this.pushGUIState();
    }

    @Override
    public void removeGUIInfo(GuiParameters guiParameters) {
        this.getGUIState();
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotID);
        this.guiBean.remove((Object)guiParameters);
        this.pushGUIState();
    }

    public void dispose() {
        if (this.plotWindow != null) {
            this.plotWindow.dispose();
        }
        this.execSvc.shutdown();
        this.deleteIObservers();
        this.deleteDataObservers();
        System.gc();
    }

    public String getPlotViewName() {
        return this.plotViewName;
    }

    public void updatePlotMode(GuiPlotMode guiPlotMode) {
        this.plotWindow.updatePlotMode(guiPlotMode);
    }

    public void processPlotUpdate(DataBean dataBean) {
        this.plotWindow.processPlotUpdate(dataBean);
        this.notifyDataObservers(dataBean);
    }

    public void processGUIUpdate(GuiBean guiBean) {
        this.plotWindow.processGUIUpdate(guiBean);
    }

    @Override
    public DataSetPlotter getMainPlotter() {
        return this.plotWindow.getMainPlotter();
    }

    public PlotWindow getPlotWindow() {
        return this.plotWindow;
    }

    @Override
    public void updateProcessed() {
    }

    public IMetaData getMetadata() throws Exception {
        IDataset iDataset = this.getMainPlotter().getCurrentDataSet();
        if (iDataset != null) {
            return iDataset.getMetadata();
        }
        return null;
    }

    @Override
    public ISidePlotPart.SidePlotPreference getSidePlotPreference() {
        return ISidePlotPart.SidePlotPreference.DIFFRACTION_3D;
    }
}

