/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IUpdateNotificationListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotJob;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotJobType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;

public class PlotServerConnection
implements IObserver,
IObservable,
IGuiInfoManager,
IUpdateNotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(PlotServerConnection.class);
    private PlotWindow plotWindow;
    private final PlotServer plotServer;
    private final ExecutorService execSvc;
    private final String plotName;
    private final UUID plotId;
    private PlotConsumer plotConsumer = null;
    private GuiBean guiBean = null;
    private Set<IObserver> dataObservers = Collections.synchronizedSet(new LinkedHashSet());
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());

    public PlotServerConnection(String string) {
        this.plotName = string;
        this.plotId = UUID.randomUUID();
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotServer.addIObserver((IObserver)this);
        this.execSvc = Executors.newFixedThreadPool(2);
        this.plotConsumer = new PlotConsumer(this.plotServer, string);
        this.plotConsumer.addIObserver(this);
        this.execSvc.execute(this.plotConsumer);
        this.plotConsumer.addJob(new PlotJob(PlotJobType.Data));
    }

    public void update(Object object, Object object2) {
        if (object.equals(this.plotConsumer)) {
            if (object2 instanceof DataBean) {
                this.plotWindow.processPlotUpdate((DataBean)object2);
                this.notifyDataObservers((DataBean)object2);
            } else if (object2 instanceof GuiBean) {
                this.plotWindow.processGUIUpdate((GuiBean)object2);
            }
        } else {
            GuiBean guiBean;
            UUID uUID;
            GuiUpdate guiUpdate;
            if (object2 instanceof String && object2.equals(this.plotName)) {
                this.plotConsumer.addJob(new PlotJob(PlotJobType.Data));
            }
            if (object2 instanceof GuiUpdate && (guiUpdate = (GuiUpdate)object2).getGuiName().contains(this.plotName) && ((uUID = (UUID)(guiBean = guiUpdate.getGuiData()).get((Object)GuiParameters.PLOTID)) == null || this.plotId.compareTo(uUID) != 0)) {
                if (this.guiBean == null) {
                    this.guiBean = guiBean.copy();
                } else {
                    this.guiBean.merge(guiBean);
                }
                PlotJob plotJob = new PlotJob(PlotJobType.GUI);
                plotJob.setGuiBean(guiBean);
                this.plotConsumer.addJob(plotJob);
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void addDataObserver(IObserver iObserver) {
        this.dataObservers.add(iObserver);
    }

    public void deleteDataObserver(IObserver iObserver) {
        this.dataObservers.remove(iObserver);
    }

    public void deleteDataObservers() {
        this.dataObservers.clear();
    }

    private void notifyDataObservers(DataBean dataBean) {
        for (IObserver iObserver : this.dataObservers) {
            iObserver.update((Object)this, (Object)dataBean);
        }
    }

    @Override
    public GuiBean getGUIInfo() {
        this.getGUIState();
        return this.guiBean;
    }

    private void getGUIState() {
        if (this.guiBean == null) {
            try {
                this.guiBean = this.plotServer.getGuiState(this.plotName);
            }
            catch (Exception exception) {
                logger.warn("Problem with getting GUI data from plot server");
            }
            if (this.guiBean == null) {
                this.guiBean = new GuiBean();
            }
        }
    }

    private void pushGUIState() {
        try {
            this.plotServer.updateGui(this.plotName, this.guiBean);
        }
        catch (Exception exception) {
            logger.warn("Problem with updating plot server with GUI data");
            exception.printStackTrace();
        }
    }

    @Override
    public void putGUIInfo(GuiParameters guiParameters, Serializable serializable) {
        this.getGUIState();
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotId);
        this.guiBean.put(guiParameters, serializable);
        this.pushGUIState();
    }

    @Override
    public void removeGUIInfo(GuiParameters guiParameters) {
        this.getGUIState();
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotId);
        this.guiBean.remove((Object)guiParameters);
        this.pushGUIState();
    }

    public void dispose() {
        this.plotConsumer.stop();
        this.execSvc.shutdown();
        this.deleteIObservers();
        this.deleteDataObservers();
        System.gc();
    }

    @Override
    public void updateProcessed() {
        if (this.plotConsumer != null) {
            this.plotConsumer.dataUpdateFinished();
        }
    }

    public PlotWindow getPlotWindow() {
        return this.plotWindow;
    }

    public void setPlotWindow(PlotWindow plotWindow) {
        this.plotWindow = plotWindow;
    }
}

