/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GridImageEntry;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.ImagePlayBack;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.SWTGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.SWTImageGrid;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.ImageExplorerDirectoryChooseAction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;
import uk.ac.diamond.scisoft.analysis.rcp.util.CommandExecutor;

public class ImageExplorerView
extends ViewPart
implements IObserver,
SelectionListener {
    private static final transient Logger logger = LoggerFactory.getLogger(ImageExplorerView.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView";
    public static final Object FOLDER_UPDATE_MARKER = new Object();
    private String plotViewName = "ImageExplorer View";
    private PlotServer plotServer = null;
    private Canvas canvas;
    private Group compHUD = null;
    private Composite locationRow;
    private Button btnHistoryBack;
    private Button btnHistoryForw;
    private Button btnPlay;
    private Button btnRewind;
    private Button btnStop;
    private Button btnForward;
    private Button btnPlayLoop;
    private Slider sldProgress;
    private Combo cmbDirectoryLocation;
    private Image imgPlay;
    private Image imgStill;
    private Label lblLocation;
    private SWTImageGrid imageGrid;
    private GuiBean guiBean = null;
    private UUID plotID = null;
    private final Semaphore locker = new Semaphore(1);
    private Action[] imgExtenions;
    private List<String> filter = new ArrayList<String>();
    private List<String> filesToLoad = null;
    private List<String> history = new ArrayList<String>();
    private int historyPointer = -1;
    private String currentDir = null;
    private ImagePlayBack playback = null;
    private ExecutorService execSvc = null;
    private boolean isLive = false;
    private boolean liveActive = false;
    private boolean monActive = false;
    private int curPosition = -1;
    private String dirPath;
    private boolean firstBack = false;
    private boolean isDisposed = true;
    private Composite parent;
    private boolean stopLoading = false;

    public ImageExplorerView() {
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotID = UUID.randomUUID();
        logger.info("Image explorer view uuid: {}", (Object)this.plotID);
        this.execSvc = Executors.newFixedThreadPool(2);
    }

    public static List<String> getRegisteredViews() {
        int n;
        IConfigurationElement[] iConfigurationElementArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("uk.ac.diamond.scisoft.analysis.rcp.ExplorerViewDefault");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n2 = 0;
        while (n2 < iExtensionArray.length) {
            iConfigurationElementArray = iExtensionArray[n2].getConfigurationElements();
            n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName().equals("ViewDefaultRegister") && !linkedList.contains(iConfigurationElementArray[n].getAttribute("ViewName"))) {
                    linkedList.add(iConfigurationElementArray[n].getAttribute("ViewName"));
                }
                ++n;
            }
            ++n2;
        }
        iExtensionPoint = iExtensionRegistry.getExtensionPoint("uk.ac.diamond.scisoft.analysis.rcp.ExplorerViewRegister");
        iExtensionArray = iExtensionPoint.getExtensions();
        n2 = 0;
        while (n2 < iExtensionArray.length) {
            iConfigurationElementArray = iExtensionArray[n2].getConfigurationElements();
            n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName().equals("ViewRegister") && !linkedList.contains(iConfigurationElementArray[n].getAttribute("ViewName"))) {
                    linkedList.add(iConfigurationElementArray[n].getAttribute("ViewName"));
                }
                ++n;
            }
            ++n2;
        }
        return linkedList;
    }

    public void createPartControl(Composite composite) {
        this.plotViewName = this.getViewSite().getRegisteredName();
        this.plotServer.addIObserver((IObserver)this);
        this.setPartName(this.plotViewName);
        this.parent = composite;
        composite.setLayout((Layout)new GridLayout(1, true));
        this.locationRow = new Composite(composite, 0);
        this.locationRow.setLayout((Layout)new GridLayout(4, false));
        this.btnHistoryBack = new Button(this.locationRow, 16384);
        this.btnHistoryBack.setEnabled(false);
        this.btnHistoryBack.setToolTipText("Go back in history");
        this.btnHistoryBack.setImage(AnalysisRCPActivator.getImageDescriptor("icons/arrow_left.png").createImage());
        this.btnHistoryBack.addSelectionListener((SelectionListener)this);
        this.btnHistoryForw = new Button(this.locationRow, 16384);
        this.btnHistoryForw.setEnabled(false);
        this.btnHistoryForw.setToolTipText("Go forward in history");
        this.btnHistoryForw.addSelectionListener((SelectionListener)this);
        this.btnHistoryForw.setImage(AnalysisRCPActivator.getImageDescriptor("icons/arrow_right.png").createImage());
        this.lblLocation = new Label(this.locationRow, 16384);
        this.lblLocation.setText("Location:");
        this.cmbDirectoryLocation = new Combo(this.locationRow, 18436);
        this.cmbDirectoryLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cmbDirectoryLocation.addSelectionListener((SelectionListener)this);
        this.locationRow.setLayoutData((Object)new GridData(4, 0, false, false));
        this.canvas = new Canvas(composite, 0x20000300);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compHUD = new Group(composite, 0);
        this.compHUD.setLayout((Layout)new GridLayout(6, false));
        this.compHUD.setText("Image Playback");
        this.btnRewind = new Button((Composite)this.compHUD, 8);
        this.btnRewind.setImage(AnalysisRCPActivator.getImageDescriptor("icons/control_start.png").createImage());
        this.btnRewind.addSelectionListener((SelectionListener)this);
        this.btnRewind.setToolTipText("Rewind");
        this.btnPlay = new Button((Composite)this.compHUD, 2);
        this.imgPlay = AnalysisRCPActivator.getImageDescriptor("icons/control_play.png").createImage();
        this.imgStill = AnalysisRCPActivator.getImageDescriptor("icons/control_pause.png").createImage();
        this.btnPlay.setImage(this.imgPlay);
        this.btnPlay.addSelectionListener((SelectionListener)this);
        this.btnPlay.setToolTipText("Play/Pause");
        this.btnStop = new Button((Composite)this.compHUD, 8);
        this.btnStop.setImage(AnalysisRCPActivator.getImageDescriptor("icons/control_stop.png").createImage());
        this.btnStop.addSelectionListener((SelectionListener)this);
        this.btnStop.setToolTipText("Stop playback");
        this.btnForward = new Button((Composite)this.compHUD, 8);
        this.btnForward.setImage(AnalysisRCPActivator.getImageDescriptor("icons/control_end.png").createImage());
        this.btnForward.addSelectionListener((SelectionListener)this);
        this.btnForward.setToolTipText("Forward");
        this.btnPlayLoop = new Button((Composite)this.compHUD, 2);
        this.btnPlayLoop.setImage(AnalysisRCPActivator.getImageDescriptor("icons/control_repeat.png").createImage());
        this.btnPlayLoop.setToolTipText("Playback loop (On/off)");
        this.btnPlayLoop.addSelectionListener((SelectionListener)this);
        this.sldProgress = new Slider((Composite)this.compHUD, 256);
        this.sldProgress.setPageIncrement(1);
        this.sldProgress.setThumb(1);
        this.sldProgress.addSelectionListener((SelectionListener)this);
        this.sldProgress.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compHUD.setLayoutData((Object)new GridData(4, 0, true, false));
        this.imageGrid = new SWTImageGrid(this.canvas, this.plotViewName);
        GlobalColourMaps.InitializeColourMaps();
        this.retainStateFromServer();
        if (this.dirPath != null && this.dirPath.length() > 0) {
            this.dirPath.trim();
            Job job = new Job("Update directory"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    ImageExplorerDirectoryChooseAction.setImageFolder(ImageExplorerView.this.dirPath, ImageExplorerView.this.filter);
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setPriority(50);
            job.schedule(1000L);
            this.cmbDirectoryLocation.setText(this.dirPath);
            this.currentDir = this.dirPath;
        }
        this.playback = new ImagePlayBack(this.getPreferencePlaybackView(), this.getViewSite().getPage(), this.sldProgress, this.getPreferenceTimeDelay(), this.getPreferencePlaybackRate());
        this.isDisposed = false;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
        String string = "";
        if (iMemento != null) {
            this.dirPath = iMemento.getString("DIR");
            string = iMemento.getString("FILTERS");
            if (string == null) {
                string = "";
            }
        }
        this.imgExtenions = new Action[ImageExplorerDirectoryChooseAction.LISTOFSUFFIX.length];
        MenuManager menuManager = new MenuManager("File Filters");
        int n = 0;
        while (n < ImageExplorerDirectoryChooseAction.LISTOFSUFFIX.length) {
            final int n2 = n;
            this.imgExtenions[n] = new Action("", 2){

                public void run() {
                    if (this.isChecked()) {
                        ImageExplorerView.this.filter.remove(ImageExplorerDirectoryChooseAction.LISTOFSUFFIX[n2]);
                    } else {
                        ImageExplorerView.this.filter.add(ImageExplorerDirectoryChooseAction.LISTOFSUFFIX[n2]);
                    }
                }
            };
            this.imgExtenions[n].setText(ImageExplorerDirectoryChooseAction.LISTOFSUFFIX[n]);
            this.imgExtenions[n].setDescription("Filter " + ImageExplorerDirectoryChooseAction.LISTOFSUFFIX[n] + " on/off");
            if (string.contains(ImageExplorerDirectoryChooseAction.LISTOFSUFFIX[n])) {
                this.imgExtenions[n].setChecked(false);
                this.filter.add(ImageExplorerDirectoryChooseAction.LISTOFSUFFIX[n]);
            } else {
                this.imgExtenions[n].setChecked(true);
            }
            menuManager.add((IAction)this.imgExtenions[n]);
            ++n;
        }
        iViewSite.getActionBars().getMenuManager().add((IContributionItem)menuManager);
    }

    public void saveState(IMemento iMemento) {
        if (this.dirPath != null && iMemento != null) {
            iMemento.putString("DIR", this.dirPath);
        }
        if (iMemento != null) {
            String string = "";
            Iterator<String> iterator = this.filter.iterator();
            while (iterator.hasNext()) {
                string = string.length() == 0 ? String.valueOf(string) + iterator.next() : String.valueOf(string) + "|" + iterator.next();
            }
            if (string.length() > 0) {
                iMemento.putString("FILTERS", string);
            }
        }
    }

    public String getPlotViewName() {
        return this.plotViewName;
    }

    public void setDirPath(String string) {
        this.dirPath = string;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setFocus() {
    }

    public void setOverviewMode(boolean bl) {
        if (this.imageGrid != null) {
            this.imageGrid.setOverviewMode(bl);
        }
    }

    public boolean getOverviewMode() {
        if (this.imageGrid != null) {
            return this.imageGrid.getOverviewMode();
        }
        return false;
    }

    public ArrayList<String> getSelection() {
        return this.imageGrid.getSelection();
    }

    private void processNewFile(GuiBean guiBean) {
        try {
            this.locker.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.playback.addFile((String)((Object)guiBean.get((Object)GuiParameters.FILENAME)));
        SWTGridEntry sWTGridEntry = new SWTGridEntry((String)((Object)guiBean.get((Object)GuiParameters.FILENAME)), null, this.canvas, this.getPreferenceColourMapChoice(), this.getPreferenceAutoContrastLo(), this.getPreferenceAutoContrastHi());
        Integer n = (Integer)guiBean.get((Object)GuiParameters.IMAGEGRIDXPOS);
        Integer n2 = (Integer)guiBean.get((Object)GuiParameters.IMAGEGRIDYPOS);
        if (n != null && n2 != null) {
            this.imageGrid.addEntry(sWTGridEntry, n, n2);
        } else {
            this.imageGrid.addEntry(sWTGridEntry);
        }
        this.locker.release();
        if (this.liveActive) {
            this.playback.moveToLast();
        }
    }

    private void processNewGrid(GuiBean guiBean) {
        final Integer[] integerArray = (Integer[])guiBean.get((Object)GuiParameters.IMAGEGRIDSIZE);
        if (integerArray != null && integerArray.length > 0) {
            try {
                this.locker.acquire();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.canvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageExplorerView.this.imageGrid.dispose();
                    if (integerArray.length == 1) {
                        ImageExplorerView.this.imageGrid = new SWTImageGrid(integerArray[0], integerArray[0], ImageExplorerView.this.canvas, ImageExplorerView.this.plotViewName);
                    } else {
                        ImageExplorerView.this.imageGrid = new SWTImageGrid(integerArray[1], integerArray[0], ImageExplorerView.this.canvas, ImageExplorerView.this.plotViewName);
                    }
                    ImageExplorerView.this.locker.release();
                    ImageExplorerView.this.canvas.redraw();
                }
            });
        }
        this.cleanUpOnServer();
    }

    private void processGUIUpdate(GuiUpdate guiUpdate) {
        GuiBean guiBean;
        UUID uUID;
        if (guiUpdate.getGuiName().contains(this.plotViewName) && ((uUID = (UUID)(guiBean = guiUpdate.getGuiData()).get((Object)GuiParameters.PLOTID)) == null || this.plotID.compareTo(uUID) != 0)) {
            if (this.guiBean == null) {
                this.guiBean = guiBean.copy();
            } else {
                this.guiBean.merge(guiBean);
            }
            if (guiBean.containsKey((Object)GuiParameters.FILEOPERATION)) {
                return;
            }
            if (guiBean.containsKey((Object)GuiParameters.PLOTMODE)) {
                GuiPlotMode guiPlotMode = (GuiPlotMode)guiBean.get((Object)GuiParameters.PLOTMODE);
                if (guiPlotMode.equals((Object)GuiPlotMode.IMGEXPL)) {
                    if (guiBean.containsKey((Object)GuiParameters.FILENAME)) {
                        if (this.filesToLoad == null) {
                            this.filesToLoad = new ArrayList<String>();
                        }
                        this.filesToLoad.add((String)((Object)guiBean.get((Object)GuiParameters.FILENAME)));
                        this.processNewFile(guiBean);
                    } else if (guiBean.containsKey((Object)GuiParameters.IMAGEGRIDSIZE)) {
                        if (this.filesToLoad == null) {
                            this.filesToLoad = new ArrayList<String>();
                        } else {
                            this.filesToLoad.clear();
                        }
                        this.btnPlay.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ImageExplorerView.this.resetPlaying(true);
                            }
                        });
                        this.processNewGrid(guiBean);
                    }
                }
            } else if (guiBean.containsKey((Object)GuiParameters.IMAGEGRIDLIVEVIEW)) {
                String string = (String)((Object)guiBean.get((Object)GuiParameters.IMAGEGRIDLIVEVIEW));
                this.spawnLoadJob(string);
                this.currentDir = string;
                this.isLive = true;
                this.liveActive = true;
            }
        }
    }

    private void processClientLocalUpdate() {
        GuiBean guiBean = new GuiBean();
        int n = (int)Math.ceil(Math.sqrt(this.filesToLoad.size()));
        if (this.imageGrid != null) {
            this.imageGrid.dispose();
        }
        this.imageGrid = new SWTImageGrid(n, n, this.canvas, this.plotViewName);
        for (String string : this.filesToLoad) {
            guiBean.put(GuiParameters.FILENAME, (Serializable)((Object)string));
            this.processNewFile(guiBean);
        }
        if (this.liveActive) {
            this.sldProgress.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageExplorerView.this.playback.moveToLast();
                }
            });
        }
    }

    public void update(Object object, Object object2) {
        if (this.stopLoading) {
            return;
        }
        if (object == FOLDER_UPDATE_MARKER) {
            if (object2 instanceof List) {
                this.playback.clearPlayback();
                this.btnPlay.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageExplorerView.this.resetPlaying(false);
                        if (ImageExplorerView.this.isLive) {
                            ImageExplorerView.this.playback.setDelay(50);
                            ImageExplorerView.this.playback.setStepping(1);
                            ImageExplorerView.this.playback.start();
                            ImageExplorerView.this.btnPlay.setSelection(true);
                            ImageExplorerView.this.btnPlay.setImage(ImageExplorerView.this.imgStill);
                            ImageExplorerView.this.execSvc.execute(ImageExplorerView.this.playback);
                            if (!ImageExplorerView.this.monActive) {
                                CommandExecutor.executeCommand(ImageExplorerView.this.getViewSite(), "uk.ac.diamond.scisoft.analysis.rcp.MontorDirectoryAction");
                            }
                            ImageExplorerView.this.cmbDirectoryLocation.setText(ImageExplorerView.this.currentDir);
                            ImageExplorerView.this.isLive = false;
                        }
                    }
                });
                this.filesToLoad = (List)object2;
                this.processClientLocalUpdate();
            }
        } else if (object2 instanceof GuiUpdate) {
            GuiUpdate guiUpdate = (GuiUpdate)object2;
            this.processGUIUpdate(guiUpdate);
        }
    }

    private void cleanUpOnServer() {
        FileOperationBean fileOperationBean = new FileOperationBean(7);
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.FILEOPERATION, (Serializable)fileOperationBean);
        try {
            this.plotServer.updateGui(this.plotViewName, guiBean);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void retainStateFromServer() {
        try {
            GuiBean guiBean = this.plotServer.getGuiState(this.plotViewName);
            if (guiBean != null && guiBean.containsKey((Object)GuiParameters.IMAGEGRIDSTORE)) {
                ArrayList arrayList = (ArrayList)guiBean.get((Object)GuiParameters.IMAGEGRIDSTORE);
                for (GridImageEntry gridImageEntry : arrayList) {
                    SWTGridEntry sWTGridEntry = new SWTGridEntry(gridImageEntry.getFilename(), null, this.canvas, this.getPreferenceColourMapChoice(), this.getPreferenceAutoContrastLo(), this.getPreferenceAutoContrastHi());
                    this.imageGrid.addEntry(sWTGridEntry, gridImageEntry.getGridColumnPos(), gridImageEntry.getGridRowPos());
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Problem with getting GUI data from plot server");
        }
    }

    private GuiBean saveStateToServer() {
        this.plotServer.deleteIObserver((IObserver)this);
        if (this.imageGrid == null) {
            return null;
        }
        ArrayList<GridImageEntry> arrayList = this.imageGrid.getListOfEntries();
        GuiBean guiBean = new GuiBean();
        guiBean.put(GuiParameters.PLOTMODE, (Serializable)GuiPlotMode.IMGEXPL);
        guiBean.put(GuiParameters.IMAGEGRIDSTORE, arrayList);
        return guiBean;
    }

    public void dispose() {
        this.isDisposed = true;
        GuiBean guiBean = this.saveStateToServer();
        if (this.imageGrid != null) {
            this.imageGrid.dispose();
        }
        if (guiBean != null) {
            try {
                this.plotServer.updateGui(this.plotViewName, guiBean);
            }
            catch (Exception exception) {
                logger.warn("Problem with updating plot server with GUI data");
                exception.printStackTrace();
            }
        }
        this.playback.dispose();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void pushGUIUpdate(GuiParameters guiParameters, Serializable serializable) {
        if (this.guiBean == null) {
            try {
                this.guiBean = this.plotServer.getGuiState(this.plotViewName);
            }
            catch (Exception exception) {
                logger.warn("Problem with getting GUI data from plot server");
            }
            if (this.guiBean == null) {
                this.guiBean = new GuiBean();
            }
        }
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotID);
        this.guiBean.put(guiParameters, serializable);
        try {
            logger.info("Pushing bean to server: {}", (Object)this.guiBean);
            this.plotServer.updateGui(this.plotViewName, this.guiBean);
        }
        catch (Exception exception) {
            logger.warn("Problem with updating plot server with GUI data");
            exception.printStackTrace();
        }
    }

    public void pushSelectedFiles(ArrayList<String> arrayList) {
        this.pushGUIUpdate(GuiParameters.FILESELECTEDLIST, arrayList);
    }

    private void spawnLoadJob(final String string) {
        Job job = new Job("Update directory"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (!ImageExplorerDirectoryChooseAction.setImageFolder(string, ImageExplorerView.this.filter)) {
                    return new Status(4, "ERROR", "Couldn't load directory it either doesn't exist or has no files");
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(50);
        job.schedule(100L);
    }

    private void addToHistory() {
        if (this.currentDir != null) {
            this.history.add(0, new String(this.currentDir));
        }
    }

    private void resetHistory() {
        this.historyPointer = 0;
        this.firstBack = true;
        this.btnHistoryBack.setEnabled(true);
        this.btnHistoryForw.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        String string;
        if (selectionEvent.getSource().equals(this.cmbDirectoryLocation) && (string = this.cmbDirectoryLocation.getText()) != null && string.length() > 0) {
            string.trim();
            this.addToHistory();
            this.resetHistory();
            String[] stringArray = this.cmbDirectoryLocation.getItems();
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                if (this.cmbDirectoryLocation.getItemCount() > 0) {
                    this.cmbDirectoryLocation.add(string, 0);
                } else {
                    this.cmbDirectoryLocation.add(string);
                }
            }
            this.resetPlaying(true);
            this.spawnLoadJob(string);
            this.currentDir = string;
        }
    }

    public void setLocationText(String string) {
        if (this.cmbDirectoryLocation != null && !this.cmbDirectoryLocation.isDisposed()) {
            this.cmbDirectoryLocation.setText(string);
        }
    }

    public List<String> getExtensionsFilter() {
        return this.filter;
    }

    private void resetPlaying(boolean bl) {
        this.playback.stop();
        if (bl) {
            this.playback.clearPlayback();
        }
        this.btnPlay.setSelection(false);
        this.btnPlay.setImage(this.imgPlay);
        this.sldProgress.setSelection(0);
        this.curPosition = -1;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.cmbDirectoryLocation)) {
            String string = this.cmbDirectoryLocation.getItem(this.cmbDirectoryLocation.getSelectionIndex());
            if (string != null && string.length() > 0) {
                this.addToHistory();
                this.resetHistory();
                this.resetPlaying(true);
                this.spawnLoadJob(string);
                this.currentDir = string;
            }
        } else if (selectionEvent.getSource().equals(this.btnHistoryBack)) {
            String string = this.history.get(this.historyPointer);
            this.btnHistoryForw.setEnabled(true);
            this.cmbDirectoryLocation.setText(string);
            this.resetPlaying(true);
            this.spawnLoadJob(string);
            ++this.historyPointer;
            if (this.historyPointer >= this.history.size()) {
                this.btnHistoryBack.setEnabled(false);
                this.historyPointer = this.history.size() - 1;
            }
            if (this.firstBack) {
                this.addToHistory();
                this.firstBack = false;
                ++this.historyPointer;
            }
        } else if (selectionEvent.getSource().equals(this.btnHistoryForw)) {
            --this.historyPointer;
            String string = this.history.get(this.historyPointer);
            this.resetPlaying(true);
            this.spawnLoadJob(string);
            this.cmbDirectoryLocation.setText(string);
            this.btnHistoryBack.setEnabled(true);
            if (this.historyPointer <= 0) {
                this.btnHistoryForw.setEnabled(false);
                this.historyPointer = 1;
            }
        } else if (selectionEvent.getSource().equals(this.btnPlay)) {
            if (this.btnPlay.getSelection()) {
                boolean bl = this.playback.isPaused();
                this.btnPlay.setImage(this.imgStill);
                this.playback.start();
                if (!bl) {
                    this.playback.setSelection(this.getSelection());
                    this.playback.setDelay(this.getPreferenceTimeDelay());
                    this.playback.setStepping(this.getPreferencePlaybackRate());
                    this.execSvc.execute(this.playback);
                }
            } else {
                this.playback.pause();
                this.btnPlay.setImage(this.imgPlay);
            }
        } else if (selectionEvent.getSource().equals(this.btnStop)) {
            this.sldProgress.setSelection(0);
            this.curPosition = -1;
            this.btnPlay.setSelection(false);
            this.btnPlay.setImage(this.imgPlay);
            this.playback.stop();
        } else if (selectionEvent.getSource().equals(this.btnRewind)) {
            this.sldProgress.setSelection(0);
            this.curPosition = -1;
            this.playback.rewind();
        } else if (selectionEvent.getSource().equals(this.btnForward)) {
            this.sldProgress.setSelection(this.sldProgress.getMaximum());
            this.playback.forward();
        } else if (selectionEvent.getSource().equals(this.sldProgress)) {
            int n = this.sldProgress.getSelection();
            if (n != this.curPosition) {
                this.playback.setPlayPos(n);
                this.curPosition = n;
            }
        } else if (selectionEvent.getSource().equals(this.btnPlayLoop)) {
            this.playback.setAutoRewind(this.btnPlayLoop.getSelection());
        }
    }

    public void setLocationBarVisible(boolean bl) {
        this.locationRow.setVisible(bl);
        ((GridData)this.locationRow.getLayoutData()).exclude = !bl;
        this.parent.layout();
    }

    public void setImageGridVisible(boolean bl) {
        this.canvas.setVisible(bl);
        ((GridData)this.canvas.getLayoutData()).exclude = !bl;
        this.parent.layout();
    }

    public void stopLoading(boolean bl) {
        if (bl) {
            this.imageGrid.stopLoading();
        }
        this.stopLoading = bl;
    }

    public boolean isStopped() {
        return this.stopLoading;
    }

    public List<String> getLoadedFiles() {
        return this.filesToLoad;
    }

    private int getPreferenceColourMapChoice() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("imageExplorer.colourMap") ? iPreferenceStore.getDefaultInt("imageExplorer.colourMap") : iPreferenceStore.getInt("imageExplorer.colourMap");
    }

    private int getPreferenceTimeDelay() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("imageExplorer.timeDelay") ? iPreferenceStore.getDefaultInt("imageExplorer.timeDelay") : iPreferenceStore.getInt("imageExplorer.timeDelay");
    }

    private int getPreferencePlaybackRate() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("imageExplorer.playbackRate") ? iPreferenceStore.getDefaultInt("imageExplorer.playbackRate") : iPreferenceStore.getInt("imageExplorer.playbackRate");
    }

    private double getPreferenceAutoContrastLo() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        int n = iPreferenceStore.isDefault("imageExplorer.autoContrastLoThreshold") ? iPreferenceStore.getDefaultInt("imageExplorer.autoContrastLoThreshold") : iPreferenceStore.getInt("imageExplorer.autoContrastLoThreshold");
        return (double)n / 100.0;
    }

    private double getPreferenceAutoContrastHi() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        int n = iPreferenceStore.isDefault("imageExplorer.autoContrastHiThreshold") ? iPreferenceStore.getDefaultInt("imageExplorer.autoContrastHiThreshold") : iPreferenceStore.getInt("imageExplorer.autoContrastHiThreshold");
        return (double)n / 100.0;
    }

    public String getPreferencePlaybackView() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("imageExplorer.playbackView") ? iPreferenceStore.getDefaultString("imageExplorer.playbackView") : iPreferenceStore.getString("imageExplorer.playbackView");
    }

    public void setMonitorActive(boolean bl) {
        this.monActive = bl;
    }

    public void play() {
        boolean bl = this.playback.isPaused();
        this.btnPlay.setImage(this.imgStill);
        this.playback.start();
        if (!bl) {
            this.playback.setSelection(this.getSelection());
            this.playback.setDelay(this.getPreferenceTimeDelay());
            this.playback.setStepping(this.getPreferencePlaybackRate());
            this.execSvc.execute(this.playback);
        }
    }
}

