/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.dataset.function.Histogram;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUI;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.SpecialExposureFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;

public class HistogramView
extends ViewPart
implements SelectionListener,
IObservable,
IObserver {
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView";
    private static HashMap<String, Integer> colourSettings = new HashMap();
    protected List<AbstractDataset> histograms = null;
    protected List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    protected DataSetPlotter histogramPlotter;
    protected AxisValues xAxis = null;
    protected Composite parent;
    protected int histogramSize = 128;
    private static final int SLIDERSECTIONS = 1000;
    protected AbstractDataset data = null;
    private CCombo cmbColourMap;
    private Composite composite;
    private Composite container;
    private Button btnExpertMode;
    protected CCombo cmbAlpha;
    protected CCombo cmbRedColour;
    protected CCombo cmbGreenColour;
    protected CCombo cmbBlueColour;
    protected Button btnGreenInverse;
    protected Button btnBlueInverse;
    protected Button btnAlphaInverse;
    protected Button btnRedInverse;
    protected double specialMinThreshold = 0.1;
    protected double specialMaxThreshold = 0.9;
    protected int curRedSelect = 3;
    protected int curGreenSelect = 3;
    protected int curBlueSelect = 3;
    protected int curAlphaSelect = 3;
    protected boolean curRedInverse = false;
    protected boolean curGreenInverse = false;
    protected boolean curBlueInverse = false;
    protected boolean curAlphaInverse = false;
    private Spinner spnMinValue;
    private Spinner spnMaxValue;
    private Slider sldMinValue;
    private Slider sldMaxValue;
    private FloatSpinner spnRangeStart;
    private FloatSpinner spnRangeStop;
    private Histogram histogramFunc = new Histogram(this.histogramSize);
    protected IPlotUI histogramUI = null;
    private MaxMin currentMaxMin;
    private Map<Integer, MaxMin> cachedMaxMin;
    private boolean autoContrast = true;
    private boolean lockRange = false;
    private boolean useLog = false;
    private String id;
    private String sId;
    private Composite advancedComp;
    private Group expertGroup;
    private Group threshPanel;
    private Group rangePanel;

    public HistogramView() {
        this.xAxis = new AxisValues();
        this.cachedMaxMin = new HashMap<Integer, MaxMin>();
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.id = iViewSite.getId();
        this.sId = iViewSite.getSecondaryId();
        if (this.sId == null) {
            this.setPartName("Colour Mapping");
        } else {
            try {
                this.setPartName("Colour Mapping: " + new File(this.sId).getName());
            }
            catch (Exception exception) {
                this.setPartName("Colour Mapping");
            }
        }
    }

    protected void buildToolbar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.histogramUI = new HistogramUI(this, iActionBars, this.histogramPlotter);
        this.histogramUI.addIObserver(this);
        this.histogramPlotter.registerUI(this.histogramUI);
    }

    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(this.container, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(composite2, 0);
        label.setText("Colour Scheme");
        this.cmbColourMap = new CCombo(composite2, 2056);
        this.cmbColourMap.setToolTipText("Change the color scheme.");
        this.cmbColourMap.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnExpertMode = new Button(composite2, 32);
        this.btnExpertMode.setText("Expert");
        this.btnExpertMode.setToolTipText("Enable expert mode for customising colour channels");
        this.btnExpertMode.addSelectionListener((SelectionListener)this);
        this.advancedComp = new Composite(this.container, 0);
        this.advancedComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.advancedComp.setLayout((Layout)new GridLayout(3, false));
        this.expertGroup = new Group(this.advancedComp, 0);
        this.expertGroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.expertGroup.setLayout((Layout)new GridLayout(3, false));
        Object object = new Label((Composite)this.expertGroup, 0);
        object.setText("Red");
        this.cmbRedColour = new CCombo((Composite)this.expertGroup, 2056);
        this.btnRedInverse = new Button((Composite)this.expertGroup, 32);
        this.btnRedInverse.setText("Inverse");
        this.btnRedInverse.addSelectionListener((SelectionListener)this);
        Object object2 = new Label((Composite)this.expertGroup, 0);
        object2.setText("Green");
        this.cmbGreenColour = new CCombo((Composite)this.expertGroup, 2056);
        this.btnGreenInverse = new Button((Composite)this.expertGroup, 32);
        this.btnGreenInverse.setText("Inverse");
        this.btnGreenInverse.addSelectionListener((SelectionListener)this);
        Label label2 = new Label((Composite)this.expertGroup, 0);
        label2.setText("Blue");
        this.cmbBlueColour = new CCombo((Composite)this.expertGroup, 2056);
        this.btnBlueInverse = new Button((Composite)this.expertGroup, 32);
        this.btnBlueInverse.setText("Inverse");
        this.btnBlueInverse.addSelectionListener((SelectionListener)this);
        Label label3 = new Label((Composite)this.expertGroup, 0);
        label3.setText("Alpha");
        this.cmbAlpha = new CCombo((Composite)this.expertGroup, 2056);
        this.btnAlphaInverse = new Button((Composite)this.expertGroup, 32);
        this.btnAlphaInverse.setText("Inverse");
        this.btnAlphaInverse.addSelectionListener((SelectionListener)this);
        this.expertGroup.setVisible(this.getPreferenceColourMapExpertMode());
        ((GridData)this.expertGroup.getLayoutData()).exclude = !this.getPreferenceColourMapExpertMode();
        this.threshPanel = new Group(this.advancedComp, 0);
        this.threshPanel.setText("Mark's special threshhold");
        this.threshPanel.setLayoutData((Object)new GridData(4, 128, false, false));
        this.threshPanel.setLayout((Layout)new GridLayout(2, false));
        object = new Label((Composite)this.threshPanel, 0);
        object.setText("Min threshold");
        this.spnMinValue = new Spinner((Composite)this.threshPanel, 2048);
        this.spnMinValue.setMinimum(0);
        this.spnMinValue.setMaximum(100);
        this.spnMinValue.addSelectionListener((SelectionListener)this);
        object2 = new Label((Composite)this.threshPanel, 0);
        object2.setText("Max threshold");
        this.spnMaxValue = new Spinner((Composite)this.threshPanel, 2048);
        this.spnMaxValue.setMinimum(0);
        this.spnMaxValue.setMaximum(100);
        this.spnMaxValue.addSelectionListener((SelectionListener)this);
        this.threshPanel.setVisible(false);
        ((GridData)this.threshPanel.getLayoutData()).exclude = true;
        this.rangePanel = new Group(this.container, 0);
        this.rangePanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rangePanel.setLayout((Layout)new GridLayout(3, false));
        this.rangePanel.setText("Histogram range");
        object = new Label((Composite)this.rangePanel, 0);
        object.setText("Minimum");
        this.spnRangeStart = new FloatSpinner((Composite)this.rangePanel, 2048);
        object2 = new GridData(0, 0, true, false);
        this.spnRangeStart.setLayoutData(object2);
        this.spnRangeStart.addSelectionListener(this);
        this.sldMinValue = new Slider((Composite)this.rangePanel, 2048);
        object2 = new GridData(4, 0, true, false);
        object2.minimumWidth = 90;
        this.sldMinValue.setLayoutData(object2);
        this.sldMinValue.addSelectionListener((SelectionListener)this);
        this.sldMinValue.setMinimum(0);
        this.sldMinValue.setMaximum(1000);
        this.sldMinValue.setIncrement(1);
        label2 = new Label((Composite)this.rangePanel, 0);
        label2.setText("Maximum");
        object2 = new GridData(0, 0, true, false);
        this.spnRangeStop = new FloatSpinner((Composite)this.rangePanel, 2048);
        this.spnRangeStop.setLayoutData(object2);
        this.spnRangeStop.addSelectionListener(this);
        this.spnRangeStart.setEnabled(false);
        this.spnRangeStop.setEnabled(false);
        this.sldMaxValue = new Slider((Composite)this.rangePanel, 2048);
        object2 = new GridData(4, 0, true, false);
        object2.minimumWidth = 90;
        this.sldMaxValue.setLayoutData(object2);
        this.sldMaxValue.addSelectionListener((SelectionListener)this);
        this.sldMaxValue.setMinimum(0);
        this.sldMaxValue.setMaximum(1000);
        this.sldMaxValue.setIncrement(1);
        this.spnRangeStart.setEnabled(false);
        this.spnRangeStop.setEnabled(false);
        this.sldMinValue.setEnabled(false);
        this.sldMaxValue.setEnabled(false);
        this.composite = new Composite(this.container, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.setLayout((Layout)new FillLayout());
        this.histogramPlotter = new DataSetPlotter(PlottingMode.BARCHART, this.composite, false);
        this.histogramPlotter.setXAxisLabel("Intensity Value");
        this.histogramPlotter.setYAxisLabel("Count");
        this.histogramPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.histogramPlotter.setXTickLabelFormat(TickFormatting.plainMode);
        this.histogramPlotter.setXAxisValues(this.xAxis, 1);
        object = this.histogramPlotter.getColourTable();
        object2 = new Plot1DAppearance(Color.RED, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend((Plot1DAppearance)object2);
        object2 = new Plot1DAppearance(Color.GREEN, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend((Plot1DAppearance)object2);
        object2 = new Plot1DAppearance(Color.BLUE, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend((Plot1DAppearance)object2);
        object2 = new Plot1DAppearance(Color.ORANGE, Plot1DStyles.SOLID, "");
        ((Plot1DGraphTable)object).addEntryOnLegend((Plot1DAppearance)object2);
        this.cmbColourMap.addSelectionListener((SelectionListener)this);
        this.cmbRedColour.addSelectionListener((SelectionListener)this);
        this.cmbGreenColour.addSelectionListener((SelectionListener)this);
        this.cmbBlueColour.addSelectionListener((SelectionListener)this);
        this.cmbAlpha.addSelectionListener((SelectionListener)this);
        this.buildToolbar();
        GlobalColourMaps.InitializeColourMaps();
        this.fillupColourComboBoxes();
        this.fillupColourMapBox();
        this.buildGradientImage();
    }

    public void clearColourMapBox() {
        this.cmbColourMap.removeAll();
    }

    private void fillupColourMapBox() {
        int n = 0;
        while (n < GlobalColourMaps.colourMapNames.length) {
            this.cmbColourMap.add(GlobalColourMaps.colourMapNames[n]);
            ++n;
        }
        if (colourSettings.get(this.getPartName()) == null) {
            this.cmbColourMap.select(this.getPreferenceColourMapChoice());
        } else {
            this.cmbColourMap.select(colourSettings.get(this.getPartName()).intValue());
        }
        if (this.cmbColourMap.getItem(this.cmbColourMap.getSelectionIndex()).equals("Mark's special")) {
            this.spnMinValue.setSelection((int)(this.specialMinThreshold * 100.0));
            this.spnMaxValue.setSelection((int)(this.specialMaxThreshold * 100.0));
            this.threshPanel.setVisible(true);
            ((GridData)this.threshPanel.getLayoutData()).exclude = false;
            this.container.layout();
        }
        this.cmbAlpha.select(2);
        this.curAlphaSelect = 2;
        this.buildSelection();
    }

    protected void buildSelection() {
        int n = this.cmbColourMap.getSelectionIndex();
        int n2 = GlobalColourMaps.colourSelectList.get(n * 4);
        int n3 = GlobalColourMaps.colourSelectList.get(n * 4 + 1);
        int n4 = GlobalColourMaps.colourSelectList.get(n * 4 + 2);
        int n5 = GlobalColourMaps.colourSelectList.get(n * 4 + 3);
        this.cmbRedColour.select(Math.abs(n2));
        this.cmbGreenColour.select(Math.abs(n3));
        this.cmbBlueColour.select(Math.abs(n4));
        this.curAlphaSelect = this.cmbAlpha.getSelectionIndex();
        this.curRedSelect = this.cmbRedColour.getSelectionIndex();
        this.curGreenSelect = this.cmbGreenColour.getSelectionIndex();
        this.curBlueSelect = this.cmbBlueColour.getSelectionIndex();
        if (n2 < 0) {
            this.btnRedInverse.setSelection(true);
        } else {
            this.btnRedInverse.setSelection(false);
        }
        if (n3 < 0) {
            this.btnGreenInverse.setSelection(true);
        } else {
            this.btnGreenInverse.setSelection(false);
        }
        if (n4 < 0) {
            this.btnBlueInverse.setSelection(true);
        } else {
            this.btnBlueInverse.setSelection(false);
        }
        if (n5 < 0) {
            this.btnAlphaInverse.setSelection(false);
        }
        this.curAlphaInverse = this.btnAlphaInverse.getSelection();
        this.curRedInverse = this.btnRedInverse.getSelection();
        this.curGreenInverse = this.btnGreenInverse.getSelection();
        this.curBlueInverse = this.btnBlueInverse.getSelection();
    }

    protected void fillupColourComboBoxes() {
        int n = 0;
        while (n < GlobalColourMaps.mappingFunctions.size()) {
            String string = GlobalColourMaps.mappingFunctions.get(n).getMapFunctionName();
            this.cmbRedColour.add(string);
            this.cmbGreenColour.add(string);
            this.cmbBlueColour.add(string);
            this.cmbAlpha.add(string);
            ++n;
        }
    }

    protected void buildGradientImage() {
        GlobalColourMaps.mappingFunctions.get(0);
        AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.cmbRedColour.getSelectionIndex());
        AbstractMapFunction abstractMapFunction2 = GlobalColourMaps.mappingFunctions.get(this.cmbGreenColour.getSelectionIndex());
        AbstractMapFunction abstractMapFunction3 = GlobalColourMaps.mappingFunctions.get(this.cmbBlueColour.getSelectionIndex());
        AbstractMapFunction abstractMapFunction4 = GlobalColourMaps.mappingFunctions.get(this.cmbAlpha.getSelectionIndex());
        boolean bl = this.btnRedInverse.getSelection();
        boolean bl2 = this.btnGreenInverse.getSelection();
        boolean bl3 = this.btnBlueInverse.getSelection();
        boolean bl4 = this.btnAlphaInverse.getSelection();
        this.histogramPlotter.applyColourCast(abstractMapFunction, abstractMapFunction2, abstractMapFunction3, abstractMapFunction4, bl, bl2, bl3, bl4, 0.0, 256.0);
        this.histogramPlotter.refresh(false);
    }

    private void notifyObservers(HistogramUpdate histogramUpdate) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, (Object)histogramUpdate);
        }
    }

    public void setFocus() {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    protected boolean hasData() {
        return this.data != null;
    }

    protected void handleChange(int n) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.cmbRedColour) || selectionEvent.getSource().equals(this.cmbGreenColour) || selectionEvent.getSource().equals(this.cmbBlueColour) || selectionEvent.getSource().equals(this.cmbAlpha) || selectionEvent.getSource().equals(this.btnRedInverse) || selectionEvent.getSource().equals(this.btnGreenInverse) || selectionEvent.getSource().equals(this.btnBlueInverse) || selectionEvent.getSource().equals(this.btnAlphaInverse)) {
            this.curAlphaSelect = this.cmbAlpha.getSelectionIndex();
            this.curRedSelect = this.cmbRedColour.getSelectionIndex();
            this.curGreenSelect = this.cmbGreenColour.getSelectionIndex();
            this.curBlueSelect = this.cmbBlueColour.getSelectionIndex();
            this.curAlphaInverse = this.btnAlphaInverse.getSelection();
            this.curRedInverse = this.btnRedInverse.getSelection();
            this.curGreenInverse = this.btnGreenInverse.getSelection();
            this.curBlueInverse = this.btnBlueInverse.getSelection();
            if (this.hasData()) {
                if (selectionEvent.getSource().equals(this.cmbRedColour)) {
                    this.handleChange(0);
                } else if (selectionEvent.getSource().equals(this.cmbGreenColour)) {
                    this.handleChange(1);
                } else if (selectionEvent.getSource().equals(this.cmbBlueColour)) {
                    this.handleChange(2);
                } else if (selectionEvent.getSource().equals(this.cmbAlpha)) {
                    this.handleChange(3);
                }
                this.updateChannelGraphs();
                this.generateHistogramUpdate();
            }
            if (selectionEvent.getSource().equals(this.cmbGreenColour) || selectionEvent.getSource().equals(this.cmbRedColour) || selectionEvent.getSource().equals(this.btnRedInverse) || selectionEvent.getSource().equals(this.btnGreenInverse) || selectionEvent.getSource().equals(this.btnBlueInverse) || selectionEvent.getSource().equals(this.btnAlphaInverse)) {
                this.histogramPlotter.refresh(true);
            }
            this.buildGradientImage();
        } else if (selectionEvent.getSource().equals(this.cmbColourMap)) {
            colourSettings.put(this.getPartName(), this.cmbColourMap.getSelectionIndex());
            this.buildSelection();
            this.handleChange(0);
            this.handleChange(1);
            this.handleChange(2);
            if (this.hasData()) {
                this.updateChannelGraphs();
                this.generateHistogramUpdate();
            }
            this.histogramPlotter.refresh(true);
            this.buildGradientImage();
            if (this.cmbColourMap.getItem(this.cmbColourMap.getSelectionIndex()).equals("Mark's special")) {
                this.spnMinValue.setSelection((int)(this.specialMinThreshold * 100.0));
                this.spnMaxValue.setSelection((int)(this.specialMaxThreshold * 100.0));
                this.threshPanel.setVisible(true);
                ((GridData)this.threshPanel.getLayoutData()).exclude = false;
            } else {
                this.threshPanel.setVisible(false);
                ((GridData)this.threshPanel.getLayoutData()).exclude = true;
            }
            this.container.layout();
        } else if (selectionEvent.getSource().equals(this.spnMinValue) || selectionEvent.getSource().equals(this.spnMaxValue)) {
            SpecialExposureFunction specialExposureFunction = (SpecialExposureFunction)GlobalColourMaps.mappingFunctions.get(this.cmbRedColour.getSelectionIndex());
            SpecialExposureFunction specialExposureFunction2 = (SpecialExposureFunction)GlobalColourMaps.mappingFunctions.get(this.cmbGreenColour.getSelectionIndex());
            SpecialExposureFunction specialExposureFunction3 = (SpecialExposureFunction)GlobalColourMaps.mappingFunctions.get(this.cmbBlueColour.getSelectionIndex());
            specialExposureFunction.setThresholds((double)this.spnMinValue.getSelection() / 100.0, (double)this.spnMaxValue.getSelection() / 100.0);
            specialExposureFunction2.setThresholds((double)this.spnMinValue.getSelection() / 100.0, (double)this.spnMaxValue.getSelection() / 100.0);
            specialExposureFunction3.setThresholds((double)this.spnMinValue.getSelection() / 100.0, (double)this.spnMaxValue.getSelection() / 100.0);
            this.specialMaxThreshold = (double)this.spnMaxValue.getSelection() / 100.0;
            this.specialMinThreshold = (double)this.spnMinValue.getSelection() / 100.0;
            this.updateChannelGraphs();
            this.generateHistogramUpdate();
            this.histogramPlotter.refresh(true);
        } else if (selectionEvent.getSource().equals(this.spnRangeStart.getControl()) || selectionEvent.getSource().equals(this.spnRangeStop.getControl())) {
            double d = this.spnRangeStart.getDouble();
            double d2 = this.spnRangeStop.getDouble();
            this.updateHistogramGraph(d, d2);
        } else if (selectionEvent.getSource().equals(this.sldMinValue) || selectionEvent.getSource().equals(this.sldMaxValue)) {
            double d = this.spnRangeStart.getMinimum() + this.spnRangeStart.getRange() * ((double)this.sldMinValue.getSelection() / (double)this.sldMinValue.getMaximum());
            double d3 = this.spnRangeStart.getMinimum() + this.spnRangeStart.getRange() * ((double)this.sldMaxValue.getSelection() / (double)this.sldMaxValue.getMaximum());
            this.spnRangeStart.setDouble(d);
            this.spnRangeStop.setDouble(d3);
            if (this.hasData()) {
                this.updateHistogramGraph(d, d3);
            }
        } else if (selectionEvent.getSource().equals(this.btnExpertMode)) {
            this.expertGroup.setVisible(this.btnExpertMode.getSelection());
            ((GridData)this.expertGroup.getLayoutData()).exclude = !this.btnExpertMode.getSelection();
            this.container.layout();
        }
    }

    protected void generateHistogramUpdate() {
        HistogramUpdate histogramUpdate = new HistogramUpdate(GlobalColourMaps.mappingFunctions.get(this.curRedSelect), GlobalColourMaps.mappingFunctions.get(this.curGreenSelect), GlobalColourMaps.mappingFunctions.get(this.curBlueSelect), GlobalColourMaps.mappingFunctions.get(this.curAlphaSelect), this.btnRedInverse.getSelection(), this.btnGreenInverse.getSelection(), this.btnBlueInverse.getSelection(), this.btnAlphaInverse.getSelection(), this.currentMaxMin.min, this.currentMaxMin.max);
        this.notifyObservers(histogramUpdate);
    }

    protected void updateChannelGraphs() {
        if (this.histograms != null && this.histograms.size() > 1) {
            this.histograms.remove(0);
            this.histograms.remove(0);
            this.histograms.remove(0);
            this.histograms.remove(0);
        }
        AbstractMapFunction abstractMapFunction = GlobalColourMaps.mappingFunctions.get(this.curRedSelect);
        AbstractMapFunction abstractMapFunction2 = GlobalColourMaps.mappingFunctions.get(this.curGreenSelect);
        AbstractMapFunction abstractMapFunction3 = GlobalColourMaps.mappingFunctions.get(this.curBlueSelect);
        AbstractMapFunction abstractMapFunction4 = GlobalColourMaps.mappingFunctions.get(this.curAlphaSelect);
        double d = this.histograms.get(0).max().doubleValue();
        int n = this.histograms.get(0).getSize();
        DoubleDataset doubleDataset = new DoubleDataset(new int[]{n});
        DoubleDataset doubleDataset2 = new DoubleDataset(new int[]{n});
        DoubleDataset doubleDataset3 = new DoubleDataset(new int[]{n});
        DoubleDataset doubleDataset4 = new DoubleDataset(new int[]{n});
        int n2 = 0;
        while (n2 < n) {
            double d2 = (double)n2 / (double)n;
            double d3 = abstractMapFunction.clippedMapToDouble(d2);
            if (this.curRedInverse) {
                d3 = 1.0 - d3;
            }
            d3 *= d;
            double d4 = abstractMapFunction2.clippedMapToDouble(d2);
            if (this.curGreenInverse) {
                d4 = 1.0 - d4;
            }
            d4 *= d;
            double d5 = abstractMapFunction3.clippedMapToDouble(d2);
            if (this.curBlueInverse) {
                d5 = 1.0 - d5;
            }
            d5 *= d;
            double d6 = abstractMapFunction4.clippedMapToDouble(d2);
            if (this.curAlphaInverse) {
                d6 = 1.0 - d6;
            }
            doubleDataset.set((Object)Math.max(d3, 0.0), new int[]{n2});
            doubleDataset2.set((Object)Math.max(d4, 0.0), new int[]{n2});
            doubleDataset3.set((Object)Math.max(d5, 0.0), new int[]{n2});
            doubleDataset4.set((Object)Math.max(d6 *= d, 0.0), new int[]{n2++});
        }
        this.histograms.add(0, (AbstractDataset)doubleDataset4);
        this.histograms.add(0, (AbstractDataset)doubleDataset3);
        this.histograms.add(0, (AbstractDataset)doubleDataset2);
        this.histograms.add(0, (AbstractDataset)doubleDataset);
        try {
            this.histogramPlotter.replaceAllPlots(this.histograms);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
    }

    private void updateHistogramGraph(double d, double d2) {
        this.xAxis.clear();
        this.currentMaxMin.max = d2;
        this.currentMaxMin.min = d;
        this.histogramFunc.setMinMax(d, d2);
        this.histogramFunc.setIgnoreOutliers(true);
        List list = this.histogramFunc.value(new IDataset[]{this.data});
        AbstractDataset abstractDataset = (AbstractDataset)list.get(0);
        if (this.histograms != null && this.histograms.size() > 1) {
            this.histograms.set(this.histograms.size() - 1, abstractDataset);
        } else {
            this.histograms = new ArrayList<AbstractDataset>();
            this.histograms.add(abstractDataset);
        }
        this.xAxis.setValues(DatasetUtils.linSpace((double)d, (double)d2, (int)Math.max(1, abstractDataset.getSize() + 1), (int)6));
        this.histogramPlotter.setXAxisValues(this.xAxis, 1);
        this.generateHistogramUpdate();
        this.updateChannelGraphs();
        this.histogramPlotter.refresh(true);
    }

    private void autoRangeHistogram() {
        double[] dArray;
        block6: {
            this.histogramPlotter.clearZoomHistory();
            if (this.autoContrast && this.data.getRank() == 2) {
                try {
                    int[] nArray = this.data.getShape();
                    if (nArray[0] > 512 && nArray[1] > 512) {
                        int n = (int)Math.ceil((double)nArray[0] / 512.0);
                        int n2 = (int)Math.ceil((double)nArray[1] / 512.0);
                        Downsample downsample = new Downsample(DownsampleMode.MAXIMUM, new int[]{n2, n});
                        dArray = Stats.quantile((AbstractDataset)((AbstractDataset)downsample.value(new IDataset[]{this.data}).get(0)), (double[])new double[]{this.getPreferenceAutoContrastLo(), this.getPreferenceAutoContrastHi()});
                        break block6;
                    }
                    dArray = Stats.quantile((AbstractDataset)this.data, (double[])new double[]{this.getPreferenceAutoContrastLo(), this.getPreferenceAutoContrastHi()});
                }
                catch (Exception exception) {
                    dArray = new double[]{this.data.min().doubleValue(), this.data.max().doubleValue()};
                }
            } else {
                dArray = new double[]{this.data.min().doubleValue(), this.data.max().doubleValue()};
            }
        }
        if (Double.compare(dArray[1], dArray[0]) <= 0) {
            dArray[1] = dArray[0] + 0.01;
        }
        this.currentMaxMin.max = dArray[1];
        this.currentMaxMin.min = dArray[0];
    }

    public void createInitialHistogram() {
        if (!this.hasData()) {
            return;
        }
        MaxMin maxMin = this.currentMaxMin;
        this.currentMaxMin = this.cachedMaxMin.get(this.data.hashCode());
        if (this.currentMaxMin == null) {
            this.currentMaxMin = new MaxMin();
            this.cachedMaxMin.put(this.data.hashCode(), this.currentMaxMin);
        }
        if (this.lockRange && maxMin != null) {
            this.currentMaxMin.max = maxMin.max;
            this.currentMaxMin.min = maxMin.min;
        } else if (this.autoContrast || Double.isNaN(this.currentMaxMin.max) || Double.isNaN(this.currentMaxMin.min)) {
            this.autoRangeHistogram();
        }
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                double d;
                if (!HistogramView.this.hasData()) {
                    System.err.println("No data available in histogram view!");
                    return;
                }
                double d2 = HistogramView.this.data.max().doubleValue();
                double d3 = d2 - (d = HistogramView.this.data.min().doubleValue());
                if (d3 != 0.0) {
                    int n = (int)Math.ceil(-Math.log10(d3 / 100.0));
                    int n2 = (int)Math.ceil(Math.log10(Math.max(Math.abs(d2), Math.abs(d))));
                    if (n2 <= 0) {
                        n2 = 2;
                    }
                    if (n <= 0) {
                        n = 1;
                    }
                    HistogramView.this.spnRangeStart.setFormat(n + n2, n);
                    HistogramView.this.spnRangeStop.setFormat(n + n2, n);
                }
                HistogramView.this.spnRangeStart.setMaximum(d2);
                HistogramView.this.spnRangeStart.setMinimum(d);
                HistogramView.this.spnRangeStop.setMaximum(d2);
                HistogramView.this.spnRangeStop.setMinimum(d);
                HistogramView.this.spnRangeStop.setDouble(((HistogramView)HistogramView.this).currentMaxMin.max);
                HistogramView.this.spnRangeStart.setDouble(((HistogramView)HistogramView.this).currentMaxMin.min);
                double d4 = (((HistogramView)HistogramView.this).currentMaxMin.min - d) / d3;
                HistogramView.this.sldMinValue.setSelection((int)Math.floor((double)HistogramView.this.sldMinValue.getMaximum() * d4));
                double d5 = (((HistogramView)HistogramView.this).currentMaxMin.max - d) / d3;
                HistogramView.this.sldMaxValue.setSelection((int)Math.floor((double)HistogramView.this.sldMinValue.getMaximum() * d5));
                HistogramView.this.spnRangeStart.setEnabled(true);
                HistogramView.this.spnRangeStop.setEnabled(true);
                HistogramView.this.sldMinValue.setEnabled(true);
                HistogramView.this.sldMaxValue.setEnabled(true);
                HistogramView.this.updateHistogramGraph(((HistogramView)HistogramView.this).currentMaxMin.min, ((HistogramView)HistogramView.this).currentMaxMin.max);
                HistogramView.this.buildGradientImage();
            }
        });
    }

    public void update(Object object, Object object2) {
        if (object.equals(this.histogramUI) && object2 instanceof AreaSelectEvent) {
            AreaSelectEvent areaSelectEvent = (AreaSelectEvent)object2;
            final double d = areaSelectEvent.getPosition()[0];
            final double d2 = areaSelectEvent.getPosition()[1];
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistogramView.this.updateHistogramGraph(d, d2);
                }
            });
        }
        if (object instanceof PlotWindow && object2 instanceof HistogramDataUpdate && this.parent != null) {
            this.data = ((HistogramDataUpdate)object2).getDataset();
            this.createInitialHistogram();
        }
    }

    public void setData(HistogramDataUpdate histogramDataUpdate) {
        this.data = histogramDataUpdate.getDataset();
        this.createInitialHistogram();
    }

    public String getId() {
        return this.id;
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    public void dispose() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        String string = this.getPartName();
        Integer n = colourSettings.get(string);
        if (n != null) {
            iPreferenceStore.setValue(String.valueOf(string) + "." + "plotView.plot2DcolourMap", n.intValue());
        }
        iPreferenceStore.setValue(String.valueOf(string) + "." + "plotView.plot2Dscaling", this.useLog ? 1 : 0);
        this.deleteIObservers();
        if (this.histogramPlotter != null) {
            this.histogramPlotter.cleanUp();
        }
        this.data = null;
        if (this.histogramUI != null) {
            this.histogramUI.deactivate(false);
            this.histogramUI.dispose();
        }
        if (!this.cmbAlpha.isDisposed()) {
            this.cmbAlpha.removeSelectionListener((SelectionListener)this);
        }
        if (!this.cmbRedColour.isDisposed()) {
            this.cmbRedColour.removeSelectionListener((SelectionListener)this);
        }
        if (!this.cmbGreenColour.isDisposed()) {
            this.cmbGreenColour.removeSelectionListener((SelectionListener)this);
        }
        if (!this.cmbBlueColour.isDisposed()) {
            this.cmbBlueColour.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnGreenInverse.isDisposed()) {
            this.btnGreenInverse.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnBlueInverse.isDisposed()) {
            this.btnBlueInverse.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnAlphaInverse.isDisposed()) {
            this.btnAlphaInverse.removeSelectionListener((SelectionListener)this);
        }
        if (!this.btnRedInverse.isDisposed()) {
            this.btnRedInverse.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }

    public void setAutoContrastScaling(boolean bl) {
        this.autoContrast = bl;
        if (this.hasData()) {
            this.spnRangeStart.setEnabled(!bl);
            this.spnRangeStop.setEnabled(!bl);
        }
        this.rangePanel.setEnabled(!bl);
    }

    public void setHistogramLock(boolean bl) {
        this.lockRange = bl;
    }

    public void setGraphLines(boolean bl) {
        if (this.histogramPlotter != null) {
            Plot1DGraphTable plot1DGraphTable = this.histogramPlotter.getColourTable();
            int n = 0;
            while (n < 4) {
                plot1DGraphTable.getLegendEntry(n).setVisible(bl);
                ++n;
            }
        }
        this.histogramPlotter.updateAllAppearance();
        this.histogramPlotter.refresh(false);
    }

    public void setScaling(ScaleType scaleType) {
        this.useLog = scaleType != ScaleType.LINEAR;
        this.histogramPlotter.setYAxisScaling(scaleType);
    }

    private int getPreferenceColourMapChoice() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        int n = iPreferenceStore.getInt(String.valueOf(this.getPartName()) + "." + "plotView.plot2DcolourMap");
        if (n != 0) {
            return n;
        }
        return iPreferenceStore.isDefault("plotView.plot2DcolourMap") ? iPreferenceStore.getDefaultInt("plotView.plot2DcolourMap") : iPreferenceStore.getInt("plotView.plot2DcolourMap");
    }

    private boolean getPreferenceColourMapExpertMode() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        if (iPreferenceStore.getBoolean(String.valueOf(this.getPartName()) + "." + "plotView.plot2DcmapExpert")) {
            return true;
        }
        return iPreferenceStore.isDefault("plotView.plot2DcmapExpert") ? iPreferenceStore.getDefaultBoolean("plotView.plot2DcmapExpert") : iPreferenceStore.getBoolean("plotView.plot2DcmapExpert");
    }

    private double getPreferenceAutoContrastLo() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        int n = iPreferenceStore.isDefault("plotView.autoContrastLoThreshold") ? iPreferenceStore.getDefaultInt("plotView.autoContrastLoThreshold") : iPreferenceStore.getInt("plotView.autoContrastLoThreshold");
        return (double)n / 100.0;
    }

    private double getPreferenceAutoContrastHi() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        int n = iPreferenceStore.isDefault("plotView.autoContrastHiThreshold") ? iPreferenceStore.getDefaultInt("plotView.autoContrastHiThreshold") : iPreferenceStore.getInt("plotView.autoContrastHiThreshold");
        return (double)n / 100.0;
    }

    class MaxMin {
        public double max = Double.NaN;
        public double min = Double.NaN;

        MaxMin() {
        }
    }
}

