/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.analysis.io.ScanFileHolderException;
import gda.observable.IObserver;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5Selection;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5TreeExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetSelection;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class HDF5TreeView
extends ViewPart
implements IObserver {
    HDF5TreeExplorer hdfxp;
    Display display;
    FileDialog fileDialog = null;
    private PlotServer plotServer;
    private GuiBean guiBean;
    private static final String NAME = "hdf5TreeViewer";
    private UUID plotID = UUID.randomUUID();
    private Object filename;
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.HDF5TreeView";
    private static final Logger logger = LoggerFactory.getLogger(HDF5TreeView.class);

    public HDF5TreeView() {
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotServer.addIObserver((IObserver)this);
        this.guiBean = new GuiBean();
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotID);
        try {
            this.plotServer.updateGui(NAME, this.guiBean);
        }
        catch (Exception exception) {
            logger.error("Problem pushing initial GUI bean to plot server");
            exception.printStackTrace();
        }
    }

    public void createPartControl(Composite composite) {
        this.display = composite.getDisplay();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        this.hdfxp = new HDF5TreeExplorer(composite, iWorkbenchPartSite, null);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.hdfxp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.hdfxp, "uk.ac.diamond.scisoft.analysis.rcp.hdf5View");
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.getTreeFromServer();
        this.hdfxp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection;
                if (selectionChangedEvent.getSource() == HDF5TreeView.this.hdfxp && (iSelection = selectionChangedEvent.getSelection()) instanceof HDF5Selection) {
                    HDF5Selection hDF5Selection = (HDF5Selection)iSelection;
                    HDF5TreeView.this.pushGUIUpdate(GuiParameters.TREENODEPATH, (Serializable)((Object)(String.valueOf(hDF5Selection.getFileName()) + "#" + hDF5Selection.getNode())));
                }
            }
        });
    }

    public void loadTree(final String string) {
        IProgressService iProgressService = (IProgressService)this.getSite().getService(IProgressService.class);
        try {
            iProgressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            HDF5TreeView.this.loadTree(string, iProgressMonitor);
                        }
                        catch (ScanFileHolderException scanFileHolderException) {
                            logger.error("Could not load HDF5 file: {}", (Throwable)scanFileHolderException);
                            iProgressMonitor.done();
                        }
                        catch (Exception exception) {
                            logger.error("Problem with loader: is the library path set correctly?", (Throwable)exception);
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Could not open HDF5 file", (Throwable)exception);
        }
    }

    private void loadTree(final String string, IProgressMonitor iProgressMonitor) throws Exception {
        iProgressMonitor.beginTask("Opening HDF5 file " + string, 10);
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        long l = System.nanoTime();
        this.hdfxp.loadFileAndDisplay(string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        if (this.hdfxp.getHDF5Tree() != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    HDF5TreeView.this.setPartName(new File(string).getName());
                }
            });
        }
        logger.info("Setting tree took {}s", (Object)((double)(System.nanoTime() - l) * 1.0E-9));
    }

    public void loadTreeUsingFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getSite().getShell(), 4096);
        }
        String[] stringArray = new String[]{"HDF5 files", "All Files (*)"};
        String[] stringArray2 = new String[]{"*.nxs;*.h5;*.hdf5", "*"};
        this.fileDialog.setFilterNames(stringArray);
        this.fileDialog.setFilterExtensions(stringArray2);
        String string = this.fileDialog.open();
        if (string != null) {
            this.loadTree(string);
        }
    }

    public void setFocus() {
        this.hdfxp.setFocus();
    }

    public void dispose() {
        this.plotServer.deleteIObserver((IObserver)this);
        super.dispose();
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void expandAll() {
        this.hdfxp.expandAll();
    }

    public void update(Object object, Object object2) {
        String string;
        if (object2 instanceof GuiUpdate) {
            GuiUpdate guiUpdate = (GuiUpdate)object2;
            if (guiUpdate.getGuiName().contains(NAME)) {
                this.guiBean = guiUpdate.getGuiData();
                this.syncGuiToBean();
                GuiBean guiBean = guiUpdate.getGuiData();
                UUID uUID = (UUID)guiBean.get((Object)GuiParameters.PLOTID);
                if (uUID == null || this.plotID.compareTo(uUID) != 0) {
                    if (this.guiBean == null) {
                        this.guiBean = guiBean.copy();
                    } else {
                        this.guiBean.merge(guiBean);
                    }
                    logger.debug("Processing update received from {}: {}", object, object2);
                    this.processGUIUpdate(guiBean);
                }
            }
        } else if (object2 instanceof String && (string = (String)object2).equals(NAME)) {
            this.getTreeFromServer();
        }
    }

    public void pushGUIUpdate(GuiParameters guiParameters, Serializable serializable) {
        if (this.guiBean == null) {
            try {
                this.guiBean = this.plotServer.getGuiState(NAME);
            }
            catch (Exception exception) {
                logger.error("Problem with getting GUI data from plot server");
            }
            if (this.guiBean == null) {
                this.guiBean = new GuiBean();
            }
        }
        this.guiBean.put(GuiParameters.PLOTID, (Serializable)this.plotID);
        this.guiBean.put(guiParameters, serializable);
        try {
            this.plotServer.updateGui(NAME, this.guiBean);
        }
        catch (Exception exception) {
            logger.error("Problem with updating plot server with GUI data");
            exception.printStackTrace();
        }
    }

    private void getTreeFromServer() {
        try {
            logger.debug("Pulling data to client");
            long l = System.nanoTime();
            DataBean dataBean = this.plotServer.getData(NAME);
            l = System.nanoTime() - l;
            logger.debug("Data pushed to client: {} in {} s", (Object)dataBean, (Object)String.format("%.3g", (double)l * 1.0E-9));
            this.syncTreeToBean(dataBean);
        }
        catch (Exception exception) {
            logger.error("Problem pushing data to plot server");
            exception.printStackTrace();
        }
    }

    private void syncGuiToBean() {
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    HDF5TreeView.this.display.update();
                }
            });
        }
    }

    private void syncTreeToBean(DataBean dataBean) {
        if (dataBean == null) {
            logger.warn("Plot server has no info for NTV");
            return;
        }
        List list = dataBean.getHDF5Trees();
        if (list == null) {
            logger.warn("Plot server did not push a list of trees");
            return;
        }
        if (list.size() == 0) {
            logger.warn("Plot server pushed an empty list of trees");
            return;
        }
        this.hdfxp.setHDF5Tree((HDF5File)list.get(0));
    }

    private void processGUIUpdate(GuiBean guiBean) {
        String string;
        String string2;
        int n;
        if (guiBean.containsKey((Object)GuiParameters.TREENODEPATH) && (n = (string2 = (String)((Object)guiBean.get((Object)GuiParameters.TREENODEPATH))).indexOf("#")) > 0 && this.filename.equals(string = string2.substring(0, n))) {
            String string3 = string2.substring(n + 1);
            this.hdfxp.selectHDF5Node(string3, DatasetSelection.InspectorType.LINE);
        }
    }
}

