/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import java.io.PrintStream;
import java.util.Set;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import uk.ac.diamond.scisoft.analysis.rcp.views.DatasetGridLayerStack;
import uk.ac.diamond.scisoft.analysis.rcp.views.ExportSelectionCommand;

class ExportSelectionCommandHandler
extends AbstractLayerCommandHandler<ExportSelectionCommand> {
    private SelectionLayer selLayer;
    private ILayer colLayer;
    private ILayer rowLayer;
    private DatasetGridLayerStack dataLayer;
    private IDataProvider dataProvider;

    public ExportSelectionCommandHandler(DatasetGridLayerStack datasetGridLayerStack, SelectionLayer selectionLayer) {
        this.selLayer = selectionLayer;
        this.dataLayer = datasetGridLayerStack;
        this.dataProvider = datasetGridLayerStack.getDataProvider();
        this.colLayer = datasetGridLayerStack.getColumnHeaderLayer();
        this.rowLayer = datasetGridLayerStack.getRowHeaderLayer();
    }

    protected boolean doCommand(ExportSelectionCommand exportSelectionCommand) {
        FileDialog fileDialog = new FileDialog(exportSelectionCommand.getShell(), 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setFileName("table_export.txt");
        fileDialog.setFilterNames(new String[]{"Ascii text - tab-separated (.txt)", "Ascii text - comma-separated (.csv)"});
        fileDialog.setFilterExtensions(new String[]{"*.txt", "*.csv"});
        String string = fileDialog.open();
        if (string == null) {
            return true;
        }
        final String string2 = string.endsWith(".csv") ? ", " : "\t";
        try {
            final PrintStream printStream = new PrintStream(string);
            exportSelectionCommand.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExportSelectionCommandHandler.this.save(printStream, string2, "\n");
                }
            });
        }
        catch (Exception exception) {
            Status status = new Status(4, "uk.ac.diamond.scisoft.analysis.rcp", exception.getMessage(), (Throwable)exception);
            ErrorDialog.openError((Shell)exportSelectionCommand.getShell(), (String)"Data export error", (String)"Error exporting data table", (IStatus)status);
            return false;
        }
        return true;
    }

    public void save(PrintStream printStream, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.assembleHeaders(stringBuilder, string, this.selLayer.getSelectedColumns());
        stringBuilder.append(string2);
        Set set = this.selLayer.getSelectedRows();
        for (Range range : set) {
            int n = range.start;
            while (n < range.end) {
                if (this.assembleBody(stringBuilder, string, n)) {
                    stringBuilder.append(string2);
                }
                ++n;
            }
        }
        printStream.append(stringBuilder);
        printStream.close();
    }

    public Class<ExportSelectionCommand> getCommandClass() {
        return ExportSelectionCommand.class;
    }

    protected void assembleHeaders(StringBuilder stringBuilder, String string, int ... nArray) {
        stringBuilder.append(this.colLayer.getDataValueByPosition(0, 0));
        if (this.dataLayer.isColHeadersCustom()) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                if (n3 != 0 || !this.dataLayer.isRowHeadersCustom()) {
                    stringBuilder.append(string);
                    stringBuilder.append(this.dataProvider.getDataValue(n3, 0));
                }
                ++n2;
            }
        } else {
            int[] nArray3 = nArray;
            int n = nArray.length;
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray3[n4];
                if (n5 != 0 || !this.dataLayer.isRowHeadersCustom()) {
                    stringBuilder.append(string);
                    stringBuilder.append(this.colLayer.getDataValueByPosition(n5, 0));
                }
                ++n4;
            }
        }
    }

    protected boolean assembleBody(StringBuilder stringBuilder, String string, int n) {
        int[] nArray = this.selLayer.getSelectedColumns();
        if (n == 0 && this.dataLayer.isColHeadersCustom()) {
            return false;
        }
        if (this.dataLayer.isRowHeadersCustom()) {
            stringBuilder.append(this.dataProvider.getDataValue(0, n));
        } else {
            stringBuilder.append(this.rowLayer.getDataValueByPosition(0, n));
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (this.selLayer.isCellPositionSelected(n4, n) && (n4 != 0 || !this.dataLayer.isRowHeadersCustom())) {
                stringBuilder.append(string);
                stringBuilder.append(this.selLayer.getDataValueByPosition(n4, n));
            }
            ++n3;
        }
        return true;
    }
}

