/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.config.DefaultNatTableStyleConfiguration;
import net.sourceforge.nattable.config.IConfiguration;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.export.excel.command.ExportToExcelCommand;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.print.command.TurnViewportOffCommand;
import net.sourceforge.nattable.print.command.TurnViewportOnCommand;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.ClearAllSelectionsCommand;
import net.sourceforge.nattable.selection.command.SelectAllCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.views.DatasetGridLayerStack;
import uk.ac.diamond.scisoft.analysis.rcp.views.ExportSelectionCommand;
import uk.ac.diamond.scisoft.analysis.rcp.views.ExportSelectionCommandHandler;

public class DatasetTableView
extends ViewPart {
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.DatasetTableView";
    private Composite pComp;
    private NatTable table = null;
    private DatasetGridLayerStack dStack = null;

    public void createPartControl(Composite composite) {
        this.pComp = composite;
        composite.setLayout((Layout)new FillLayout());
        this.createToolbar(this.getViewSite().getActionBars());
    }

    public void setFocus() {
    }

    public void setData(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, AbstractDataset abstractDataset3) {
        if (abstractDataset.getRank() != 2) {
            return;
        }
        if (this.table == null) {
            this.dStack = new DatasetGridLayerStack(abstractDataset, abstractDataset2, abstractDataset3);
            SelectionLayer selectionLayer = this.dStack.getSelectionLayer();
            selectionLayer.registerCommandHandler((ILayerCommandHandler)new ExportSelectionCommandHandler(this.dStack, selectionLayer));
            this.table = new NatTable(this.pComp, (ILayer)this.dStack, false);
            this.table.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
            this.table.configure();
            this.pComp.layout();
        } else {
            this.dStack.setData(abstractDataset, abstractDataset2, abstractDataset3);
        }
    }

    private void createToolbar(IActionBars iActionBars) {
        Action action = new Action(){

            public void run() {
                DatasetTableView.this.table.doCommand((ILayerCommand)new SelectAllCommand());
                DatasetTableView.this.table.redraw();
            }
        };
        action.setToolTipText("Select all in table");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/table_add.png"));
        Action action2 = new Action(){

            public void run() {
                DatasetTableView.this.table.doCommand((ILayerCommand)new ClearAllSelectionsCommand());
                DatasetTableView.this.table.redraw();
            }
        };
        action2.setToolTipText("Clear selection");
        action2.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/table_delete.png"));
        Action action3 = new Action(){

            public void run() {
                DatasetTableView.this.table.doCommand((ILayerCommand)new CopyDataToClipboardCommand(new Clipboard(DatasetTableView.this.table.getDisplay()), "\t", "\n"));
            }
        };
        action3.setToolTipText("Copy selection to clipboard");
        action3.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/table_go.png"));
        Action action4 = new Action(){

            public void run() {
                try {
                    DatasetTableView.this.table.doCommand((ILayerCommand)new TurnViewportOffCommand());
                    DatasetTableView.this.table.doCommand((ILayerCommand)new ExportToExcelCommand(DatasetTableView.this.table.getConfigRegistry(), DatasetTableView.this.table.getShell()));
                    DatasetTableView.this.table.doCommand((ILayerCommand)new TurnViewportOnCommand());
                }
                catch (Exception exception) {
                    Status status = new Status(4, "uk.ac.diamond.scisoft.analysis.rcp", exception.getCause().getMessage(), (Throwable)exception);
                    ErrorDialog.openError((Shell)DatasetTableView.this.table.getShell(), (String)"Excel export error", (String)"Error exporting Excel table", (IStatus)status);
                }
            }
        };
        action4.setToolTipText("Export all as Excel");
        action4.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/page_excel.png"));
        Action action5 = new Action(){

            public void run() {
                DatasetTableView.this.table.doCommand((ILayerCommand)new ExportSelectionCommand(DatasetTableView.this.table.getShell()));
            }
        };
        action5.setToolTipText("Export selection");
        action5.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/table_save.png"));
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)action);
        iToolBarManager.add((IAction)action2);
        iToolBarManager.add((IAction)action3);
        iToolBarManager.add((IAction)action4);
        iToolBarManager.add((IAction)action5);
        iActionBars.updateActionBars();
    }
}

