/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.inspector.DatasetInspector;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;

public class DatasetInspectorView
extends ViewPart {
    private DatasetInspector inspector;
    private ImageExplorerView explorer = null;
    protected boolean hidden;
    private PerspectiveAdapter perspectiveListener = null;
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.DatasetInspectorView";
    private static final Logger logger = LoggerFactory.getLogger(DatasetInspectorView.class);

    public void createPartControl(Composite composite) {
        this.inspector = new DatasetInspector(composite, 0, this.getSite());
        if (this.perspectiveListener == null) {
            this.createPerspectiveListener();
        }
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.perspectiveListener);
    }

    private void createPerspectiveListener() {
        this.perspectiveListener = new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                if (iPerspectiveDescriptor.getId().equals("uk.ac.diamond.scisoft.dataexplorationperspective") && DatasetInspectorView.this.getImageExplorer() != null && !DatasetInspectorView.this.explorer.isDisposed()) {
                    DatasetInspectorView.this.explorer.setLocationBarVisible(false);
                }
            }

            public void perspectiveDeactivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                if (iPerspectiveDescriptor.getId().equals("uk.ac.diamond.scisoft.dataexplorationperspective") && DatasetInspectorView.this.getImageExplorer() != null && !DatasetInspectorView.this.explorer.isDisposed()) {
                    DatasetInspectorView.this.explorer.setLocationBarVisible(true);
                }
            }
        };
    }

    public void setFocus() {
        this.inspector.setFocus();
    }

    public void dispose() {
        if (this.perspectiveListener != null) {
            this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.perspectiveListener);
        }
        this.inspector.dispose();
        super.dispose();
    }

    private ImageExplorerView getImageExplorer() {
        if (this.explorer == null) {
            try {
                this.explorer = (ImageExplorerView)this.getSite().getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView", null, 3);
            }
            catch (PartInitException partInitException) {
                logger.error("Cannot find image explorer view");
            }
        }
        return this.explorer;
    }
}

