/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.freeze.CompositeFreezeLayer;
import net.sourceforge.nattable.freeze.FreezeLayer;
import net.sourceforge.nattable.freeze.event.FreezeEvent;
import net.sourceforge.nattable.freeze.event.UnfreezeEvent;
import net.sourceforge.nattable.grid.data.DefaultCornerDataProvider;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.grid.layer.CornerLayer;
import net.sourceforge.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import net.sourceforge.nattable.grid.layer.DefaultGridLayer;
import net.sourceforge.nattable.grid.layer.DefaultRowHeaderDataLayer;
import net.sourceforge.nattable.grid.layer.RowHeaderLayer;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.layer.event.StructuralRefreshEvent;
import net.sourceforge.nattable.layer.stack.DefaultBodyLayerStack;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.viewport.ViewportLayer;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.views.DatasetColumnProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.DatasetContentProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.DatasetRowProvider;

class DatasetGridLayerStack
extends DefaultGridLayer {
    private DatasetContentProvider bodyDataProvider;
    private DatasetColumnProvider columnHeaderDataProvider;
    private DatasetRowProvider rowHeaderDataProvider;
    private SelectionLayer selectionLayer;
    private DefaultBodyLayerStack bodyLayer;
    private FreezeLayer freezeLayer;
    private boolean rowsCustom = false;
    private boolean colsCustom = false;

    public DatasetGridLayerStack(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, AbstractDataset abstractDataset3) {
        super(true);
        if (abstractDataset2 != null && abstractDataset2.getName().startsWith("dim:")) {
            abstractDataset2 = null;
        }
        boolean bl = this.rowsCustom = abstractDataset2 != null;
        if (abstractDataset3 != null && abstractDataset3.getName().startsWith("dim:")) {
            abstractDataset3 = null;
        }
        this.colsCustom = abstractDataset3 != null;
        this.bodyDataProvider = new DatasetContentProvider(abstractDataset, abstractDataset2, abstractDataset3);
        this.rowHeaderDataProvider = new DatasetRowProvider(abstractDataset.getShape()[0], abstractDataset3);
        this.columnHeaderDataProvider = new DatasetColumnProvider(abstractDataset.getShape()[1], abstractDataset2);
        DefaultCornerDataProvider defaultCornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)this.rowHeaderDataProvider);
        this.init(this.bodyDataProvider, this.columnHeaderDataProvider, this.rowHeaderDataProvider, (IDataProvider)defaultCornerDataProvider);
        this.configureFreeze(this.rowsCustom, this.colsCustom);
    }

    public void setData(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, AbstractDataset abstractDataset3) {
        if (abstractDataset2 != null && abstractDataset2.getName().startsWith("dim:")) {
            abstractDataset2 = null;
        }
        boolean bl = this.rowsCustom = abstractDataset2 != null;
        if (abstractDataset3 != null && abstractDataset3.getName().startsWith("dim:")) {
            abstractDataset3 = null;
        }
        this.colsCustom = abstractDataset3 != null;
        this.bodyDataProvider.setData(abstractDataset, abstractDataset2, abstractDataset3);
        int[] nArray = abstractDataset.getShape();
        this.rowHeaderDataProvider.setData(nArray[0], abstractDataset3);
        if (nArray[1] == 1) {
            String string = abstractDataset.getName();
            if (string != null && string.length() > 0) {
                String[] stringArray;
                if (abstractDataset2 != null) {
                    String string2 = abstractDataset2.getName();
                    stringArray = new String[]{string2 == null || string2.length() == 0 ? "x" : string2, string};
                } else {
                    stringArray = new String[]{string};
                }
                this.columnHeaderDataProvider.setData(1, abstractDataset2 != null ? 1 : 0, stringArray);
            } else {
                this.columnHeaderDataProvider.setData(1, abstractDataset2);
            }
        } else {
            this.columnHeaderDataProvider.setData(nArray[1], abstractDataset2);
        }
        this.refresh();
        this.configureFreeze(this.rowsCustom, this.colsCustom);
    }

    protected void init(IDataProvider iDataProvider, IDataProvider iDataProvider2, IDataProvider iDataProvider3, IDataProvider iDataProvider4) {
        this.init((IUniqueIndexLayer)new DataLayer(iDataProvider), (IUniqueIndexLayer)new DefaultColumnHeaderDataLayer(iDataProvider2), (IUniqueIndexLayer)new DefaultRowHeaderDataLayer(iDataProvider3), (IUniqueIndexLayer)new DataLayer(iDataProvider4));
    }

    protected void init(IUniqueIndexLayer iUniqueIndexLayer, IUniqueIndexLayer iUniqueIndexLayer2, IUniqueIndexLayer iUniqueIndexLayer3, IUniqueIndexLayer iUniqueIndexLayer4) {
        this.bodyDataLayer = iUniqueIndexLayer;
        this.bodyLayer = new DefaultBodyLayerStack(iUniqueIndexLayer);
        this.selectionLayer = this.bodyLayer.getSelectionLayer();
        this.freezeLayer = new FreezeLayer((IUniqueIndexLayer)this.selectionLayer);
        CompositeFreezeLayer compositeFreezeLayer = new CompositeFreezeLayer(this.freezeLayer, this.bodyLayer.getViewportLayer(), this.selectionLayer);
        this.columnHeaderDataLayer = iUniqueIndexLayer2;
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer(iUniqueIndexLayer2, (ILayer)compositeFreezeLayer, this.selectionLayer);
        this.rowHeaderDataLayer = iUniqueIndexLayer3;
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer(iUniqueIndexLayer3, (ILayer)compositeFreezeLayer, this.selectionLayer);
        this.cornerDataLayer = iUniqueIndexLayer4;
        CornerLayer cornerLayer = new CornerLayer(iUniqueIndexLayer4, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        this.setBodyLayer((ILayer)compositeFreezeLayer);
        this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
        this.setRowHeaderLayer((ILayer)rowHeaderLayer);
        this.setCornerLayer((ILayer)cornerLayer);
    }

    private void refresh() {
        this.bodyDataLayer.fireLayerEvent((ILayerEvent)new StructuralRefreshEvent((ILayer)this.bodyDataLayer));
    }

    private void configureFreeze(boolean bl, boolean bl2) {
        ViewportLayer viewportLayer = this.bodyLayer.getViewportLayer();
        if (bl) {
            if (bl2) {
                this.freezeLayer.setTopLeftPosition(0, 0);
                this.freezeLayer.setBottomRightPosition(0, 0);
                viewportLayer.setMinimumOriginPosition(1, 1);
                viewportLayer.fireLayerEvent((ILayerEvent)new FreezeEvent((ILayer)viewportLayer));
            } else {
                this.freezeLayer.setTopLeftPosition(0, -1);
                this.freezeLayer.setBottomRightPosition(0, -1);
                viewportLayer.setMinimumOriginPosition(1, 0);
                viewportLayer.fireLayerEvent((ILayerEvent)new FreezeEvent((ILayer)viewportLayer));
            }
        } else if (bl2) {
            this.freezeLayer.setTopLeftPosition(-1, 0);
            this.freezeLayer.setBottomRightPosition(-1, 0);
            viewportLayer.setMinimumOriginPosition(0, 1);
            viewportLayer.fireLayerEvent((ILayerEvent)new FreezeEvent((ILayer)viewportLayer));
        } else {
            this.freezeLayer.setTopLeftPosition(-1, -1);
            this.freezeLayer.setBottomRightPosition(-1, -1);
            viewportLayer.resetOrigin();
            viewportLayer.fireLayerEvent((ILayerEvent)new UnfreezeEvent((ILayer)viewportLayer));
        }
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public DefaultBodyLayerStack getBodyLayer() {
        return this.bodyLayer;
    }

    public boolean isRowHeadersCustom() {
        return this.rowsCustom;
    }

    public boolean isColHeadersCustom() {
        return this.colsCustom;
    }

    public IDataProvider getDataProvider() {
        return this.bodyDataProvider;
    }
}

