/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObserver;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DataWindowOverlay;

public class DataWindowView
extends ViewPart
implements IObserver,
SelectionListener {
    private AxisValues xAxis;
    private AxisValues yAxis;
    private DataSetPlotter plotter;
    private DataWindowOverlay overlay;
    private String sId;
    private String id;
    private static final int MAXDISPLAYDIM = 1024;
    private Label lblStartX;
    private Label lblStartY;
    private Label lblXSampling;
    private Label lblYSampling;
    private Label lblEndX;
    private Label lblDelimiter;
    private Button btnOverwriteAspect;
    private Spinner spnStartX;
    private Spinner spnEndX;
    private Spinner spnStartY;
    private Spinner spnEndY;
    private Spinner spnXAspect;
    private Spinner spnYAspect;
    private Action allowUSampling;
    private CCombo ccXsampling;
    private CCombo ccYsampling;

    public String getId() {
        return this.id;
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.id = iViewSite.getId();
        this.sId = iViewSite.getSecondaryId();
        this.setPartName("SurfacePlotROI: " + this.sId);
    }

    private void buildActions(IToolBarManager iToolBarManager) {
        this.allowUSampling = new Action("", 2){

            public void run() {
                DataWindowView.this.overlay.setAllowUndersampling(DataWindowView.this.allowUSampling.isChecked());
                DataWindowView.this.ccXsampling.setEnabled(DataWindowView.this.allowUSampling.isChecked());
                DataWindowView.this.ccYsampling.setEnabled(DataWindowView.this.allowUSampling.isChecked());
                if (DataWindowView.this.ccXsampling.getSelectionIndex() == 0 && DataWindowView.this.ccXsampling.isEnabled()) {
                    DataWindowView.this.ccXsampling.select(1);
                    DataWindowView.this.overlay.setSamplingMode(1, DataWindowView.this.ccYsampling.getSelectionIndex());
                }
                if (DataWindowView.this.ccYsampling.getSelectionIndex() == 0 && DataWindowView.this.ccYsampling.isEnabled()) {
                    DataWindowView.this.ccYsampling.select(1);
                    DataWindowView.this.overlay.setSamplingMode(DataWindowView.this.ccXsampling.getSelectionIndex(), 1);
                }
            }
        };
        this.allowUSampling.setText("Allow undersampling");
        this.allowUSampling.setDescription("Allow select area to be undersampled");
        this.allowUSampling.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/arrow_in.png"));
        iToolBarManager.add((IAction)this.allowUSampling);
    }

    public void createPartControl(Composite composite) {
        this.buildActions(this.getViewSite().getActionBars().getToolBarManager());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 2;
        composite2.setLayout((Layout)gridLayout);
        this.plotter = new DataSetPlotter(PlottingMode.ONED, composite2, false);
        Composite composite3 = this.plotter.getComposite();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new FormLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 125;
        composite4.setLayoutData((Object)gridData);
        this.lblStartX = new Label(composite4, 0);
        FormData formData = new FormData();
        formData.height = 18;
        formData.width = 69;
        formData.top = new FormAttachment(0, 25);
        formData.left = new FormAttachment(0, 10);
        this.lblStartX.setLayoutData((Object)formData);
        this.lblStartX.setText("Start X:");
        this.spnStartX = new Spinner(composite4, 2048);
        formData = new FormData();
        formData.width = 62;
        formData.top = new FormAttachment((Control)this.lblStartX, 0, 128);
        formData.left = new FormAttachment((Control)this.lblStartX, 6);
        this.spnStartX.setLayoutData((Object)formData);
        this.spnStartX.setMinimum(0);
        this.spnStartX.addSelectionListener((SelectionListener)this);
        this.lblStartY = new Label(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartX, 15);
        formData.left = new FormAttachment((Control)this.lblStartX, 0, 16384);
        this.lblStartY.setLayoutData((Object)formData);
        this.lblStartY.setText("Start Y:");
        this.spnStartY = new Spinner(composite4, 2048);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.spnStartX, 0, 16384);
        formData.right = new FormAttachment((Control)this.spnStartX, 0, 131072);
        formData.top = new FormAttachment((Control)this.spnStartX, 6);
        this.spnStartY.setLayoutData((Object)formData);
        this.spnStartY.setMinimum(0);
        this.spnStartY.addSelectionListener((SelectionListener)this);
        this.lblEndX = new Label(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartX, 0, 128);
        formData.left = new FormAttachment((Control)this.spnStartX, 16);
        this.lblEndX.setLayoutData((Object)formData);
        this.lblEndX.setText("Width:");
        this.spnEndX = new Spinner(composite4, 2048);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartX, 0, 128);
        formData.left = new FormAttachment((Control)this.lblEndX, 16);
        formData.width = 69;
        this.spnEndX.setLayoutData((Object)formData);
        this.spnEndX.setMinimum(0);
        this.spnEndX.addSelectionListener((SelectionListener)this);
        formData = new Label(composite4, 0);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.lblStartY, 0, 128);
        formData2.right = new FormAttachment((Control)this.lblEndX, 0, 131072);
        formData.setLayoutData((Object)formData2);
        formData.setText("Height:");
        this.spnEndY = new Spinner(composite4, 2048);
        formData = new FormData();
        formData.right = new FormAttachment((Control)this.spnEndX, 0, 131072);
        formData.top = new FormAttachment((Control)this.spnStartY, 0, 128);
        formData.left = new FormAttachment((Control)this.spnEndX, 0, 16384);
        this.spnEndY.setLayoutData((Object)formData);
        this.spnEndY.setMinimum(0);
        this.spnEndY.addSelectionListener((SelectionListener)this);
        this.lblXSampling = new Label(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartX, 0, 128);
        formData.left = new FormAttachment((Control)this.spnEndX, 16);
        formData.width = 79;
        this.lblXSampling.setLayoutData((Object)formData);
        this.lblXSampling.setText("Sampling:");
        this.lblYSampling = new Label(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartY, 0, 128);
        formData.left = new FormAttachment((Control)this.spnEndY, 16);
        formData.width = 79;
        this.lblYSampling.setLayoutData((Object)formData);
        this.lblYSampling.setText("Sampling:");
        this.ccXsampling = new CCombo(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartX, 0, 128);
        formData.left = new FormAttachment((Control)this.lblXSampling, 16);
        formData.width = 120;
        this.ccXsampling.setLayoutData((Object)formData);
        this.ccXsampling.add("None");
        this.ccXsampling.add("Point");
        this.ccXsampling.add("Median");
        this.ccXsampling.add("Minimum");
        this.ccXsampling.add("Maximum");
        this.ccYsampling = new CCombo(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblStartY, 0, 128);
        formData.left = new FormAttachment((Control)this.lblYSampling, 16);
        formData.width = 120;
        this.ccYsampling.setLayoutData((Object)formData);
        this.ccYsampling.add("None");
        this.ccYsampling.add("Point");
        this.ccYsampling.add("Median");
        this.ccYsampling.add("Minimum");
        this.ccYsampling.add("Maximum");
        this.btnOverwriteAspect = new Button(composite4, 32);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblYSampling, 40, 128);
        formData.left = new FormAttachment(0, 20);
        formData.width = 175;
        this.btnOverwriteAspect.setLayoutData((Object)formData);
        this.btnOverwriteAspect.setText("Overwrite Aspect-Ratio");
        this.btnOverwriteAspect.addSelectionListener((SelectionListener)this);
        this.spnXAspect = new Spinner(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblYSampling, 40, 128);
        formData.left = new FormAttachment((Control)this.btnOverwriteAspect, 16);
        this.spnXAspect.setLayoutData((Object)formData);
        this.spnXAspect.setEnabled(false);
        this.spnXAspect.setMinimum(1);
        this.spnXAspect.setMaximum(10);
        this.spnXAspect.setSelection(1);
        this.spnXAspect.setIncrement(1);
        this.spnXAspect.addSelectionListener((SelectionListener)this);
        this.lblDelimiter = new Label(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblYSampling, 40, 128);
        formData.left = new FormAttachment((Control)this.spnXAspect, 5);
        this.lblDelimiter.setLayoutData((Object)formData);
        this.lblDelimiter.setText(":");
        this.spnYAspect = new Spinner(composite4, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblYSampling, 40, 128);
        formData.left = new FormAttachment((Control)this.lblDelimiter, 5);
        this.spnYAspect.setLayoutData((Object)formData);
        this.spnYAspect.setEnabled(false);
        this.spnYAspect.setMinimum(1);
        this.spnYAspect.setMaximum(10);
        this.spnYAspect.setSelection(1);
        this.spnYAspect.setIncrement(1);
        this.spnYAspect.addSelectionListener((SelectionListener)this);
        this.ccXsampling.select(0);
        this.ccYsampling.select(0);
        this.ccXsampling.setEnabled(false);
        this.ccYsampling.setEnabled(false);
        this.ccXsampling.addSelectionListener((SelectionListener)this);
        this.ccYsampling.addSelectionListener((SelectionListener)this);
        this.plotter.setMode(PlottingMode.TWOD);
        this.plotter.setAxisModes(AxisMode.CUSTOM, AxisMode.CUSTOM, AxisMode.LINEAR);
        this.overlay = new DataWindowOverlay(1, 1, this);
        this.plotter.registerOverlay(this.overlay);
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
    }

    public void setFocus() {
    }

    public void setData(IDataset iDataset, AxisValues axisValues, AxisValues axisValues2) {
        if (iDataset != null) {
            this.xAxis.clear();
            this.yAxis.clear();
            final int n = iDataset.getShape()[1];
            final int n2 = iDataset.getShape()[0];
            int n3 = Math.max(1, n / 1024);
            int n4 = Math.max(1, n2 / 1024);
            int[] nArray = new int[2];
            int[] nArray2 = new int[]{iDataset.getShape()[0], iDataset.getShape()[1]};
            int[] nArray3 = new int[]{n4, n3};
            IDataset iDataset2 = iDataset.getSlice(nArray, nArray2, nArray3);
            if (axisValues == null || axisValues.size() == 0) {
                this.xAxis.setValues(AbstractDataset.arange((double)0.0, (double)n, (double)n3, (int)3));
            } else {
                this.xAxis.setValues((AbstractDataset)axisValues.subset(0, n, n3).toDataset());
            }
            if (axisValues2 == null || axisValues2.size() == 0) {
                this.yAxis.setValues(AbstractDataset.arange((double)0.0, (double)n2, (double)n4, (int)3));
            } else {
                this.yAxis.setValues((AbstractDataset)axisValues2.subset(0, n2, n4).toDataset());
            }
            this.overlay.removePrimitives();
            this.overlay.setScaling(n3, n4);
            this.plotter.setXAxisValues(this.xAxis, 1);
            this.plotter.setYAxisValues(this.yAxis);
            try {
                this.plotter.replaceCurrentPlot(iDataset2);
            }
            catch (PlotException plotException) {}
            this.plotter.getComposite().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataWindowView.this.spnEndX.setMaximum(n);
                    DataWindowView.this.spnEndY.setMaximum(n2);
                    DataWindowView.this.spnStartX.setMaximum(n);
                    DataWindowView.this.spnStartY.setMaximum(n2);
                    if (n * n2 > DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM) {
                        float f = (float)(DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM) / (float)(n * n2);
                        float f2 = (float)n / (float)(n + n2);
                        float f3 = (float)n2 / (float)(n + n2);
                        float f4 = 1.0f - (1.0f - f) * f2;
                        float f5 = 1.0f - (1.0f - f) * f3;
                        int n3 = (int)((float)n * f4 * 0.75f);
                        int n22 = (int)((float)n2 * f5 * 0.75f);
                        DataWindowView.this.spnEndX.setSelection(n3);
                        DataWindowView.this.spnEndY.setSelection(n22);
                        DataWindowView.this.overlay.setSelectPosition(0, 0, n3, n22);
                    } else {
                        DataWindowView.this.spnEndX.setSelection(n);
                        DataWindowView.this.spnEndY.setSelection(n2);
                    }
                    DataWindowView.this.plotter.refresh(false);
                    DataWindowView.this.spnStartX.setSelection(0);
                    DataWindowView.this.spnStartY.setSelection(0);
                }
            });
        }
    }

    public void setSpinnerValues(final int n, final int n2, final int n3, final int n4) {
        this.plotter.getComposite().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataWindowView.this.spnStartX.setSelection(n);
                DataWindowView.this.spnStartY.setSelection(n2);
                DataWindowView.this.spnEndX.setSelection(n3);
                DataWindowView.this.spnEndY.setSelection(n4);
            }
        });
    }

    public void update(Object object, Object object2) {
        HistogramUpdate histogramUpdate = (HistogramUpdate)object2;
        this.plotter.applyColourCast(histogramUpdate.getRedMapFunction(), histogramUpdate.getGreenMapFunction(), histogramUpdate.getBlueMapFunction(), histogramUpdate.getAlphaMapFunction(), histogramUpdate.inverseRed(), histogramUpdate.inverseGreen(), histogramUpdate.inverseBlue(), histogramUpdate.inverseAlpha(), histogramUpdate.getMinValue(), histogramUpdate.getMaxValue());
        this.plotter.refresh(false);
    }

    public void addIObserver(IObserver iObserver) {
        if (this.overlay != null) {
            this.overlay.addIObserver(iObserver);
        }
    }

    public void deleteIObserver(IObserver iObserver) {
        if (this.overlay != null) {
            this.overlay.deleteIObserver(iObserver);
        }
    }

    public void deleteIObservers() {
        if (this.overlay != null) {
            this.overlay.deleteIObservers();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.overlay != null) {
            if (!(selectionEvent.getSource().equals(this.ccXsampling) || selectionEvent.getSource().equals(this.ccYsampling) || selectionEvent.getSource().equals(this.btnOverwriteAspect))) {
                int n = this.spnStartX.getSelection();
                int n2 = this.spnStartY.getSelection();
                int n3 = this.spnEndX.getSelection();
                int n4 = this.spnEndY.getSelection();
                if (n + n3 > this.spnEndX.getMaximum()) {
                    n3 = this.spnEndX.getMaximum() - n;
                }
                if (n2 + n4 > this.spnEndY.getMaximum()) {
                    n4 = this.spnEndY.getMaximum() - n2;
                }
                this.overlay.setAspects(this.btnOverwriteAspect.getSelection() ? this.spnXAspect.getSelection() : 0, this.btnOverwriteAspect.getSelection() ? this.spnYAspect.getSelection() : 0);
                this.overlay.setSelectPosition(n, n2, n3, n4);
            } else if (selectionEvent.getSource().equals(this.ccXsampling) || selectionEvent.getSource().equals(this.ccYsampling)) {
                this.overlay.setSamplingMode(this.ccXsampling.getSelectionIndex(), this.ccYsampling.getSelectionIndex());
            } else if (selectionEvent.getSource().equals(this.btnOverwriteAspect)) {
                this.spnXAspect.setEnabled(this.btnOverwriteAspect.getSelection());
                this.spnYAspect.setEnabled(this.btnOverwriteAspect.getSelection());
                if (this.btnOverwriteAspect.getSelection()) {
                    this.overlay.setAspects(this.spnXAspect.getSelection(), this.spnYAspect.getSelection());
                } else {
                    this.overlay.setAspects(0, 0);
                }
            }
        }
    }

    public void dispose() {
        if (!this.spnStartX.isDisposed()) {
            this.spnStartX.removeSelectionListener((SelectionListener)this);
        }
        if (!this.spnStartY.isDisposed()) {
            this.spnStartY.removeSelectionListener((SelectionListener)this);
        }
        if (!this.spnEndX.isDisposed()) {
            this.spnEndX.removeSelectionListener((SelectionListener)this);
        }
        if (!this.spnEndY.isDisposed()) {
            this.spnEndY.removeSelectionListener((SelectionListener)this);
        }
        if (!this.ccXsampling.isDisposed()) {
            this.ccXsampling.removeSelectionListener((SelectionListener)this);
        }
        if (!this.ccYsampling.isDisposed()) {
            this.ccYsampling.removeSelectionListener((SelectionListener)this);
        }
        this.deleteIObservers();
        if (this.plotter != null) {
            this.plotter.cleanUp();
        }
    }
}

