/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;

public class AsciiTextView
extends ViewPart {
    private static final Logger logger = LoggerFactory.getLogger(AsciiTextView.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.results.navigator.AsciiTextView";
    private Text text;
    private boolean monitoringFile = false;
    private File file;
    private Timer timer;
    private Action saveAction;

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout(256));
        this.text = new Text(composite2, 536873738);
        this.text.setFont(SWTResourceManager.getFont("Courier New", 10, 0));
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    private void createActions() {
        this.saveAction = new Action(){

            public void run() {
                AsciiTextView.this.saveText();
            }
        };
        this.saveAction.setToolTipText("Save text");
        this.saveAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/script_save.png"));
    }

    private void initializeToolBar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.saveAction);
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void load(File file) {
        this.monitoringFile = false;
        this.updateMonitoring();
        this.setPartName(file.getName());
        this.file = file;
        this.refreshFile();
    }

    public void setData(String string) {
        this.text.setText(string);
    }

    public void saveText() {
        FileDialog fileDialog = new FileDialog(this.getSite().getShell(), 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setFileName("text.txt");
        fileDialog.setFilterExtensions(new String[]{".txt"});
        fileDialog.setFilterNames(new String[]{"Ascii text"});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        try {
            final PrintStream printStream = new PrintStream(string);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    printStream.append(AsciiTextView.this.text.getText());
                    printStream.close();
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private String refreshFile() {
        try {
            String string = FileUtils.readFileToString((File)this.file);
            this.text.setText(string);
            return string;
        }
        catch (IOException iOException) {
            logger.error("Cannot read file " + this.file, (Throwable)iOException);
            return "";
        }
    }

    public void toggleMonitor() {
        this.monitoringFile = !this.monitoringFile;
        this.updateMonitoring();
    }

    private void updateMonitoring() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = iToolBarManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            CommandContributionItem commandContributionItem;
            if (iContributionItemArray[n] instanceof CommandContributionItem && (commandContributionItem = (CommandContributionItem)iContributionItemArray[n]).getId().equals("uk.ac.diamond.scisoft.analysis.rcp.monitorAscii")) {
                try {
                    Method method = CommandContributionItem.class.getDeclaredMethod("setChecked", Boolean.TYPE);
                    method.setAccessible(true);
                    method.invoke((Object)commandContributionItem, this.monitoringFile);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        if (this.monitoringFile) {
            this.timer = new Timer("Update text timer", false);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AsciiTextView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String string = AsciiTextView.this.refreshFile();
                            AsciiTextView.this.text.setSelection(string.lastIndexOf(10) + 1);
                        }
                    });
                }
            }, 0L, 5000L);
        } else if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

