/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotMode;

public class PlotUtils {
    private static final Logger logger = LoggerFactory.getLogger(PlotUtils.class);

    public static void create1DPlot(AbstractDataset abstractDataset, List<AbstractDataset> list, final PlotMode plotMode, final PlotWindow plotWindow, final IProgressMonitor iProgressMonitor) {
        AbstractDataset abstractDataset2;
        List<AbstractDataset> list2;
        if (abstractDataset.getRank() != 1) {
            return;
        }
        if (list == null) {
            list2 = new ArrayList<AbstractDataset>(1);
            list2.add(abstractDataset);
            abstractDataset2 = DoubleDataset.arange((double)list2.get(0).getSize());
        } else {
            abstractDataset2 = abstractDataset;
            list2 = list;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    plotWindow.updatePlotMode(plotMode.getGuiPlotMode());
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    GuiBean guiBean = new GuiBean();
                    guiBean.put(GuiParameters.PLOTMODE, (Serializable)plotMode.getGuiPlotMode());
                    guiBean.put(GuiParameters.TITLE, PlotUtils.getTitle(abstractDataset2, list2, true));
                    plotWindow.processGUIUpdate(guiBean);
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    DataBean dataBean = new DataBean(plotMode.getGuiPlotMode());
                    dataBean.addAxis("x-axis", (IDataset)abstractDataset2);
                    if (PlotMode.PM3D == plotMode) {
                        DoubleDataset doubleDataset = new DoubleDataset(new double[]{-15.0, 1.0, 200.0}, new int[0]);
                        dataBean.addAxis("z-axis", (IDataset)doubleDataset);
                    }
                    int n = 0;
                    while (n < list2.size()) {
                        try {
                            dataBean.addData(DataSetWithAxisInformation.createAxisDataSet((IDataset)((IDataset)list2.get(n))));
                            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                                return;
                            }
                        }
                        catch (DataBeanException dataBeanException) {
                            logger.error("Problem adding data to bean as axis key does not exist", (Throwable)dataBeanException);
                        }
                        ++n;
                    }
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    plotWindow.processPlotUpdate(dataBean);
                }
                catch (Exception exception) {
                    logger.error("Cannot create plot required.", (Throwable)exception);
                }
            }
        });
    }

    public static void createPlot(final AbstractDataset abstractDataset, final List<AbstractDataset> list, final GuiPlotMode guiPlotMode, final PlotWindow plotWindow, final IProgressMonitor iProgressMonitor) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    plotWindow.updatePlotMode(guiPlotMode);
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    GuiBean guiBean = new GuiBean();
                    guiBean.put(GuiParameters.PLOTMODE, (Serializable)guiPlotMode);
                    guiBean.put(GuiParameters.TITLE, (Serializable)((Object)abstractDataset.getName()));
                    plotWindow.processGUIUpdate(guiBean);
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    DataBean dataBean = new DataBean(guiPlotMode);
                    DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
                    AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
                    dataBean.addAxis("x-axis", (IDataset)list.get(0));
                    dataBean.addAxis("y-axis", (IDataset)list.get(1));
                    int[] nArray = new int[2];
                    nArray[0] = 1;
                    dataSetWithAxisInformation.setData((IDataset)DatasetUtils.transpose((IDataset)abstractDataset, (int[])nArray));
                    dataSetWithAxisInformation.setAxisMap(axisMapBean);
                    dataBean.addData(dataSetWithAxisInformation);
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    plotWindow.processPlotUpdate(dataBean);
                }
                catch (Exception exception) {
                    logger.error("Cannot create plot required.", (Throwable)exception);
                }
            }
        });
    }

    private static Serializable getTitle(AbstractDataset abstractDataset, List<AbstractDataset> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Plot of");
        HashSet<String> hashSet = new HashSet<String>(7);
        for (IDataset iDataset : list) {
            Matcher matcher;
            String string = iDataset.getName();
            if (bl && (matcher = Pattern.compile("(.*) \\(.*\\)").matcher(string)).matches()) {
                string = matcher.group(1);
            }
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            stringBuilder.append(" ");
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        int n = stringBuilder.length() - 1;
        stringBuilder.delete(n, n + 1);
        stringBuilder.append(" against ");
        stringBuilder.append(abstractDataset.getName());
        return stringBuilder.toString();
    }
}

