/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.util;

import java.io.File;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.gda.common.rcp.util.BundleUtils;

public class JythonInterpreterUtils {
    private static Logger logger = LoggerFactory.getLogger(JythonInterpreterUtils.class);

    static {
        PySystemState.initialize();
    }

    public static PythonInterpreter getInterpreter() throws Exception {
        File file;
        File file2;
        long l = System.currentTimeMillis();
        logger.debug("Starting new Jython Interpreter.");
        PySystemState pySystemState = new PySystemState();
        ClassLoader classLoader = PlotServer.class.getClassLoader();
        pySystemState.setClassLoader(classLoader);
        try {
            file2 = BundleUtils.getBundleLocation((String)"uk.ac.gda.libs");
        }
        catch (Exception exception) {
            file2 = null;
        }
        if (file2 == null) {
            if (System.getProperty("test.libs.location") == null) {
                throw new Exception("Please set the property 'test.libs.location' for this test to work!");
            }
            file2 = new File(System.getProperty("test.libs.location"));
        }
        String string = String.valueOf(file2.getAbsolutePath()) + "/jython2.5.1/Lib/";
        pySystemState.path.append((PyObject)new PyString(string));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "dist-utils"));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "site-packages"));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "site-packages/decorator-3.2.0-py2.5.egg"));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "nose-0.11.1-py2.5.egg/nose/ext"));
        try {
            file = new File(file2.getParentFile(), "uk.ac.diamond.scisoft.python");
            pySystemState.path.append((PyObject)new PyString(new File(file, "bin").getAbsolutePath()));
        }
        catch (Exception exception) {
            logger.error("Could not find Scisoft Python plugin", (Throwable)exception);
        }
        file = new PythonInterpreter((PyObject)new PyStringMap(), pySystemState);
        file.exec("import scisoftpy as dnp");
        long l2 = System.currentTimeMillis();
        logger.debug("Created new Jython Interpreter in " + (l2 - l) + "ms.");
        return file;
    }
}

