/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class FloatSpinner
extends Composite {
    private int width;
    private int precision;
    private int maximumValue;
    private double factor;
    private Spinner spinner;
    private List<SelectionListener> listeners;
    private SelectionAdapter sListener;

    public FloatSpinner(Composite composite, int n) {
        this(composite, n, 3, 1);
    }

    public FloatSpinner(Composite composite, int n, int n2, int n3) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.spinner = new Spinner((Composite)this, n);
        this.setFormat(n2, n3);
        this.listeners = new ArrayList<SelectionListener>();
        this.sListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FloatSpinner.this.notifySelectionListeners(selectionEvent);
            }
        };
        this.spinner.addSelectionListener((SelectionListener)this.sListener);
    }

    protected void notifySelectionListeners(SelectionEvent selectionEvent) {
        for (SelectionListener selectionListener : this.listeners) {
            selectionListener.widgetSelected(selectionEvent);
        }
    }

    public void setFormat(int n, int n2) {
        this.precision = n2;
        this.setWidth(n);
        this.maximumValue = (int)Math.pow(10.0, n);
        this.factor = Math.pow(10.0, n2);
        this.spinner.setDigits(n2);
        this.spinner.setMinimum(-this.maximumValue);
        this.spinner.setMaximum(this.maximumValue);
        this.spinner.setIncrement(1);
        this.spinner.setPageIncrement(5);
        this.spinner.setSelection(0);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setDouble(double d) {
        this.spinner.setSelection((int)(d * this.factor));
    }

    public double getDouble() {
        return (double)this.spinner.getSelection() / this.factor;
    }

    public double getRange() {
        double d = (double)this.spinner.getMinimum() / this.factor;
        double d2 = (double)this.spinner.getMaximum() / this.factor;
        return d2 - d;
    }

    public double getMinimum() {
        return (double)this.spinner.getMinimum() / this.factor;
    }

    public double getMaximum() {
        return (double)this.spinner.getMaximum() / this.factor;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }

    public void setMinimum(double d) {
        this.spinner.setMinimum((int)(d * this.factor));
    }

    public void setMaximum(double d) {
        this.spinner.setMaximum((int)(d * this.factor));
    }

    public void dispose() {
        this.listeners = null;
        if (!this.spinner.isDisposed()) {
            this.spinner.removeSelectionListener((SelectionListener)this.sListener);
        }
    }

    public Composite getControl() {
        return this.spinner;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.spinner.setEnabled(bl);
    }
}

